/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.point;

import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.INiagaraProxyExt;

public final class NiagaraProxyExtSupport {
    private static final Object messageIdLock = new Object();
    private static int nextMessageId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void subscribed(INiagaraProxyExt proxyExt) {
        Object object = proxyExt.getStateLock();
        synchronized (object) {
            NiagaraProxyExtSupport.transition(proxyExt, proxyExt.getSubscriptionState().subscribe());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unsubscribed(INiagaraProxyExt proxyExt) {
        Object object = proxyExt.getStateLock();
        synchronized (object) {
            NiagaraProxyExtSupport.transition(proxyExt, proxyExt.getSubscriptionState().unsubscribe());
        }
    }

    public static void sendingSubscribe(INiagaraProxyExt proxyExt) {
        NiagaraProxyExtSupport.transition(proxyExt, proxyExt.getSubscriptionState().sendingSubscribe());
    }

    public static void sentSubscribe(INiagaraProxyExt proxyExt) {
        NiagaraProxyExtSupport.transition(proxyExt, proxyExt.getSubscriptionState().sentSubscribe());
    }

    public static void sendingUnsubscribe(INiagaraProxyExt proxyExt) {
        NiagaraProxyExtSupport.transition(proxyExt, proxyExt.getSubscriptionState().sendingUnsubscribe());
    }

    public static void sentUnsubscribe(INiagaraProxyExt proxyExt) {
        NiagaraProxyExtSupport.transition(proxyExt, proxyExt.getSubscriptionState().sentUnsubscribe());
    }

    public static void pendingSubscribe(INiagaraProxyExt proxyExt) {
        NiagaraProxyExtSupport.transition(proxyExt, BSubscriptionState.pendingSubscribe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSubscriptionError(INiagaraProxyExt proxyExt, String error) {
        Object object = proxyExt.getStateLock();
        synchronized (object) {
            String currentError = proxyExt.getSubscriptionError();
            if (currentError == error) {
                return;
            }
            if (error != null && currentError != null && currentError.equals(error)) {
                return;
            }
            proxyExt.commitSubscriptionError(error);
            NiagaraProxyExtSupport.updateSubscriptionStatus(proxyExt, error);
        }
    }

    public static void proxyError(INiagaraProxyExt proxyExt) {
        NiagaraProxyExtSupport.transition(proxyExt, BSubscriptionState.proxyError);
    }

    private static void transition(INiagaraProxyExt proxyExt, BSubscriptionState state) {
        proxyExt.setSubscriptionState(state);
        NiagaraProxyExtSupport.updateSubscriptionStatus(proxyExt, proxyExt.getSubscriptionError());
    }

    private static void updateSubscriptionStatus(INiagaraProxyExt proxyExt, String currentError) {
        BSubscriptionState currentState = proxyExt.getSubscriptionState();
        String status = currentState.toString();
        if (currentError != null) {
            status = currentState == BSubscriptionState.subscribed ? status + " Err: " + currentError : status + ": " + currentError;
        }
        proxyExt.setProxySubscriptionStatus(status);
        if (currentError != null) {
            proxyExt.readFail(currentError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(INiagaraProxyExt proxyExt) {
        Object object = proxyExt.getStateLock();
        synchronized (object) {
            BSubscriptionState closedState = proxyExt.getSubscriptionState().closed();
            proxyExt.setSubscriptionState(closedState);
            if (closedState != BSubscriptionState.proxyError) {
                proxyExt.setSubscriptionError(null);
            }
            NiagaraProxyExtSupport.updateSubscriptionStatus(proxyExt, proxyExt.getSubscriptionError());
        }
    }

    public static String toTraceString(INiagaraProxyExt proxyExt) {
        String stationName = "???";
        try {
            stationName = proxyExt.getStationName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + proxyExt.getMessageId() + "] " + stationName + "::" + proxyExt.getPointId();
    }

    public static int getMessageId(INiagaraProxyExt proxyExt) {
        return proxyExt.getMessageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int newMessageId() {
        Object object = messageIdLock;
        synchronized (object) {
            if (++nextMessageId == Integer.MAX_VALUE) {
                nextMessageId = Integer.MIN_VALUE;
            }
            return nextMessageId;
        }
    }
}

