/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BINiagaraVirtualPropertySubstitute;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.BSlotType;
import com.tridium.nv.NiagaraVirtualPropertyHandler;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.point.BVirtualAction;
import java.util.Optional;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.status.BStatusString;
import javax.baja.sys.AlreadyParentedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;

final class NiagaraVirtualAddOp {
    private BSlotInfo info;
    private String virtualSlotName;
    private Optional<BNiagaraVirtualComponent> vCompAdded = Optional.empty();

    private NiagaraVirtualAddOp(BSlotInfo info, String virtualSlotName) {
        this.info = info;
        this.virtualSlotName = virtualSlotName;
    }

    static NiagaraVirtualAddOp make(BSlotInfo info, String virtualSlotName) {
        return new NiagaraVirtualAddOp(info, virtualSlotName);
    }

    private BValue makeValue(BNiagaraVirtualComponent vParent, BFacets newFacets) {
        Object val = null;
        if (this.info.getIsComponent()) {
            BNiagaraVirtualComponent vComp;
            val = vComp = BNiagaraVirtualComponent.make(BTypeSpec.make((String)this.info.getTypeSpec()));
            vComp.getNiagaraVirtualCompInfo().setTypeSpec(this.info.getTypeSpec());
            if (this.info.getSlotOrd().isNull()) {
                vComp.getNiagaraVirtualCompInfo().setSlotOrd(NiagaraVirtualUtil.addSlotNameToOrd(vParent.getNiagaraVirtualCompInfo().getSlotOrd(), this.info.getSlotName()));
            } else {
                vComp.getNiagaraVirtualCompInfo().setSlotOrd(this.info.getSlotOrd());
            }
            vComp.makeIcon(this.info.getSlotIcon());
            vComp.setMappedToNiagaraVirtual(this.info.getIsNiagaraVirtual());
        } else if (this.info.getSlotType().isAction()) {
            Type paramType = null;
            if (this.info.getTypeSpec().length() > 0) {
                try {
                    paramType = Sys.getType((String)this.info.getTypeSpec());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Type returnType = null;
            if (this.info.getReturnTypeSpec().length() > 0) {
                try {
                    returnType = Sys.getType((String)this.info.getReturnTypeSpec());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            val = new BVirtualAction(this.info.getSlotName(), "", returnType, paramType, this.info.getSlotFlags(), BFacets.make((BFacets)this.info.getFacets(), (BFacets)newFacets));
        } else {
            val = this.info.getDefaultValue();
            if (val == null) {
                try {
                    val = (BValue)Sys.getType((String)this.info.getTypeSpec()).getInstance();
                }
                catch (Exception e) {
                    val = new BStatusString();
                }
            }
        }
        return val;
    }

    private BFacets makeFacets() {
        BFacets facets = this.info.getFacets();
        facets = BFacets.make((BFacets)facets, (String)"nVirtualFroz", (BIDataValue)BBoolean.make((boolean)this.info.getIsFrozen()));
        if (!this.virtualSlotName.equals(this.info.getSlotName())) {
            facets = BFacets.make((BFacets)facets, (String)"nVirtualSN", (BIDataValue)BString.make((String)this.info.getSlotName()));
        }
        if (this.info.getIsComponent()) {
            facets = BFacets.make((BFacets)facets, (String)"nVirtualTS", (BIDataValue)BString.make((String)this.info.getTypeSpec()));
        }
        return facets;
    }

    private int makeSlotFlags(BValue val, BFacets facets) {
        int flags = 0;
        flags = !this.info.getIsComponent() ? (this.info.getSlotType() == BSlotType.property ? (!this.info.getIsWritable() ? this.info.getSlotFlags() | 1 : NiagaraVirtualUtil.getVirtualFlags(val, this.info.getSlotFlags(), facets)) : this.info.getSlotFlags()) : this.info.getSlotFlags() | 0x2000;
        return flags & 0xFFFFFFFD;
    }

    Property run(BNiagaraVirtualComponent vParent) {
        BFacets facets = this.makeFacets();
        BValue val = this.makeValue(vParent, facets);
        if (val instanceof BINiagaraVirtualPropertySubstitute) {
            BINiagaraVirtualPropertySubstitute sub = (BINiagaraVirtualPropertySubstitute)val;
            sub.nvRead(vParent, val, NiagaraVirtualPropertyHandler.readUpdateContext);
            facets = sub.nvFilterFacets(facets);
        } else {
            try {
                Type t = Sys.getType((String)this.info.getTypeSpec());
                AgentList list = Sys.getRegistry().getAgents(t.getTypeInfo()).filter(AgentFilter.is((Type)BINiagaraVirtualPropertySubstitute.TYPE));
                if (list.size() > 0) {
                    BINiagaraVirtualPropertySubstitute sub = (BINiagaraVirtualPropertySubstitute)list.getDefault().getInstance();
                    sub.nvRead(vParent, val, NiagaraVirtualPropertyHandler.readUpdateContext);
                    facets = sub.nvFilterFacets(facets);
                    val = (BValue)sub;
                }
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        int flags = this.makeSlotFlags(val, facets);
        BFormat displayName = this.info.getSlotDisplayName();
        if (vParent.getProperty(this.virtualSlotName) == null && vParent.checkVirtualAdd(this.info, val, facets, flags)) {
            NiagaraVirtualUtil.updateDisplayNames((BComponent)vParent, this.virtualSlotName, displayName);
            try {
                Property prop = vParent.add(this.virtualSlotName, val, flags, facets, null);
                if (val instanceof BNiagaraVirtualComponent) {
                    this.vCompAdded = Optional.of((BNiagaraVirtualComponent)val);
                }
                return prop;
            }
            catch (AlreadyParentedException alreadyParentedException) {
            }
            catch (DuplicateSlotException duplicateSlotException) {
                // empty catch block
            }
        }
        return null;
    }

    Optional<BNiagaraVirtualComponent> getAddedComponent() {
        return this.vCompAdded;
    }
}

