/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.saml.ui.idp;

import com.tridium.saml.idp.BCircleOfTrust;
import com.tridium.saml.idp.BCircleOfTrustFolder;
import com.tridium.saml.idp.BPrototypesFolder;
import com.tridium.saml.idp.BSAMLCoTPrototypesMixIn;
import com.tridium.saml.idp.BSAMLIdPService;
import com.tridium.workbench.fieldeditors.BDialogFE;
import com.tridium.workbench.util.WbUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="prototypesModified")
public class BUserCOTPrototypesFE
extends BDialogFE {
    @Generated
    public static final Action prototypesModified = BUserCOTPrototypesFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUserCOTPrototypesFE.class);
    private static final Lexicon LEX = Lexicon.make(BUserCOTPrototypesFE.class);
    private BPrototypesFolder prototypesFolder;
    private Set<String> currentPrototypes;
    private final BFlowPane pane = new BFlowPane();
    private BCheckList prototypes;
    private BWidget editButton;
    private BCheckList editDialogPrototypes;
    private boolean readonly;
    private static final int DISPLAY_TOP_PROTOTYPES = 10;
    private static final int DISPLAY_ALL_PROTOTYPES = -1;
    private static final ThreadLocal<Boolean> MODIFY_IN_PROGRESS = new ThreadLocal();

    @Generated
    public void prototypesModified() {
        this.invoke(prototypesModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUserCOTPrototypesFE() {
        this.setContent((BWidget)this.pane);
    }

    public void doSetReadonly(boolean readonly) {
        super.doSetReadonly(readonly);
        this.readonly = readonly;
        this.relayout();
    }

    protected void doLoadValue(BObject v, Context cx) {
        BSAMLIdPService samlIdpService;
        BObject cotNameFacet;
        if (!(v instanceof BString)) {
            return;
        }
        if (this.currentPrototypes != null && MODIFY_IN_PROGRESS.get() == Boolean.TRUE) {
            return;
        }
        this.currentPrototypes = BSAMLCoTPrototypesMixIn.splitPrototypes((String)v.toString(), (boolean)true);
        String cotName = null;
        if (cx != null && (cotNameFacet = cx.getFacet("circleOfTrustName")) instanceof BString) {
            cotName = cotNameFacet.toString();
        }
        if (cotName != null && (samlIdpService = (BSAMLIdPService)WbUtil.findService((BWidget)this, (Type)BSAMLIdPService.TYPE)) != null) {
            samlIdpService.lease();
            BCircleOfTrustFolder cotFolder = samlIdpService.getCircleOfTrustFolder();
            cotFolder.lease();
            BValue cot = cotFolder.get(cotName);
            if (cot instanceof BCircleOfTrust) {
                BCircleOfTrust circleOfTrust = (BCircleOfTrust)cot;
                circleOfTrust.lease();
                this.prototypesFolder = circleOfTrust.getPrototypes();
                this.prototypesFolder.lease();
            }
        }
        this.setupView(this.currentPrototypes, this.prototypesFolder);
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        return BString.make((String)BUserCOTPrototypesFE.delimitSelected(this.prototypes));
    }

    public void doPrototypesModified() {
        try {
            MODIFY_IN_PROGRESS.set(Boolean.TRUE);
            this.setModified();
        }
        finally {
            MODIFY_IN_PROGRESS.remove();
        }
    }

    private void addCheckList() {
        if (this.prototypes == null) {
            this.prototypes = new BCheckList();
            this.prototypes.setEnabled(!this.readonly);
            this.prototypes.setController((ListController)new PrototypeListController(this));
            if (!this.readonly || !this.currentPrototypes.isEmpty()) {
                this.pane.add(null, (BValue)this.prototypes);
            }
        }
        this.prototypes.getSelection().deselectAll();
        this.prototypes.getModel().removeAllItems();
    }

    private void addEditButton() {
        if (this.editButton == null) {
            this.editButton = this.getEditButton();
            this.getEditButton().computePreferredSize();
            this.pane.add(null, (BValue)this.editButton);
        }
    }

    private void setupView(Set<String> currentPrototypes, BPrototypesFolder folder) {
        this.addCheckList();
        BUserCOTPrototypesFE.addCurrentPrototypes(this.prototypes, currentPrototypes);
        if (folder != null && !this.readonly) {
            this.addEditButton();
            BUserCOTPrototypesFE.addTopPrototypesFrom(this.prototypes, folder, currentPrototypes);
        }
        this.linkTo((BComponent)this.prototypes, (Slot)BList.selectionModified, (Slot)prototypesModified);
        this.relayout();
    }

    private static void addCurrentPrototypes(BCheckList prototypes, Set<String> currentPrototypes) {
        int i = 0;
        for (String prototype : currentPrototypes) {
            prototypes.getModel().addItem((Object)prototype);
            prototypes.getSelection().select(i++);
        }
    }

    private static void addTopPrototypesFrom(BCheckList prototypes, BPrototypesFolder folder, Set<String> currentPrototypes) {
        BUserCOTPrototypesFE.addPrototypesFrom(prototypes, folder, currentPrototypes, 10);
    }

    private static void addPrototypesFrom(BCheckList prototypes, BPrototypesFolder folder, Set<String> currentPrototypes, int maxPrototypes) {
        if (folder == null) {
            return;
        }
        int prototypesAdded = 0;
        int maxPrototypesToAdd = maxPrototypes - currentPrototypes.size();
        folder.lease();
        Iterator availablePrototypes = Arrays.stream(folder.getChildren(BString.class)).map(proto -> SlotPath.unescape((String)proto.toString())).sorted().iterator();
        while (availablePrototypes.hasNext() && (maxPrototypes == -1 || prototypesAdded < maxPrototypesToAdd)) {
            String prototype = (String)availablePrototypes.next();
            if (currentPrototypes.contains(prototype)) continue;
            prototypes.getModel().addItem((Object)prototype);
            prototypes.getSelection().deselect(prototypes.getModel().indexOfItem((Object)prototype));
            ++prototypesAdded;
        }
    }

    public void doEditPressed() {
        BEdgePane pane = new BEdgePane();
        this.editDialogPrototypes = new BCheckList();
        pane.setCenter((BWidget)this.editDialogPrototypes);
        Set dirtyPrototypes = BSAMLCoTPrototypesMixIn.splitPrototypes((String)BUserCOTPrototypesFE.delimitSelected(this.prototypes), (boolean)true);
        BUserCOTPrototypesFE.addCurrentPrototypes(this.editDialogPrototypes, dirtyPrototypes);
        BUserCOTPrototypesFE.addPrototypesFrom(this.editDialogPrototypes, this.prototypesFolder, dirtyPrototypes, -1);
        int retVal = BDialog.open((BWidget)this, (String)LEX.getText("userCOTPrototypesFE.editPrototypes"), (Object)pane, (int)3);
        if (retVal == 1) {
            Set prototypesFromEditDialog = BSAMLCoTPrototypesMixIn.splitPrototypes((String)BUserCOTPrototypesFE.delimitSelected(this.editDialogPrototypes), (boolean)true);
            if (this.currentPrototypes != null) {
                boolean prototypesChanged;
                boolean bl = prototypesChanged = !this.currentPrototypes.containsAll(prototypesFromEditDialog) || !prototypesFromEditDialog.containsAll(this.currentPrototypes);
                if (prototypesChanged) {
                    this.currentPrototypes = prototypesFromEditDialog;
                    BUserCOTPrototypesFE.updateChecklist(this.editDialogPrototypes, this.prototypes);
                    BUserCOTPrototypesFE.addTopPrototypesFrom(this.prototypes, this.prototypesFolder, this.currentPrototypes);
                    this.prototypesModified();
                    this.relayout();
                }
            }
        }
    }

    private static void updateChecklist(BCheckList source, BCheckList destination) {
        ListModel model = destination.getModel();
        model.removeAllItems();
        Object[] selectedItems = source.getSelectedItems();
        for (int i = 0; i < selectedItems.length; ++i) {
            model.addItem(selectedItems[i]);
            destination.getSelection().select(i);
        }
    }

    private static String delimitSelected(BCheckList prototypes) {
        int[] selectedPrototypes = prototypes.getSelection().getItems();
        ListModel prototypeList = prototypes.getModel();
        StringJoiner sj = new StringJoiner(",");
        for (int i : selectedPrototypes) {
            sj.add(SlotPath.escape((String)prototypeList.getItem(i).toString()));
        }
        return sj.toString();
    }

    private static class PrototypeListController
    extends BCheckList.CheckListController {
        private final BUserCOTPrototypesFE userCOTPrototypesFE;

        public PrototypeListController(BUserCOTPrototypesFE userCOTPrototypesFE) {
            this.userCOTPrototypesFE = userCOTPrototypesFE;
        }

        protected void itemReleased(BMouseEvent event, int index) {
            super.itemReleased(event, index);
            this.userCOTPrototypesFE.prototypesModified();
        }
    }
}

