/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.types.BMbusPrimaryAddressRange;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"mbus:MbusPrimaryAddressRange"})})
public final class BMbusPrimaryAddressRangeFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusPrimaryAddressRangeFE.class);
    private final BTextField startField = new BTextField();
    private final BTextField endField = new BTextField();
    private static final Lexicon lex = Lexicon.make(BMbusPrimaryAddressRangeFE.class);
    private static final BImage img = BImage.make((String)"module://icons/x16/doubleArrowRight.png");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusPrimaryAddressRangeFE() {
        BFlowPane pane = new BFlowPane(BHalign.left, 5, 0);
        BLabel sepLabel = new BLabel(img);
        pane.add(null, (BValue)this.startField);
        pane.add(null, (BValue)sepLabel);
        pane.add(null, (BValue)this.endField);
        this.linkTo((BComponent)this.startField, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.endField, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.setContent((BWidget)pane);
    }

    public void doLoadValue(BObject value, Context context) throws Exception {
        this.startField.setEditable(!this.isReadonly());
        this.endField.setEditable(!this.isReadonly());
        BMbusPrimaryAddressRange r = (BMbusPrimaryAddressRange)value;
        this.startField.setText(String.valueOf(r.getStart()));
        this.endField.setText(String.valueOf(r.getEnd()));
    }

    public BObject doSaveValue(BObject value, Context context) throws Exception {
        BMbusPrimaryAddressRange r = (BMbusPrimaryAddressRange)value;
        if (r != null) {
            int start = 0;
            int end = 0;
            try {
                start = Integer.parseInt(this.startField.getText());
            }
            catch (NumberFormatException e) {
                if (MbusToolkit.getLogger() != null) {
                    MbusToolkit.error((String)"Error parsing start number", (Throwable)e);
                }
                throw new CannotSaveException(lex.getText("mbusPrimaryAddressRangeFE.invalidStart"), (Throwable)e);
            }
            try {
                end = Integer.parseInt(this.endField.getText());
            }
            catch (NumberFormatException e) {
                if (MbusToolkit.getLogger() != null) {
                    MbusToolkit.error((String)"Error parsing start number", (Throwable)e);
                }
                throw new CannotSaveException(lex.getText("mbusPrimaryAddressRangeFE.invalidEnd"), (Throwable)e);
            }
            if (start < 0 || start > 250) {
                throw new CannotSaveException(lex.getText("mbusPrimaryAddressRangeFE.invalidStart"));
            }
            if (end < 0 || end > 250) {
                throw new CannotSaveException(lex.getText("mbusPrimaryAddressRangeFE.invalidEnd"));
            }
            if (start > end) {
                throw new CannotSaveException(lex.getText("mbusPrimaryAddressRangeFE.startEndLessThan"));
            }
            r.setStart(start);
            r.setEnd(end);
        }
        return r;
    }

    protected void doSetReadonly(boolean readonly) {
        this.startField.setEditable(!readonly);
        this.endField.setEditable(!readonly);
    }
}

