/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.ui;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BPrimaryDiscoverOptions;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.jobs.BMbusDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusPrimaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondaryDeviceSearchJob;
import com.tridium.mbus.jobs.BMbusSecondarySearchJob;
import com.tridium.mbus.learn.BMbusDeviceDiscoveryJob;
import com.tridium.mbus.learn.BMbusDeviceEntry;
import com.tridium.mbus.types.BEncodableList;
import com.tridium.mbus.ui.DiscoveryWizardModel;
import com.tridium.mbus.utils.MbusToolkit;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.driver.ui.device.DeviceState;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"mbus:AbstractMbusNetwork", "mbus:MbusDeviceFolder"})})
public final class BMbusDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusDeviceManager.class);
    private Object lastUpdateToggledByHandle = new Object();
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BMbusDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colPrimaryAddress = new MgrColumn.Prop(BMbusDevice.primaryAddress, 1);
    MgrColumn colSecondaryAddress = new MgrColumn.Prop(BMbusDevice.secondaryAddress, 1);
    MgrColumn colAddressMode = new MgrColumn.Prop(BMbusDevice.addressMode, 1);
    MgrColumn colMBusConfig = new MgrColumn.Prop(BMbusDevice.mbusConfig, 1);
    MgrColumn colCycleQuantity = new MgrColumn.Prop(BMbusDevice.cycleQuantity, 1);
    MgrColumn colResetRequired = new MgrColumn.Prop(BMbusDevice.resetRequired, 1);
    MgrColumn colFcBitState = new MgrColumn.Prop(BMbusDevice.fcBitState, 5);
    MgrColumn colFcBitInUse = new MgrColumn.Prop(BMbusDevice.fcBitInUse, 1);
    MgrColumn colIdentNumber = new MgrColumn.Prop(BMbusDevice.identNumber, 1);
    MgrColumn colManufacturer = new MgrColumn.Prop(BMbusDevice.manufacturer, 1);
    MgrColumn colVersionNumber = new MgrColumn.Prop(BMbusDevice.versionNumber, 1);
    MgrColumn colDeviceTypeId = new MgrColumn.Prop(BMbusDevice.deviceTypeId, 1);
    MgrColumn colModelName = new MgrColumn.Prop(BMbusDevice.modelName, 1);
    MgrColumn colBaudRate = new MgrColumn.Prop(BMbusDevice.baudRate, 5);
    MgrColumn[] cols = new MgrColumn[]{this.colModelName, this.colName, this.colType, this.colDeviceExts, this.colPrimaryAddress, this.colSecondaryAddress, this.colAddressMode, this.colMBusConfig, this.colCycleQuantity, this.colResetRequired, this.colFcBitState, this.colFcBitInUse, this.colIdentNumber, this.colManufacturer, this.colVersionNumber, this.colDeviceTypeId, this.colStatus, this.colBaudRate, this.colEnabled, this.colHealth};
    private static final BImage deviceIcon = BImage.make((String)"module://icons/x16/device.png");
    BMbusDeviceEntry[] lastLearn = null;
    private BAbstractMbusNetwork net = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrState makeState() {
        return new MbusDeviceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleComponentEvent(BComponentEvent event) {
        block11: {
            final BComponent srcComp = event.getSourceComponent();
            if (srcComp instanceof BMbusDeviceSearchJob || srcComp instanceof BMbusSecondarySearchJob || srcComp instanceof BMbusPrimaryDeviceSearchJob || srcComp instanceof BMbusSecondaryDeviceSearchJob) {
                try {
                    if (!event.getSlotName().equals(BJob.jobState.getName())) {
                        return;
                    }
                    if (this.getController().learnMode.isSelected() && ((BJob)srcComp).getJobState().equals((Object)BJobState.success)) {
                        Object object = this.lastUpdateToggledByHandle;
                        synchronized (object) {
                            if (this.lastUpdateToggledByHandle == srcComp.getHandle()) {
                                return;
                            }
                            this.lastUpdateToggledByHandle = srcComp.getHandle();
                        }
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                block2: {
                                    try {
                                        BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitDeviceDiscoveryJob(srcComp.getHandleOrd()));
                                        BMbusDeviceManager.this.getController().updateCommands();
                                    }
                                    catch (Exception e) {
                                        if (MbusToolkit.getLogger() == null) break block2;
                                        MbusToolkit.error((String)MbusToolkit.getText((String)"MbusDeviceManager.discoveryError"), (Throwable)e);
                                    }
                                }
                            }
                        }, "Mbus:SubmitDeviceDiscoveryJobThread").start();
                        break block11;
                    }
                    if (this.getController().learnMode.isSelected() && (((BJob)srcComp).getJobState().equals((Object)BJobState.canceled) || ((BJob)srcComp).getJobState().equals((Object)BJobState.failed))) {
                        this.getController().updateCommands();
                    }
                    break block11;
                }
                catch (Exception e) {
                    if (MbusToolkit.getLogger() != null) {
                        MbusToolkit.error((String)MbusToolkit.getText((String)"MbusDeviceManager.discoveryError"), (Throwable)e);
                    }
                    break block11;
                }
            }
            super.handleComponentEvent(event);
        }
    }

    private void updateDiscoveryRows(BComponent event) {
        event.loadSlots();
        Object[] rows = (BMbusDeviceEntry[])event.getChildren(BMbusDeviceEntry.class);
        this.lastLearn = rows;
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    public BAbstractMbusNetwork getNetwork() {
        if (this.net == null) {
            this.net = BMbusDeviceManager.findNetwork((BComponent)this.getCurrentValue());
        }
        return this.net;
    }

    private static BAbstractMbusNetwork findNetwork(BComponent comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof BAbstractMbusNetwork) {
            return (BAbstractMbusNetwork)comp;
        }
        return BMbusDeviceManager.findNetwork((BComponent)comp.getParent());
    }

    class AssignBaudRateCmd
    extends MgrController.MgrCommand {
        AssignBaudRateCmd(BWidget owner) {
            super(owner, MbusToolkit.lex, "MbusDeviceManager.assignBaudRate");
        }

        public Command doMerge(Command c) {
            return this;
        }

        public CommandArtifact doInvoke() throws Exception {
            BAbstractMbusNetwork n = BMbusDeviceManager.this.getNetwork();
            Model model = (Model)BMbusDeviceManager.this.getModel();
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)BMbusBaudRate.baud300);
            editor.loadValue((BObject)BMbusBaudRate.baud300);
            if (BDialog.open((BWidget)BMbusDeviceManager.this, (String)MbusToolkit.getText((String)"MbusDeviceManager.chooseBaudRate"), (Object)editor, (int)3) == 1) {
                BComponent[] comps = BMbusDeviceManager.this.getController().getSelectedComponents();
                BMbusDevice[] devices = new BMbusDevice[comps.length];
                System.arraycopy(comps, 0, devices, 0, comps.length);
                BOrd jobOrd = n.submitAssignBaudRateJob(new BMbusAssignBaudRateData((BMbusBaudRate)editor.saveValue((BObject)BMbusBaudRate.baud300, null), devices));
                if (!jobOrd.isNull()) {
                    n.getComponentSpace().sync();
                    BJob job = (BJob)jobOrd.get((BObject)n);
                    job.lease();
                    model.setAssignBaudRateJob(job);
                }
            }
            return null;
        }
    }

    class UpdateFromNetworkCmd
    extends MgrController.MgrCommand {
        UpdateFromNetworkCmd(BWidget owner) {
            super(owner, MbusToolkit.lex, "MbusDeviceManager.updateFromNetwork");
        }

        public Command doMerge(Command c) {
            return this;
        }

        public CommandArtifact doInvoke() throws Exception {
            BAbstractMbusNetwork n = BMbusDeviceManager.this.getNetwork();
            Model model = (Model)BMbusDeviceManager.this.getModel();
            BComponent[] comps = BMbusDeviceManager.this.getController().getSelectedComponents();
            String[] devOrds = new String[comps.length];
            for (int i = 0; i < comps.length; ++i) {
                devOrds[i] = comps[i].getHandleOrd().toString();
            }
            BOrd jobOrd = n.submitPrimaryDiscoverJob(BEncodableList.make((String[])devOrds));
            if (!jobOrd.isNull()) {
                n.getComponentSpace().sync();
                BJob job = (BJob)jobOrd.get((BObject)n);
                job.lease();
                model.setUpdateJob(job);
            }
            return null;
        }
    }

    class MbusDeviceState
    extends DeviceState {
        private BJob updateCmdJob = null;
        private BJob assignBaudRateCmdJob = null;

        MbusDeviceState() {
        }

        protected void restoreForType(BAbstractManager manager) {
            super.restoreForType(manager);
            ((Model)manager.getModel()).setUpdateJob(this.updateCmdJob);
            ((Model)manager.getModel()).setAssignBaudRateJob(this.assignBaudRateCmdJob);
        }

        protected void saveForType(BAbstractManager manager) {
            super.saveForType(manager);
            this.updateCmdJob = ((Model)manager.getModel()).updateCmdJob;
            this.assignBaudRateCmdJob = ((Model)manager.getModel()).assignBaudRateCmdJob;
        }
    }

    private class Learn
    extends MgrLearn {
        Learn(BMbusDeviceManager mgr) {
            super((BAbstractManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BMbusDeviceEntry.primaryAddress), new MgrColumn.Prop(BMbusDeviceEntry.secondaryAddress), new MgrColumn.Prop(BMbusDeviceEntry.baudRate), new MgrColumn.Prop(BMbusDeviceEntry.addressMode)};
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return false;
        }

        public BImage getIcon(Object dis) {
            return deviceIcon;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return BMbusDeviceManager.this.getModel().getNewTypes();
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BMbusDeviceEntry entry = (BMbusDeviceEntry)dis;
            row.setCell(BMbusDeviceManager.this.colModelName, (BValue)BString.make((String)entry.getModelName()));
            row.setCell(BMbusDeviceManager.this.colPrimaryAddress, (BValue)BInteger.make((int)entry.getPrimaryAddress()));
            row.setCell(BMbusDeviceManager.this.colSecondaryAddress, (BValue)BString.make((String)entry.getSecondaryAddress()));
            row.setCell(BMbusDeviceManager.this.colMBusConfig, entry.getTxRxMbusConfig().newCopy(true));
            row.setCell(BMbusDeviceManager.this.colCycleQuantity, (BValue)BInteger.make((int)entry.getCycleQuantity()));
            row.setCell(BMbusDeviceManager.this.colResetRequired, (BValue)BBoolean.make((boolean)entry.getResetRequired()));
            row.setCell(BMbusDeviceManager.this.colFcBitState, (BValue)BBoolean.make((boolean)entry.getFcBitState()));
            row.setCell(BMbusDeviceManager.this.colFcBitInUse, (BValue)BBoolean.make((boolean)entry.getFcBitInUse()));
            row.setCell(BMbusDeviceManager.this.colIdentNumber, (BValue)BString.make((String)entry.getIdentNumber()));
            row.setCell(BMbusDeviceManager.this.colManufacturer, (BValue)BString.make((String)entry.getManufacturer()));
            row.setCell(BMbusDeviceManager.this.colVersionNumber, (BValue)BInteger.make((int)entry.getVersionNumber()));
            row.setCell(BMbusDeviceManager.this.colDeviceTypeId, (BValue)BMbusDeviceTypeId.make((int)entry.getDeviceTypeId().getOrdinal()));
            row.setCell(BMbusDeviceManager.this.colBaudRate, (BValue)BMbusBaudRate.make((int)entry.getBaudRate().getOrdinal()));
            row.setCell(BMbusDeviceManager.this.colAddressMode, (BValue)entry.getAddressMode());
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BMbusDeviceEntry entry = (BMbusDeviceEntry)discovery;
                return entry.is(component);
            }
            catch (Throwable e) {
                if (MbusToolkit.getLogger() != null) {
                    MbusToolkit.error((String)MbusToolkit.getText((String)"MbusDeviceManager.entryError"), (Throwable)e);
                }
                return false;
            }
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BMbusDeviceDiscoveryJob) {
                BMbusDeviceManager.this.updateDiscoveryRows((BComponent)job);
            }
        }

        public void setJob(BJob job) {
            super.setJob(job);
            BMbusDeviceManager.this.updateDiscoveryRows((BComponent)job);
        }

        public void setJob(BOrd jobOrd) throws Exception {
            super.setJob(jobOrd);
        }
    }

    class Controller
    extends DeviceController {
        private UpdateFromNetworkCmd updateCmd;
        private AssignBaudRateCmd assignCmd;

        Controller(BDeviceManager mgr) {
            super(mgr);
            this.updateCmd = null;
            this.assignCmd = null;
            this.updateCmd = new UpdateFromNetworkCmd((BWidget)mgr);
            this.updateCmd.setFlags(7);
            this.assignCmd = new AssignBaudRateCmd((BWidget)mgr);
            this.assignCmd.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            Array a = new Array(MgrController.IMgrCommand.class);
            a.addAll((Object[])new MgrController.IMgrCommand[]{this.newCommand, this.newFolder, this.updateCmd, this.allDescendants, this.edit, this.learnMode, this.discover, this.add});
            if (!(BMbusDeviceManager.this.getNetwork() instanceof BMbusTcpIpNetwork)) {
                a.add((Object)this.assignCmd);
            }
            return (MgrController.IMgrCommand[])a.trim();
        }

        public CommandArtifact doNew(Context context) throws Exception {
            super.doNew(context);
            return null;
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            super.doDiscover(context);
            ((Model)BMbusDeviceManager.this.getModel()).removeJobPane();
            DiscoveryWizardModel model = new DiscoveryWizardModel();
            model.setBaudSelectable(!(BMbusDeviceManager.this.net instanceof BMbusTcpIpNetwork));
            BWizard.open((BWidget)BMbusDeviceManager.this, (WizardModel)model);
            if (model.isFinished()) {
                if (model.isScanDeviceDatabaseDiscover()) {
                    BMbusDeviceManager.this.getNetwork().getNetworkDatabase().setJustDetected();
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitDeviceDiscoveryJob(BOrd.NULL));
                } else if (model.isSingleDeviceDiscover()) {
                    BPrimaryDiscoverOptions discoveryOpts = new BPrimaryDiscoverOptions();
                    discoveryOpts.setBaudRates(model.getSelectedBaudRatesVector());
                    discoveryOpts.setAddrRange(model.getRange());
                    discoveryOpts.setTxRxProfile(model.getTxRxProfile());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitSingleDeviceDiscoveryJob(discoveryOpts));
                } else if (model.isAddressDiscover()) {
                    BPrimaryDiscoverOptions discoveryOpts = new BPrimaryDiscoverOptions();
                    discoveryOpts.setBaudRates(model.getSelectedBaudRatesVector());
                    discoveryOpts.setAddrRange(model.getRange());
                    discoveryOpts.setTxRxProfile(model.getTxRxProfile());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitPrimaryDiscoverRangeJob(discoveryOpts));
                } else if (model.isSecondaryDiscover()) {
                    BSecondaryDiscoverOptions discoveryOpts = new BSecondaryDiscoverOptions();
                    discoveryOpts.setBaudRates(model.getSelectedBaudRatesVector());
                    discoveryOpts.setTxRxProfile(model.getTxRxProfile());
                    discoveryOpts.setIdentScanOnly(false);
                    discoveryOpts.setFilters(model.getFilters());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitFullSecondaryDiscoverJob(discoveryOpts));
                } else if (model.isSpecificSecondaryAddressDiscover()) {
                    BSecondaryDiscoverOptions discoveryOpts = new BSecondaryDiscoverOptions();
                    discoveryOpts.setBaudRates(model.getSelectedBaudRatesVector());
                    discoveryOpts.setTxRxProfile(model.getTxRxProfile());
                    discoveryOpts.setFilters(model.getFilters());
                    BMbusDeviceManager.this.getLearn().setJob(BMbusDeviceManager.this.getNetwork().submitSecondaryAddressScanJob(discoveryOpts));
                }
            }
            return null;
        }

        public void updateCommands() {
            boolean dbItemSelected;
            super.updateCommands();
            BMgrTable table = this.getManager().getModel().getTable();
            MgrLearn learn = BMbusDeviceManager.this.getLearn();
            boolean bl = dbItemSelected = table != null && !table.getSelection().isEmpty();
            if (BMbusDeviceManager.this.getController().learnMode.isSelected()) {
                BJob job;
                if (learn.getTable() != null) {
                    this.add.setEnabled(learn.getTable().getSelectedObject() != null);
                }
                boolean runningJob = (job = learn.getJob()) != null ? !job.getJobState().isComplete() : false;
                boolean enableDiscover = job == null || !runningJob;
                this.discover.setEnabled(enableDiscover);
                this.cancel.setEnabled(job != null && runningJob);
                this.edit.setEnabled(dbItemSelected);
                this.updateCmd.setEnabled(enableDiscover && dbItemSelected);
                this.assignCmd.setEnabled(enableDiscover && dbItemSelected);
            } else {
                boolean runningJob = false;
                BJob currentJob = ((Model)BMbusDeviceManager.this.getModel()).getAssignBaudRateJob();
                if (currentJob != null && !currentJob.getJobState().isComplete()) {
                    runningJob = true;
                } else {
                    currentJob = ((Model)BMbusDeviceManager.this.getModel()).getUpdateJob();
                    if (currentJob != null && !currentJob.getJobState().isComplete()) {
                        runningJob = true;
                    }
                }
                this.cancel.setEnabled(false);
                this.discover.setEnabled(!runningJob);
                this.edit.setEnabled(dbItemSelected);
                this.updateCmd.setEnabled(dbItemSelected && !runningJob);
                this.assignCmd.setEnabled(dbItemSelected && !runningJob);
            }
        }
    }

    class Model
    extends DeviceModel {
        private BJob updateCmdJob;
        private BJob assignBaudRateCmdJob;
        private final BEdgePane jobPane;

        Model(BDeviceManager manager) {
            super(manager);
            this.updateCmdJob = null;
            this.assignBaudRateCmdJob = null;
            this.jobPane = new BEdgePane();
        }

        protected MgrColumn[] makeColumns() {
            return BMbusDeviceManager.this.cols;
        }

        public BWidget makePane() {
            BEdgePane pane = new BEdgePane();
            pane.setTop((BWidget)this.jobPane);
            pane.setCenter(super.makePane());
            return pane;
        }

        void setUpdateJob(BJob job) {
            if (BMbusDeviceManager.this.getController().learnMode.isSelected()) {
                BMbusDeviceManager.this.getLearn().setJob(job);
                this.removeJobPane();
                return;
            }
            this.updateCmdJob = job;
            this.updateJobBars();
            BMbusDeviceManager.this.getController().updateCommands();
        }

        BJob getUpdateJob() {
            return this.updateCmdJob;
        }

        void setAssignBaudRateJob(BJob job) {
            if (BMbusDeviceManager.this.getController().learnMode.isSelected()) {
                BMbusDeviceManager.this.getLearn().setJob(job);
                this.removeJobPane();
                return;
            }
            this.assignBaudRateCmdJob = job;
            this.updateJobBars();
            BMbusDeviceManager.this.getController().updateCommands();
        }

        BJob getAssignBaudRateJob() {
            return this.assignBaudRateCmdJob;
        }

        private void updateJobBars() {
            this.jobPane.removeAll();
            if (this.updateCmdJob != null) {
                this.jobPane.setTop((BWidget)this.createJobPane(this.updateCmdJob));
            }
            if (this.assignBaudRateCmdJob != null) {
                this.jobPane.setBottom((BWidget)this.createJobPane(this.assignBaudRateCmdJob));
            }
        }

        public void removeJobPane() {
            this.jobPane.setTop((BWidget)new BNullWidget());
            this.jobPane.setBottom((BWidget)new BNullWidget());
        }

        private BPane createJobPane(BJob job) {
            BJobBar bar = BJobBar.makeFor((BJob)job);
            bar.load(job);
            BBorderPane jobPane = new BBorderPane((BWidget)bar, BBorder.groove, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
            jobPane.setFill(Theme.widget().getWindowBackground());
            jobPane = new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
            BMbusDeviceManager.this.attach((BWbComponentView.Attachable)bar);
            BMbusDeviceManager.this.registerForComponentEvents((BComponent)job);
            return jobPane;
        }
    }
}

