/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.fox.BAlarmArchiveChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.sys.registry.NAgentList;
import com.tridium.sys.station.Station;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmArchive;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BExecutionState;
import javax.baja.util.BFormat;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="state", type="BExecutionState", defaultValue="BExecutionState.idle", flags=3), @NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make())"), @NiagaraProperty(name="clearedAlarmLingerTime", type="BRelTime", defaultValue="BRelTime.DEFAULT", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0))")}), @NiagaraProperty(name="lastAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="lastSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="lastFailure", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="retryTrigger", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(15)))"), @NiagaraProperty(name="alarmOnFailure", type="boolean", defaultValue="true"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()")})
@NiagaraActions(value={@NiagaraAction(name="execute", flags=16), @NiagaraAction(name="retry", flags=8), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public abstract class BArchiveAlarmProvider
extends BComponent
implements BIRestrictedComponent,
BIStatus,
BIAlarmSource {
    @Generated
    public static final Property status = BArchiveAlarmProvider.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property enabled = BArchiveAlarmProvider.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property faultCause = BArchiveAlarmProvider.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property state = BArchiveAlarmProvider.newProperty((int)3, (BValue)BExecutionState.idle, null);
    @Generated
    public static final Property executionTime = BArchiveAlarmProvider.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    @Generated
    public static final Property clearedAlarmLingerTime = BArchiveAlarmProvider.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    @Generated
    public static final Property lastAttempt = BArchiveAlarmProvider.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastSuccess = BArchiveAlarmProvider.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastFailure = BArchiveAlarmProvider.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property retryTrigger = BArchiveAlarmProvider.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15))), null);
    @Generated
    public static final Property alarmOnFailure = BArchiveAlarmProvider.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property alarmSourceInfo = BArchiveAlarmProvider.newProperty((int)0, (BValue)BArchiveAlarmProvider.initAlarmSourceInfo(), null);
    @Generated
    public static final Action execute = BArchiveAlarmProvider.newAction((int)16, null);
    @Generated
    public static final Action retry = BArchiveAlarmProvider.newAction((int)8, null);
    @Generated
    public static final Action ackAlarm = BArchiveAlarmProvider.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BArchiveAlarmProvider.class);
    private final Station.SaveListener saveListener = new Station.SaveListener(){

        public void stationSave() {
            try {
                BArchiveAlarmProvider.this.getAlarmArchive().save();
            }
            catch (Exception e) {
                BAlarmDatabase.log.log(Level.SEVERE, "Archive Alarm database save failed.", e);
            }
        }

        public void stationSaveOk() {
        }

        public void stationSaveFail(String cause) {
        }

        public String toString() {
            return "ArchiveAlarmProvider " + BArchiveAlarmProvider.this.getNavOrd();
        }
    };
    private boolean fatalFault;
    private AlarmSupport alarmSupport;
    public static final Lexicon LEX = Lexicon.make((String)"alarm");
    private static final Logger LOG = BAlarmService.logger;
    private static final AgentList ALARM_ARCHIVE_VIEWS = new NAgentList();
    private static final String UNLICENSED;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BExecutionState getState() {
        return (BExecutionState)this.get(state);
    }

    @Generated
    public void setState(BExecutionState v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getExecutionTime() {
        return (BTimeTrigger)this.get(executionTime);
    }

    @Generated
    public void setExecutionTime(BTimeTrigger v) {
        this.set(executionTime, (BValue)v, null);
    }

    @Generated
    public BRelTime getClearedAlarmLingerTime() {
        return (BRelTime)this.get(clearedAlarmLingerTime);
    }

    @Generated
    public void setClearedAlarmLingerTime(BRelTime v) {
        this.set(clearedAlarmLingerTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    @Generated
    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    @Generated
    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    @Generated
    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getRetryTrigger() {
        return (BTimeTrigger)this.get(retryTrigger);
    }

    @Generated
    public void setRetryTrigger(BTimeTrigger v) {
        this.set(retryTrigger, (BValue)v, null);
    }

    @Generated
    public boolean getAlarmOnFailure() {
        return this.getBoolean(alarmOnFailure);
    }

    @Generated
    public void setAlarmOnFailure(boolean v) {
        this.setBoolean(alarmOnFailure, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public void retry() {
        this.invoke(retry, null, null);
    }

    @Override
    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract BAlarmArchive getAlarmArchive();

    public abstract BStatus getArchiveStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doExecute(Context cx) {
        block36: {
            if (!this.canExecuteRequest()) {
                if (!this.getState().equals((Object)BExecutionState.idle)) {
                    this.setState(BExecutionState.idle);
                }
                return;
            }
            try {
                List<BUuid> clearedUuids;
                if (!this.isProviderReady()) break block36;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("begin export on thread " + Thread.currentThread().getName());
                }
                long t0 = Clock.ticks();
                this.setState(BExecutionState.inProgress);
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                BAbsTime exportQueryStartTime = BAbsTime.now().subtract(this.getClearedAlarmLingerTime());
                BOrd query = BOrd.make((String)("alarm:|bql:select * where (((sourceState = 'normal' or sourceState = 'alert') and ackState = 'acked')or (sourceState = 'normal' and ackRequired = false))and lastUpdate <= AbsTime '" + exportQueryStartTime.encodeToString() + '\''));
                try (TableCursor result = ((BITable)query.resolve((BObject)alarmService).get()).cursor();){
                    clearedUuids = this.exportClearedRecords((Cursor<BAlarmRecord>)result);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("exported " + clearedUuids.size() + " alarm records");
                }
                int clearCount = 0;
                try (AlarmDbConnection alarmDbConn = alarmService.getAlarmDb().getDbConnection(null);){
                    for (BUuid uuid : clearedUuids) {
                        alarmDbConn.clearRecord(uuid, null);
                        ++clearCount;
                    }
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("cleared " + clearCount + " local alarm records");
                }
                long ms = Clock.ticks() - t0;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("end export (" + ms + "ms)");
                }
                this.executeOk();
            }
            catch (Exception e) {
                this.executeFail(e.getLocalizedMessage());
            }
            finally {
                this.setState(BExecutionState.idle);
            }
        }
    }

    public abstract boolean isProviderReady();

    public abstract List<BUuid> exportClearedRecords(Cursor<BAlarmRecord> var1);

    public void executeOk() {
        this.setFaultCause("");
        this.setLastSuccess(Clock.time());
        this.setState(BExecutionState.idle);
        if (this.getStatus().isAlarm()) {
            this.processAlarmNormal(this.alarmSupport);
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)8, (boolean)false));
        }
        this.updateStatus();
    }

    public void executeFail() {
        this.executeFail("");
    }

    public void executeFail(String reason) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.setFaultCause(reason);
        this.setState(BExecutionState.idle);
        if (this.getAlarmOnFailure() && !this.getStatus().isAlarm()) {
            boolean ackRequired = this.processAlarmOffnormal(this.alarmSupport, this.getAlarmSourceInfo(), reason);
            int newStatus = this.getStatus().getBits();
            newStatus |= 8;
            if (ackRequired) {
                newStatus |= 0x80;
            }
            this.setStatus(BStatus.make((int)newStatus));
        }
        this.updateStatus();
    }

    public void executeInProgress() {
        this.setState(BExecutionState.inProgress);
    }

    void processAlarmNormal(AlarmSupport support) {
        try {
            support.toNormal(null);
        }
        catch (Throwable e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Cannot process normal alarm:" + e.getLocalizedMessage(), e);
            }
            LOG.warning("Cannot process normal alarm:" + e.getLocalizedMessage());
        }
    }

    boolean processAlarmOffnormal(AlarmSupport support, BAlarmSourceInfo info, String reason) {
        boolean ackRequired = false;
        try {
            ackRequired = support.isAckRequired(BSourceState.offnormal);
            BFacets alarmData = info.makeAlarmData(BSourceState.offnormal);
            String msgText = alarmData.gets("msgText", "");
            alarmData = BFacets.make((BFacets)alarmData, (String)"msgText", (BIDataValue)BString.make((String)(msgText + '\n' + reason)));
            support.newOffnormalAlarm(alarmData);
        }
        catch (Throwable e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Cannot process off normal alarm: " + e.getLocalizedMessage(), e);
            }
            LOG.warning("Cannot process off normal alarm: " + e.getLocalizedMessage());
        }
        return ackRequired;
    }

    private void checkLicense() {
        try {
            Feature alarmArchiveFeature = Sys.getLicenseManager().getFeature("tridium", "alarmArchive");
            if (alarmArchiveFeature == null) {
                throw new FeatureNotLicensedException(UNLICENSED);
            }
            alarmArchiveFeature.check();
        }
        catch (Exception e) {
            this.configFatal(UNLICENSED);
        }
    }

    public final boolean isOperational() {
        return !this.isDisabled() && !this.isFault();
    }

    public final boolean isDown() {
        return this.getStatus().isDown();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    protected final boolean canExecuteRequest() {
        return !this.isFatalFault() && !this.isDisabled() && !this.isDown();
    }

    public final void updateStatus() {
        if (this.fatalFault) {
            return;
        }
        BStatus archiveStatus = this.getArchiveStatus();
        if (this.fatalFault) {
            return;
        }
        int newStatus = this.getStatus().getBits();
        if (!this.getEnabled() || archiveStatus.isDisabled()) {
            newStatus |= 1;
            newStatus &= 0xFFFFFFFD;
            newStatus &= 0xFFFFFFFB;
            this.setStatus(BStatus.make((int)(newStatus &= 0xFFFFFFEF)));
            if (archiveStatus.isDisabled()) {
                this.setFaultCause(LEX.getText("alarmArchive.archiveStatus.disabled"));
            } else {
                this.setFaultCause("");
            }
            return;
        }
        newStatus &= 0xFFFFFFFE;
        newStatus = archiveStatus.isDown() ? (newStatus |= 4) : (newStatus &= 0xFFFFFFFB);
        if (!this.getLastFailure().isNull() && this.getLastFailure().isAfter(this.getLastSuccess())) {
            newStatus |= 2;
        } else if (archiveStatus.isFault()) {
            newStatus |= 2;
            this.setFaultCause(LEX.getText("alarmArchive.archiveStatus.fault"));
        } else {
            newStatus &= 0xFFFFFFFD;
            this.setFaultCause("");
        }
        if (newStatus == this.getStatus().getBits()) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.setStatus(BStatus.make((int)(this.getStatus().getBits() | 2)));
        this.setFaultCause(LEX.getText("alarmArchive.restartRequired", new Object[]{cause}));
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        asi.setToOffnormalText(BFormat.make((String)"%lexicon(alarm:archiveFail)%"));
        asi.setToNormalText(BFormat.make((String)"%lexicon(alarm:archiveSuccess)%"));
        return asi;
    }

    public void doRetry() {
        if (!this.isDisabled()) {
            this.execute();
        }
    }

    static BBoolean processAlarmAck(AlarmSupport support, BAlarmRecord ackRequest) {
        try {
            return BBoolean.make((boolean)support.ackAlarm(ackRequest));
        }
        catch (Throwable throwable) {
            return BBoolean.FALSE;
        }
    }

    public final BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        BBoolean alarmAck = BArchiveAlarmProvider.processAlarmAck(this.alarmSupport, ackRequest);
        if (alarmAck.getBoolean()) {
            this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)128, (boolean)false));
        }
        return alarmAck;
    }

    public BIcon getIcon() {
        return BIcon.make((BIcon)BIcon.make((String)LEX.get("archiveAlarmProvider.icon")), (BIcon)BIcon.make((String)LEX.get("archiveAlarmProvider.icon.badge")));
    }

    void initAlarmArchive() {
        block11: {
            BAlarmArchive alarmArchive = this.getAlarmArchive();
            if (alarmArchive != null && !alarmArchive.isOpen()) {
                try {
                    alarmArchive.open();
                    try {
                        BAlarmService alarmService = (BAlarmService)this.getParent();
                        alarmService.getAlarmDb().addNavChild((BINavNode)alarmArchive);
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Failed to add Alarm Archive as nav child of Alarm Database", e);
                        }
                    }
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.SEVERE, "Cannot open alarm database.", e);
                    }
                    LOG.log(Level.SEVERE, "Cannot open alarm database: " + e.getMessage());
                }
                BArchiveAlarmProvider.addAlarmArchiveToFoxChannelRegistry();
            } else if (alarmArchive != null && alarmArchive.isOpen()) {
                try {
                    BAlarmDatabase alarmDb = ((BAlarmService)this.getParent()).getAlarmDb();
                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeReplaced((BOrd)alarmDb.getNavOrd(), (String)alarmArchive.getNavName(), null));
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block11;
                    LOG.log(Level.FINE, "Unable to fire NavEvent.REPLACED for Alarm Database:" + e.getMessage());
                }
            }
        }
    }

    private static void addAlarmArchiveToFoxChannelRegistry() {
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("alarmArchive") == null) {
            registry.add("alarmArchive", (BValue)new BAlarmArchiveChannel());
        }
    }

    void closeAlarmArchive() {
        block5: {
            BAlarmArchive alarmArchive = this.getAlarmArchive();
            if (alarmArchive != null && alarmArchive.isOpen()) {
                BArchiveAlarmProvider.removeAlarmArchiveToFoxChannelRegistry();
                try {
                    alarmArchive.flush();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to flush alarm archive", e);
                }
                alarmArchive.close();
                try {
                    BAlarmService alarmService = (BAlarmService)this.getParent();
                    alarmService.getAlarmDb().removeNavChild((BINavNode)alarmArchive);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block5;
                    LOG.log(Level.FINE, "Failed to remove Alarm Archive nav child from Alarm Database", e);
                }
            }
        }
    }

    private static void removeAlarmArchiveToFoxChannelRegistry() {
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("alarmArchive") != null) {
            registry.remove("alarmArchive");
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(execute)) {
            if (!this.canExecuteRequest()) {
                return null;
            }
            if (this.getState() != BExecutionState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BExecutionState.pending);
            return this.postExecute(action, arg, cx);
        }
        return super.post(action, arg, cx);
    }

    protected abstract IFuture postExecute(Action var1, BValue var2, Context var3);

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
                break;
            }
            case 23: {
                this.fwStationStarted();
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.checkLicense();
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.updateStatus();
        this.add("triggerLink?", (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
        Station.addSaveListener((Station.SaveListener)this.saveListener);
        this.initAlarmArchive();
    }

    private void fwStopped() {
        Property triggerLink = this.getProperty("triggerLink");
        if (triggerLink != null) {
            this.remove(triggerLink);
        }
        if (Sys.getStation().isRunning()) {
            Station.removeSaveListener((Station.SaveListener)this.saveListener);
        }
        this.closeAlarmArchive();
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled)) {
            this.updateStatus();
            if (this.getEnabled()) {
                this.initAlarmArchive();
            } else {
                this.closeAlarmArchive();
            }
        } else if (prop.equals(executionTime)) {
            this.add("triggerLink?", (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
        } else if (prop.equals(status) && this.isFatalFault()) {
            this.closeAlarmArchive();
        }
    }

    private void fwStationStarted() {
        if (this.getState() != BExecutionState.idle) {
            this.setState(BExecutionState.idle);
            this.execute();
        }
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = BAlarmDatabase.filterAgents(super.getAgents(cx));
        if (!this.isOperational()) {
            agents.remove(ALARM_ARCHIVE_VIEWS);
        }
        return agents;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BAlarmService.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BArchiveAlarmProvider.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("baja", "DuplicateRestrictedComponent", new Object[]{parent.getType(), this.getType()});
        }
    }

    static {
        ALARM_ARCHIVE_VIEWS.add("alarm:AlarmDbView");
        ALARM_ARCHIVE_VIEWS.add("alarm:AlarmDbMaintenance");
        ALARM_ARCHIVE_VIEWS.add("alarm:DatabaseView");
        ALARM_ARCHIVE_VIEWS.add("alarm:DatabaseMaintenance");
        UNLICENSED = LEX.getText("alarmArchive.error.unlicensed");
    }
}

