/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(name="BFacets.FIELD_EDITOR", value="\"alarm:AlarmClassFE\""), @Facet(name="BFacets.UX_FIELD_EDITOR", value="\"alarm:AlarmClassEditor\"")}), @NiagaraProperty(name="sourceName", type="BFormat", defaultValue="BFormat.make(\"%parent.displayName%\")"), @NiagaraProperty(name="toFaultText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="toOffnormalText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="toNormalText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="hyperlinkOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.ORD_RELATIVIZE", value="false"), @Facet(value="BFacets.make(\"chooseView\", true)")}), @NiagaraProperty(name="soundFile", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"file:AudioFile\"")}), @NiagaraProperty(name="alarmIcon", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"file:ImageFile\"")}), @NiagaraProperty(name="alarmInstructions", type="BAlarmInstructions", defaultValue="BAlarmInstructions.make(\"\")"), @NiagaraProperty(name="metaData", type="BFacets", defaultValue="BFacets.DEFAULT")})
public class BAlarmSourceInfo
extends BComponent {
    @Generated
    public static final Property alarmClass = BAlarmSourceInfo.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"alarm:AlarmClassFE"), (BFacets)BFacets.make((String)"uxFieldEditor", (String)"alarm:AlarmClassEditor")));
    @Generated
    public static final Property sourceName = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%"), null);
    @Generated
    public static final Property toFaultText = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property toOffnormalText = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property toNormalText = BAlarmSourceInfo.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property hyperlinkOrd = BAlarmSourceInfo.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"ordRelativize", (boolean)false), (BFacets)BFacets.make((String)"chooseView", (boolean)true)));
    @Generated
    public static final Property soundFile = BAlarmSourceInfo.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"file:AudioFile"));
    @Generated
    public static final Property alarmIcon = BAlarmSourceInfo.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"file:ImageFile"));
    @Generated
    public static final Property alarmInstructions = BAlarmSourceInfo.newProperty((int)0, (BValue)BAlarmInstructions.make(""), null);
    @Generated
    public static final Property metaData = BAlarmSourceInfo.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmSourceInfo.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/alarmService.png");

    @Generated
    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    @Generated
    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Generated
    public BFormat getSourceName() {
        return (BFormat)this.get(sourceName);
    }

    @Generated
    public void setSourceName(BFormat v) {
        this.set(sourceName, (BValue)v, null);
    }

    @Generated
    public BFormat getToFaultText() {
        return (BFormat)this.get(toFaultText);
    }

    @Generated
    public void setToFaultText(BFormat v) {
        this.set(toFaultText, (BValue)v, null);
    }

    @Generated
    public BFormat getToOffnormalText() {
        return (BFormat)this.get(toOffnormalText);
    }

    @Generated
    public void setToOffnormalText(BFormat v) {
        this.set(toOffnormalText, (BValue)v, null);
    }

    @Generated
    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    @Generated
    public void setToNormalText(BFormat v) {
        this.set(toNormalText, (BValue)v, null);
    }

    @Generated
    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    @Generated
    public void setHyperlinkOrd(BOrd v) {
        this.set(hyperlinkOrd, (BValue)v, null);
    }

    @Generated
    public BOrd getSoundFile() {
        return (BOrd)this.get(soundFile);
    }

    @Generated
    public void setSoundFile(BOrd v) {
        this.set(soundFile, (BValue)v, null);
    }

    @Generated
    public BOrd getAlarmIcon() {
        return (BOrd)this.get(alarmIcon);
    }

    @Generated
    public void setAlarmIcon(BOrd v) {
        this.set(alarmIcon, (BValue)v, null);
    }

    @Generated
    public BAlarmInstructions getAlarmInstructions() {
        return (BAlarmInstructions)this.get(alarmInstructions);
    }

    @Generated
    public void setAlarmInstructions(BAlarmInstructions v) {
        this.set(alarmInstructions, (BValue)v, null);
    }

    @Generated
    public BFacets getMetaData() {
        return (BFacets)this.get(metaData);
    }

    @Generated
    public void setMetaData(BFacets v) {
        this.set(metaData, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFacets makeAlarmData(BSourceState state) {
        String[] keys;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.getSourceName().toString().equals("")) {
            map.put("sourceName", BString.make((String)this.getSourceName().format((Object)this)));
        }
        String msgTxt = "";
        if (state == BSourceState.offnormal) {
            msgTxt = this.getToOffnormalText().toString();
        } else if (state == BSourceState.fault) {
            msgTxt = this.getToFaultText().toString();
        } else if (state == BSourceState.normal) {
            msgTxt = this.getToNormalText().toString();
        } else if (state == BSourceState.alert) {
            msgTxt = this.getToOffnormalText().toString();
        }
        if (!msgTxt.equals("")) {
            map.put("msgText", BString.make((String)msgTxt));
        }
        if (this.getHyperlinkOrd() != BOrd.NULL) {
            map.put("hyperlinkOrd", BString.make((String)this.getHyperlinkOrd().toString()));
        }
        if (this.getSoundFile() != BOrd.NULL) {
            map.put("soundFile", BString.make((String)this.getSoundFile().toString()));
        }
        if (this.getAlarmIcon() != BOrd.NULL) {
            map.put("icon", BString.make((String)this.getAlarmIcon().toString()));
        }
        try {
            if (!this.getAlarmInstructions().equals((Object)BAlarmInstructions.NULL)) {
                map.put("instructions", BString.make((String)this.getAlarmInstructions().encodeToString()));
            }
        }
        catch (Exception e) {
            Logger.getLogger("alarm").log(Level.SEVERE, "Could not encode Alarm Instructions", e);
        }
        for (String key : keys = this.getMetaData().list()) {
            map.put(key, (BIDataValue)this.getMetaData().get(key));
        }
        return BFacets.make(map);
    }

    public BIcon getIcon() {
        return icon;
    }
}

