/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public final class BAlarmInstructions
extends BSimple {
    public static final BAlarmInstructions NULL;
    public static final BAlarmInstructions DEFAULT;
    public static final Type TYPE;
    private int hashCode = -1;
    private BFormat[] instructions;
    private String string;

    public static BAlarmInstructions make(BFormat instruction) throws IOException {
        return new BAlarmInstructions(new BFormat[]{instruction}, instruction.encodeToString());
    }

    public static BAlarmInstructions make(BFormat[] instructions) {
        if (instructions.length == 0) {
            return NULL;
        }
        return new BAlarmInstructions((BFormat[])instructions.clone(), null);
    }

    public static BAlarmInstructions add(BAlarmInstructions orig, BFormat instruction) {
        BFormat[] instructions = new BFormat[orig.instructions.length + 1];
        System.arraycopy(orig.instructions, 0, instructions, 0, orig.instructions.length);
        instructions[instructions.length - 1] = instruction;
        return new BAlarmInstructions(instructions, null);
    }

    public static BAlarmInstructions remove(BAlarmInstructions orig, int index) {
        BFormat[] instructions = new BFormat[orig.instructions.length - 1];
        System.arraycopy(orig.instructions, 0, instructions, 0, index);
        if (index < orig.instructions.length) {
            System.arraycopy(orig.instructions, index + 1, instructions, index, orig.instructions.length - index - 1);
        }
        return new BAlarmInstructions(instructions, null);
    }

    public static BAlarmInstructions make(String string) {
        return (BAlarmInstructions)DEFAULT.decodeFromString(string);
    }

    private BAlarmInstructions(BFormat[] instructions, String string) {
        this.instructions = instructions;
        this.string = string;
    }

    public BFormat get(int index) {
        return this.instructions[index];
    }

    public int size() {
        return this.instructions.length;
    }

    public boolean isNull() {
        return this.instructions.length == 0;
    }

    public BFormat[] toArray() {
        return (BFormat[])this.instructions.clone();
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int x = 11;
            for (int i = 0; i < this.instructions.length; ++i) {
                x ^= this.instructions[i].hashCode();
            }
            this.hashCode = x;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BAlarmInstructions) {
            BFormat[] a = this.instructions;
            BFormat[] b = ((BAlarmInstructions)((Object)obj)).instructions;
            if (a.length != b.length) {
                return false;
            }
            for (int i = 0; i < a.length; ++i) {
                if (a[i].equals((Object)b[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.string == null) {
            if (this.instructions.length == 1) {
                this.string = this.instructions[0].encodeToString();
            } else {
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < this.instructions.length; ++i) {
                    if (i > 0) {
                        s.append('\n');
                    }
                    s.append(this.instructions[i].encodeToString());
                }
                this.string = s.toString();
            }
        }
        return this.string;
    }

    public BObject decodeFromString(String s) {
        if (s.length() == 0) {
            return DEFAULT;
        }
        int nl = s.indexOf(10);
        if (nl < 0) {
            return new BAlarmInstructions(new BFormat[]{BFormat.make((String)s)}, s);
        }
        ArrayList<BFormat> list = new ArrayList<BFormat>();
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            list.add(BFormat.make((String)st.nextToken()));
        }
        BFormat[] instructions = list.toArray(new BFormat[0]);
        return new BAlarmInstructions(instructions, s);
    }

    public String toString(Context cx) {
        if (this.instructions.length == 1) {
            return this.instructions[0].toString(cx);
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.instructions.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(this.instructions[i].toString(cx));
        }
        return buf.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BAlarmInstructions(new BFormat[0], "");
        TYPE = Sys.loadType(BAlarmInstructions.class);
    }
}

