/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.AlarmClassRouteAlarmInvocation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmPriorities;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ackRequired", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.make(BAlarmTransitionBits.TO_OFFNORMAL | BAlarmTransitionBits.TO_FAULT | BAlarmTransitionBits.TO_NORMAL)"), @NiagaraProperty(name="priority", type="BAlarmPriorities", defaultValue="BAlarmPriorities.DEFAULT"), @NiagaraProperty(name="totalAlarmCount", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="openAlarmCount", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="inAlarmCount", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="unackedAlarmCount", type="int", defaultValue="0", flags=67), @NiagaraProperty(name="timeOfLastAlarm", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="escalationLevel1Enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="escalationLevel1Delay", type="BRelTime", defaultValue="BRelTime.make(5*60*1000)", facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.FALSE, BFacets.MIN, BRelTime.make(60*1000))")}), @NiagaraProperty(name="escalationLevel2Enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="escalationLevel2Delay", type="BRelTime", defaultValue="BRelTime.make(15*60*1000)", facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.FALSE, BFacets.MIN, BRelTime.make(2*60*1000))")}), @NiagaraProperty(name="escalationLevel3Enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="escalationLevel3Delay", type="BRelTime", defaultValue="BRelTime.make(30*60*1000)", facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.FALSE, BFacets.MIN, BRelTime.make(3*60*1000))")})})
@NiagaraAction(name="routeAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", flags=20)
@NiagaraTopics(value={@NiagaraTopic(name="alarm", eventType="BAlarmRecord", flags=8), @NiagaraTopic(name="escalatedAlarm1", eventType="BAlarmRecord"), @NiagaraTopic(name="escalatedAlarm2", eventType="BAlarmRecord"), @NiagaraTopic(name="escalatedAlarm3", eventType="BAlarmRecord")})
public class BAlarmClass
extends BComponent {
    @Generated
    public static final Property ackRequired = BAlarmClass.newProperty((int)0, (BValue)BAlarmTransitionBits.make(7), null);
    @Generated
    public static final Property priority = BAlarmClass.newProperty((int)0, (BValue)BAlarmPriorities.DEFAULT, null);
    @Generated
    public static final Property totalAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property openAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property inAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property unackedAlarmCount = BAlarmClass.newProperty((int)67, (int)0, null);
    @Generated
    public static final Property timeOfLastAlarm = BAlarmClass.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property escalationLevel1Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property escalationLevel1Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)300000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)60000L)));
    @Generated
    public static final Property escalationLevel2Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property escalationLevel2Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)900000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)120000L)));
    @Generated
    public static final Property escalationLevel3Enabled = BAlarmClass.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property escalationLevel3Delay = BAlarmClass.newProperty((int)0, (BValue)BRelTime.make((long)1800000L), (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"min", (BIDataValue)BRelTime.make((long)180000L)));
    @Generated
    public static final Action routeAlarm = BAlarmClass.newAction((int)20, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Topic alarm = BAlarmClass.newTopic((int)8, null);
    @Generated
    public static final Topic escalatedAlarm1 = BAlarmClass.newTopic((int)0, null);
    @Generated
    public static final Topic escalatedAlarm2 = BAlarmClass.newTopic((int)0, null);
    @Generated
    public static final Topic escalatedAlarm3 = BAlarmClass.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmClass.class);
    public static final Logger log = Logger.getLogger("alarm");
    BAlarmService alarmService;
    private static final BIcon icon = BIcon.std((String)"alarm/alarmClass.png");
    public static final String ESCALATED = "escalated";
    public static final String LEVEL_1 = "level1";
    public static final String LEVEL_2 = "level2";
    public static final String LEVEL_3 = "level3";

    @Generated
    public BAlarmTransitionBits getAckRequired() {
        return (BAlarmTransitionBits)this.get(ackRequired);
    }

    @Generated
    public void setAckRequired(BAlarmTransitionBits v) {
        this.set(ackRequired, (BValue)v, null);
    }

    @Generated
    public BAlarmPriorities getPriority() {
        return (BAlarmPriorities)this.get(priority);
    }

    @Generated
    public void setPriority(BAlarmPriorities v) {
        this.set(priority, (BValue)v, null);
    }

    @Generated
    public int getTotalAlarmCount() {
        return this.getInt(totalAlarmCount);
    }

    @Generated
    public void setTotalAlarmCount(int v) {
        this.setInt(totalAlarmCount, v, null);
    }

    @Generated
    public int getOpenAlarmCount() {
        return this.getInt(openAlarmCount);
    }

    @Generated
    public void setOpenAlarmCount(int v) {
        this.setInt(openAlarmCount, v, null);
    }

    @Generated
    public int getInAlarmCount() {
        return this.getInt(inAlarmCount);
    }

    @Generated
    public void setInAlarmCount(int v) {
        this.setInt(inAlarmCount, v, null);
    }

    @Generated
    public int getUnackedAlarmCount() {
        return this.getInt(unackedAlarmCount);
    }

    @Generated
    public void setUnackedAlarmCount(int v) {
        this.setInt(unackedAlarmCount, v, null);
    }

    @Generated
    public BAbsTime getTimeOfLastAlarm() {
        return (BAbsTime)this.get(timeOfLastAlarm);
    }

    @Generated
    public void setTimeOfLastAlarm(BAbsTime v) {
        this.set(timeOfLastAlarm, (BValue)v, null);
    }

    @Generated
    public boolean getEscalationLevel1Enabled() {
        return this.getBoolean(escalationLevel1Enabled);
    }

    @Generated
    public void setEscalationLevel1Enabled(boolean v) {
        this.setBoolean(escalationLevel1Enabled, v, null);
    }

    @Generated
    public BRelTime getEscalationLevel1Delay() {
        return (BRelTime)this.get(escalationLevel1Delay);
    }

    @Generated
    public void setEscalationLevel1Delay(BRelTime v) {
        this.set(escalationLevel1Delay, (BValue)v, null);
    }

    @Generated
    public boolean getEscalationLevel2Enabled() {
        return this.getBoolean(escalationLevel2Enabled);
    }

    @Generated
    public void setEscalationLevel2Enabled(boolean v) {
        this.setBoolean(escalationLevel2Enabled, v, null);
    }

    @Generated
    public BRelTime getEscalationLevel2Delay() {
        return (BRelTime)this.get(escalationLevel2Delay);
    }

    @Generated
    public void setEscalationLevel2Delay(BRelTime v) {
        this.set(escalationLevel2Delay, (BValue)v, null);
    }

    @Generated
    public boolean getEscalationLevel3Enabled() {
        return this.getBoolean(escalationLevel3Enabled);
    }

    @Generated
    public void setEscalationLevel3Enabled(boolean v) {
        this.setBoolean(escalationLevel3Enabled, v, null);
    }

    @Generated
    public BRelTime getEscalationLevel3Delay() {
        return (BRelTime)this.get(escalationLevel3Delay);
    }

    @Generated
    public void setEscalationLevel3Delay(BRelTime v) {
        this.set(escalationLevel3Delay, (BValue)v, null);
    }

    @Generated
    public void routeAlarm(BAlarmRecord parameter) {
        this.invoke(routeAlarm, (BValue)parameter, null);
    }

    @Generated
    public void fireAlarm(BAlarmRecord event) {
        this.fire(alarm, (BValue)event, null);
    }

    @Generated
    public void fireEscalatedAlarm1(BAlarmRecord event) {
        this.fire(escalatedAlarm1, (BValue)event, null);
    }

    @Generated
    public void fireEscalatedAlarm2(BAlarmRecord event) {
        this.fire(escalatedAlarm2, (BValue)event, null);
    }

    @Generated
    public void fireEscalatedAlarm3(BAlarmRecord event) {
        this.fire(escalatedAlarm3, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == totalAlarmCount || p == openAlarmCount || p == unackedAlarmCount || p == inAlarmCount) {
            if (this.getInt(p) < 0) {
                this.setInt(p, 0, null);
            }
        } else if (p == escalationLevel1Enabled) {
            if (this.getEscalationLevel1Enabled()) {
                int flags = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm1, flags |= 8);
            } else {
                int flags = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm1, flags &= 0xFFFFFFF7);
            }
        } else if (p == escalationLevel2Enabled) {
            if (this.getEscalationLevel2Enabled()) {
                int flags = this.getFlags((Slot)escalatedAlarm1);
                this.setFlags((Slot)escalatedAlarm2, flags |= 8);
            } else {
                int flags = this.getFlags((Slot)escalatedAlarm2);
                this.setFlags((Slot)escalatedAlarm2, flags &= 0xFFFFFFF7);
            }
        } else if (p == escalationLevel3Enabled) {
            if (this.getEscalationLevel3Enabled()) {
                int flags = this.getFlags((Slot)escalatedAlarm3);
                this.setFlags((Slot)escalatedAlarm3, flags |= 8);
            } else {
                int flags = this.getFlags((Slot)escalatedAlarm3);
                this.setFlags((Slot)escalatedAlarm3, flags &= 0xFFFFFFF7);
            }
        }
    }

    public void started() {
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == routeAlarm) {
            Queue q = (Queue)Sys.getService((Type)BAlarmService.TYPE).fw(601);
            AlarmClassRouteAlarmInvocation invc = AlarmClassRouteAlarmInvocation.make(this, action, (BAlarmRecord)argument, cx);
            q.enqueue((Object)invc);
            if (action == routeAlarm) {
                return invc;
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BIAlarmClassFolder;
    }

    public void doRouteAlarm(BAlarmRecord alarm) {
        try {
            if (!this.isRunning()) {
                return;
            }
            BSourceState newState = alarm.getSourceState();
            alarm.setPriority(this.getPriority().getPriority(newState));
            alarm.setAlarmClass(this.getName());
            if (alarm.getAlarmData().get("TimeZone") == null) {
                alarm.setAlarmData(BFacets.make((BFacets)alarm.getAlarmData(), (String)"TimeZone", (BIDataValue)BTimeZone.getLocal()));
            }
            boolean ackReq = this.getAckRequired().includes(newState);
            if (alarm.getSourceState() == BSourceState.alert && alarm.getAckState() == BAckState.acked) {
                alarm.setSourceState(BSourceState.normal);
                alarm.setAlarmTransition(BSourceState.alert);
            }
            if (alarm.getAlarmData().get(ESCALATED) == null) {
                alarm.addAlarmFacet(ESCALATED, (BIDataValue)BString.make((String)""));
            }
            alarm.setLastUpdate(BAbsTime.now());
            BAlarmService as = this.getAlarmService();
            try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                if (conn.getRecord(alarm.getUuid()) == null) {
                    conn.append(alarm);
                } else {
                    conn.update(alarm);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Cannot write alarm.", e);
                throw new AlarmException("Cannot write alarm", e);
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("BAlarmClass: " + this.getName() + " stored alarm.timestamp: " + alarm.getTimestamp());
            }
            if (alarm.isAlarm()) {
                this.setTimeOfLastAlarm(alarm.getTimestamp());
            }
            this.fireAlarm(alarm);
            BString escalatedLevel = (BString)alarm.getAlarmData().get(ESCALATED);
            if (escalatedLevel != null) {
                if (this.getEscalationLevel1Enabled() && (escalatedLevel.equals((Object)BString.make((String)LEVEL_1)) || escalatedLevel.equals((Object)BString.make((String)LEVEL_2)) || escalatedLevel.equals((Object)BString.make((String)LEVEL_3)))) {
                    this.fireEscalatedAlarm1(alarm);
                }
                if (this.getEscalationLevel2Enabled() && (escalatedLevel.equals((Object)BString.make((String)LEVEL_2)) || escalatedLevel.equals((Object)BString.make((String)LEVEL_3)))) {
                    this.fireEscalatedAlarm2(alarm);
                }
                if (this.getEscalationLevel3Enabled() && escalatedLevel.equals((Object)BString.make((String)LEVEL_3))) {
                    this.fireEscalatedAlarm3(alarm);
                }
            }
        }
        catch (ServiceNotFoundException e) {
            log.log(Level.SEVERE, "Alarm service not found", e);
        }
    }

    public String toString(Context cx) {
        return this.getDisplayName(cx);
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public BIcon getIcon() {
        return icon;
    }
}

