/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.IndexEntry;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Random;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.util.BUuid;

public abstract class SkipList {
    public static final int EQUAL_OR_AFTER = 0;
    public static final int EQUAL_OR_BEFORE = 1;
    public static final int EQUAL = 2;
    private int maxLevel;
    private IndexEntry header;
    private IndexEntry tail;
    private double probability;
    private int level;
    private int size;
    private Random rand = new Random();
    private IndexEntry[] addAt;
    private IndexEntry[] removeAt;
    private IndexEntry[] findAt;

    public SkipList(double probability, int maxSize) {
        this.maxLevel = (int)(Math.log(maxSize) / Math.log(1.0 / probability)) + 1;
        this.probability = probability;
        this.header = new IndexEntry();
        this.setLevel(this.header, this.maxLevel);
        this.tail = this.header;
        this.level = 1;
        this.size = 0;
        this.addAt = new IndexEntry[this.maxLevel];
        this.removeAt = new IndexEntry[this.maxLevel];
        this.findAt = new IndexEntry[this.maxLevel];
    }

    public synchronized int getSize() {
        return this.size;
    }

    public IndexEntry getHeader() {
        return this.header;
    }

    public IndexEntry getTail() {
        return this.tail;
    }

    public IndexEntry getFirstEntry() {
        return this.getNext(this.header, 0);
    }

    public IndexEntry getLastEntry() {
        return this.getTail();
    }

    public synchronized void add(IndexEntry newEntry) {
        int newLevel = this.generateNewLevel();
        this.setLevel(newEntry, newLevel);
        if (newLevel > this.level) {
            this.level = newLevel;
        }
        this.pathTo(newEntry, this.addAt);
        for (int i = 0; i < newLevel; ++i) {
            if (i == 0) {
                this.setPrev(newEntry, this.addAt[0]);
                IndexEntry next = this.getNext(this.addAt[0], 0);
                if (next != null) {
                    this.setPrev(next, newEntry);
                } else {
                    this.tail = newEntry;
                }
            }
            this.setNext(newEntry, i, this.getNext(this.addAt[i], i));
            this.setNext(this.addAt[i], i, newEntry);
        }
        ++this.size;
    }

    public synchronized void remove(IndexEntry entry) {
        int i;
        if (this.size == 0) {
            return;
        }
        this.pathTo(entry, this.removeAt);
        IndexEntry found = this.getNext(this.removeAt[0], 0);
        if (!found.equals(entry)) {
            throw new IllegalArgumentException("Entry not found: " + this.entryToString(found));
        }
        for (i = 0; i < this.level && this.getNext(this.removeAt[i], i) == found; ++i) {
            if (i == 0) {
                IndexEntry foundNext = this.getNext(found, 0);
                if (foundNext != null) {
                    this.setPrev(foundNext, this.removeAt[0]);
                } else {
                    this.tail = this.getPrev(found);
                }
            }
            this.setNext(this.removeAt[i], i, this.getNext(found, i));
        }
        while (this.level > 1 && this.getNext(this.header, this.level - 1) == null) {
            --this.level;
        }
        for (i = this.level; i < this.maxLevel; ++i) {
            this.addAt[i] = null;
            this.removeAt[i] = null;
            this.findAt[i] = null;
        }
        --this.size;
    }

    public IndexEntry find(Object key) {
        this.pathTo(key, this.findAt);
        return this.findAt[0];
    }

    protected void pathTo(Object key, IndexEntry[] path) {
        IndexEntry temp = this.header;
        IndexEntry entry = null;
        for (int i = this.level - 1; i >= 0; --i) {
            entry = this.getNext(temp, i);
            while (entry != null && this.compareToKey(entry, key) < 0) {
                temp = entry;
                entry = this.getNext(entry, i);
            }
            path[i] = temp;
        }
    }

    protected void pathTo(IndexEntry target, IndexEntry[] path) {
        IndexEntry temp = this.header;
        IndexEntry entry = null;
        for (int i = this.level - 1; i >= 0; --i) {
            entry = this.getNext(temp, i);
            while (entry != null && this.isBefore(entry, target)) {
                temp = entry;
                entry = this.getNext(entry, i);
            }
            path[i] = temp;
        }
    }

    private int generateNewLevel() {
        if (this.size == 0) {
            return 1;
        }
        int result = 1;
        while (this.rand.nextDouble() < this.probability && result < this.maxLevel) {
            if (++result != this.level + 1) continue;
            return result;
        }
        return result;
    }

    protected abstract int compare(IndexEntry var1, IndexEntry var2);

    protected abstract int compareToKey(IndexEntry var1, Object var2);

    protected boolean equals(IndexEntry entry1, IndexEntry entry2) {
        return this.compare(entry1, entry2) == 0;
    }

    protected boolean isBefore(IndexEntry entry1, IndexEntry entry2) {
        return this.compare(entry1, entry2) < 0;
    }

    protected boolean isAfter(IndexEntry entry1, IndexEntry entry2) {
        return this.compare(entry1, entry2) > 0;
    }

    protected abstract int getLevel(IndexEntry var1);

    protected abstract void setLevel(IndexEntry var1, int var2);

    protected abstract IndexEntry getNext(IndexEntry var1, int var2);

    protected abstract void setNext(IndexEntry var1, int var2, IndexEntry var3);

    protected abstract IndexEntry getPrev(IndexEntry var1);

    protected abstract void setPrev(IndexEntry var1, IndexEntry var2);

    public void dump() throws IOException {
        this.dump(null);
    }

    public void dump(AlarmStore store) throws IOException {
        int index = 0;
        IndexEntry temp = this.getNext(this.header, 0);
        BAlarmRecord rec = null;
        if (store != null) {
            rec = new BAlarmRecord(BUuid.DEFAULT);
        }
        while (temp != null) {
            System.out.println(index++ + ": (" + this.getLevel(temp) + ") " + this.entryToString(temp));
            if (store != null) {
                rec = store.readRecord(temp.pageIndex, rec, null);
                System.out.println("  " + (rec != null ? rec.toSummaryString() : "null"));
            }
            temp = this.getNext(temp, 0);
        }
    }

    public void analyze(String title, PrintStream out) {
        int i;
        out.println(title);
        out.println("  size       : " + this.getSize());
        out.println("  probability: " + this.probability);
        out.println("  maxLevel   : " + this.maxLevel);
        out.println("  level      : " + this.level);
        int[] nodes = new int[this.level];
        for (i = 0; i < this.level; ++i) {
            IndexEntry temp = this.getNext(this.header, i);
            while (temp != null) {
                nodes[i] = nodes[i] + 1;
                temp = this.getNext(temp, i);
            }
        }
        for (i = 0; i < this.level; ++i) {
            System.out.println("    level " + (i + 1) + ": " + nodes[i]);
        }
        int ptrBytes = this.size * 4;
        for (int i2 = 0; i2 < this.level; ++i2) {
            ptrBytes += nodes[i2] * 4;
        }
        DecimalFormat format = new DecimalFormat("###,###,###.##");
        out.println("  ptr ram    : " + format.format((double)ptrBytes / 1024.0 / 1024.0) + " MB");
    }

    public void verify() {
        int count = 0;
        IndexEntry prev = null;
        IndexEntry temp = this.getNext(this.header, 0);
        while (temp != null) {
            ++count;
            if (prev != null && this.isAfter(prev, temp)) {
                throw new IllegalStateException("Invalid ascending order.  " + this.entryToString(temp) + " is before " + this.entryToString(prev));
            }
            prev = temp;
            temp = this.getNext(temp, 0);
        }
        if (this.size != count) {
            throw new IllegalStateException("Invalid ascending count. size=" + this.size + ", count=" + count);
        }
        temp = prev;
        count = 0;
        prev = null;
        while (temp != this.header) {
            ++count;
            if (prev != null && this.isBefore(prev, temp)) {
                throw new IllegalStateException("Invalid descending order.  " + this.entryToString(temp) + " is after " + this.entryToString(prev));
            }
            prev = temp;
            temp = this.getPrev(temp);
        }
        if (this.size != count) {
            throw new IllegalStateException("Invalid descending count. size=" + this.size + ", count=" + count);
        }
    }

    public abstract String entryToString(IndexEntry var1);
}

