/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.Page;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class PageReader
implements DataInput {
    private AlarmStore store;
    private int pageIndex = -1;
    private Page page;
    private int pos;
    private int pageLen;
    private int[] pages;
    private int pageCount;

    public PageReader(AlarmStore store) throws IOException {
        this(store, -1);
    }

    public PageReader(AlarmStore store, int startPage) throws IOException {
        this.store = store;
        this.init(startPage);
    }

    public void init(int startPage) throws IOException {
        this.pageIndex = startPage;
        if (this.pageIndex != -1) {
            this.page = this.store.readPage(this.pageIndex);
        }
        this.pos = 0;
        this.pageLen = this.store.getHeader().getPageSize() - 12;
        this.pageCount = 1;
        if (this.pages == null) {
            this.pages = new int[3];
        }
        this.pages[0] = startPage;
    }

    private void nextPage() throws IOException {
        if (this.page == null) {
            throw new IllegalStateException("PageReader has not been initialized.");
        }
        int nextIndex = this.page.getNextPage();
        if (nextIndex == -1) {
            throw new EOFException();
        }
        this.pageIndex = nextIndex;
        this.page = this.store.readPage(this.pageIndex);
        this.pos = 0;
        if (this.pageCount == this.pages.length) {
            int[] temp = new int[this.pageCount + 1];
            System.arraycopy(this.pages, 0, temp, 0, this.pageCount);
            this.pages = temp;
        }
        this.pages[this.pageCount++] = this.pageIndex;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageIndex(int n) {
        return this.pages[n];
    }

    public int read() throws IOException {
        if (this.pos >= this.pageLen) {
            this.nextPage();
        }
        return this.page.readData(this.pos++);
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.pos >= this.pageLen) {
            this.nextPage();
        }
        int bytes = this.page.readData(this.pos, buf, offset, len);
        this.pos += bytes;
        return bytes;
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int offset, int len) throws IOException {
        int thisRead;
        int total = len;
        for (int bytes = 0; bytes < total; bytes += thisRead) {
            thisRead = this.read(buf, offset + bytes, total - bytes);
            if (thisRead != -1) continue;
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = n;
        while (n > 0) {
            int remainder = this.pageLen - this.pos;
            if (remainder > n) {
                this.pos += n;
                return skip;
            }
            n -= remainder;
            this.nextPage();
        }
        return skip;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    @Override
    public short readShort() throws IOException {
        return (short)((this.read() << 8) + this.read());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (this.read() << 8) + this.read();
    }

    @Override
    public char readChar() throws IOException {
        return (char)((this.read() << 8) + this.read());
    }

    @Override
    public int readInt() throws IOException {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + (this.read() << 0);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        StringBuilder str = new StringBuilder(utflen);
        int count = 0;
        block5: while (count < utflen) {
            int c = this.read();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int c2 = this.read();
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | c2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int c2 = this.read();
                    int c3 = this.read();
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }
}

