/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.IndexEntry;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;

public class OpenIndex {
    private static final BFacets showSecs = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE);
    private IndexEntry first = null;
    private IndexEntry last = null;
    private int size = 0;

    public int getSize() {
        return this.size;
    }

    public IndexEntry getFirstEntry() {
        return this.first;
    }

    public void add(IndexEntry entry) {
        if (entry.isOpen()) {
            return;
        }
        entry.setOpen(true);
        entry.nextOpen = null;
        entry.prevOpen = null;
        if (this.size == 0) {
            this.first = this.last = entry;
        } else {
            IndexEntry temp = entry.prevTimestamp;
            while (temp != null && !temp.isOpen()) {
                temp = temp.prevTimestamp;
            }
            if (temp == null) {
                if (this.first == null) {
                    this.first = this.last = entry;
                } else {
                    entry.nextOpen = this.first;
                    this.first.prevOpen = entry;
                    this.first = entry;
                }
            } else {
                entry.nextOpen = temp.nextOpen;
                entry.prevOpen = temp;
                if (temp.nextOpen != null) {
                    temp.nextOpen.prevOpen = entry;
                }
                temp.nextOpen = entry;
                if (entry.prevOpen == this.last) {
                    this.last = entry;
                }
            }
        }
        ++this.size;
    }

    public void remove(IndexEntry entry) {
        if (this.size == 0 || entry == null) {
            return;
        }
        if (!entry.isOpen()) {
            return;
        }
        entry.setOpen(false);
        if (entry.prevOpen != null) {
            entry.prevOpen.nextOpen = entry.nextOpen;
        }
        if (entry.nextOpen != null) {
            entry.nextOpen.prevOpen = entry.prevOpen;
        }
        if (entry == this.first) {
            this.first = entry.nextOpen;
        }
        if (entry == this.last) {
            this.last = entry.prevOpen;
        }
        entry.nextOpen = null;
        entry.prevOpen = null;
        --this.size;
    }

    public void dump() {
        IndexEntry temp = this.first;
        int i = 0;
        while (temp != null) {
            System.out.println(i++ + ") " + temp.timestamp.toString((Context)showSecs) + " open=" + temp.isOpen());
            temp = temp.nextOpen;
        }
    }

    public void verify() {
        IndexEntry prev = null;
        IndexEntry temp = this.first;
        int count = 0;
        while (temp != null) {
            ++count;
            if (prev != null && prev.timestamp.isAfter(temp.timestamp)) {
                throw new IllegalStateException("Invalid ascending order.  " + temp.timestamp.toString((Context)showSecs) + " is before " + prev.timestamp.toString((Context)showSecs));
            }
            if (!temp.isOpen()) {
                throw new IllegalStateException("Cleared alarm in open index, ascending. " + temp.timestamp.toString((Context)showSecs));
            }
            prev = temp;
            temp = temp.nextOpen;
        }
        if (this.size != count) {
            throw new IllegalStateException("Invalid ascending count. size=" + this.size + ", count=" + count);
        }
        prev = null;
        temp = this.last;
        count = 0;
        while (temp != null) {
            ++count;
            if (prev != null && prev.timestamp.isBefore(temp.timestamp)) {
                throw new IllegalStateException("Invalid descending order.  " + temp.timestamp.toString((Context)showSecs) + " is after " + prev.timestamp.toString((Context)showSecs));
            }
            if (!temp.isOpen()) {
                throw new IllegalStateException("Cleared alarm in open index, descending. " + temp.timestamp.toString((Context)showSecs));
            }
            prev = temp;
            temp = temp.prevOpen;
        }
        if (this.size != count) {
            throw new IllegalStateException("Invalid descending count. size=" + this.size + ", count=" + count);
        }
    }
}

