/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.AlarmStore;
import com.tridium.alarm.db.file.Page;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;

public class Block {
    private AlarmStore store;
    private int index;
    private byte[] data;
    private Page[] pages;
    private Input in;
    private Output out;
    private boolean dirty = true;
    Block prev;
    Block next;

    public Block(AlarmStore store, int index) {
        this.store = store;
        this.index = index;
        int pageSize = store.getHeader().getPageSize();
        int pagesPerBlock = store.getHeader().getPagesPerBlock();
        this.data = new byte[pageSize * pagesPerBlock];
        this.pages = new Page[pagesPerBlock];
        this.out = new Output(this);
        this.in = new Input(this.data);
    }

    public int getSize() {
        return this.data.length;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clear() throws IOException {
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = new Page(this, i, this.store.getHeader().getPageSize());
            this.pages[i].clear();
        }
    }

    public void read(DataInput in) throws IOException {
        in.readFully(this.data);
        this.dirty = false;
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.data);
        this.dirty = false;
    }

    public synchronized Page getPage(int blockPage) throws IOException {
        if (this.pages == null) {
            this.pages = new Page[this.store.getHeader().getPagesPerBlock()];
        }
        try {
            if (this.pages[blockPage] == null) {
                this.pages[blockPage] = this.initPage(blockPage);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            int pagesPerBlock = this.store.getHeader().getPagesPerBlock();
            throw new IllegalArgumentException("Invalid page index: " + blockPage + ". Pages per block = " + pagesPerBlock);
        }
        return this.pages[blockPage];
    }

    private Page initPage(int index) throws IOException {
        Page p = new Page(this, index, this.store.getHeader().getPageSize());
        p.read();
        return p;
    }

    public void dump() throws IOException {
        int pages = this.store.getHeader().getPagesPerBlock();
        for (int i = 0; i < pages; ++i) {
            Page p = this.getPage(i);
            System.out.println(i + "] " + p.getPageOfRecord() + " of " + p.getPagesOfRecord());
        }
    }

    public Input getInput() {
        return this.in;
    }

    public int write(int pos, int b) {
        this.data[pos] = (byte)b;
        this.dirty = true;
        return pos + 1;
    }

    public int write(int pos, byte[] buf, int offset, int len) {
        System.arraycopy(buf, offset, this.data, pos, len);
        this.dirty = true;
        return pos + len;
    }

    public int writeInt(int pos, int v) {
        this.write(pos++, v >>> 24 & 0xFF);
        this.write(pos++, v >>> 16 & 0xFF);
        this.write(pos++, v >>> 8 & 0xFF);
        this.write(pos++, v >>> 0 & 0xFF);
        return pos;
    }

    public Output getOutput() {
        return this.out;
    }

    public class Output {
        private Block block;
        private int pos;

        public Output(Block block) {
            this.block = block;
        }

        public void seek(int pos) {
            this.pos = pos;
        }

        public void write(int b) {
            this.block.write(this.pos++, b);
        }

        public void write(byte[] buf) {
            this.pos = this.block.write(this.pos, buf, 0, buf.length);
        }

        public void write(byte[] buf, int offset, int len) {
            this.pos = this.block.write(this.pos, buf, offset, len);
        }

        public void writeInt(int v) {
            this.pos = this.block.writeInt(this.pos, v);
        }
    }

    public class Input {
        private byte[] buffer;
        private int length;
        private int pos;

        public Input(byte[] buffer) {
            this.buffer = buffer;
            this.length = buffer.length;
            this.pos = 0;
        }

        public void seek(int pos) {
            this.pos = pos;
        }

        public int read() throws IOException {
            try {
                return this.buffer[this.pos++] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new EOFException();
            }
        }

        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        public int read(byte[] buf, int offset, int len) throws IOException {
            int actual = Math.min(len, this.length - this.pos);
            if (actual == 0) {
                return -1;
            }
            System.arraycopy(this.buffer, this.pos, buf, offset, actual);
            this.pos += actual;
            return actual;
        }

        public void readFully(byte[] buf) throws IOException {
            this.read(buf, 0, buf.length);
        }

        public void readFully(byte[] buf, int offset, int len) throws IOException {
            this.read(buf, offset, len);
        }

        public int readInt() throws IOException {
            return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + (this.read() << 0);
        }
    }
}

