/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.util.ByteBuffer;

public class AlarmStoreHeader {
    private static final int MAGIC = 1611526157;
    private static final int LATEST_VERSION = 1;
    private static final int DEFAULT_HEADER_SIZE = 1024;
    private static final int DEFAULT_PAGE_SIZE = 512;
    private static final int DEFAULT_PAGES_PER_BLOCK = 8;
    private long creationTime = System.currentTimeMillis();
    private int version = 1;
    private int recordVersion;
    private long dataOffset;
    private int pageSize = 512;
    private int pagesPerBlock = 8;
    private boolean newStore = true;
    private ByteBuffer writeBuffer;

    public AlarmStoreHeader() {
        this(0);
    }

    public AlarmStoreHeader(int recordVersion) {
        this.recordVersion = recordVersion;
    }

    public void write(DataOutput out) throws IOException {
        if (this.writeBuffer == null) {
            this.writeBuffer = new ByteBuffer(1024);
        } else {
            this.writeBuffer.reset();
        }
        this.writeBuffer.writeInt(1611526157);
        this.writeBuffer.writeInt(this.version);
        this.writeBuffer.writeInt(this.recordVersion);
        this.writeBuffer.writeLong(this.creationTime);
        this.writeBuffer.writeInt(this.pageSize);
        this.writeBuffer.writeInt(this.pagesPerBlock);
        int size1 = this.writeBuffer.getLength();
        int headerSize = size1 + 8;
        if (this.newStore) {
            this.writeBuffer.writeTo(out, 0, size1);
            this.dataOffset = Math.max(headerSize, 1024);
            out.writeLong(this.dataOffset);
            int padding = (int)this.dataOffset - headerSize;
            out.write(new byte[padding]);
        } else {
            if ((long)headerSize > this.dataOffset) {
                throw new IOException("Header overflow: " + headerSize + " > " + this.dataOffset);
            }
            this.writeBuffer.writeTo(out, 0, size1);
            out.writeLong(this.dataOffset);
        }
    }

    public void read(DataInput in) throws IOException {
        this.newStore = false;
        int magic = in.readInt();
        if (magic != 1611526157) {
            throw new IOException("Invalid or corrupt alarm database.");
        }
        this.version = in.readInt();
        if (this.version != 1) {
            throw new IOException("Unrecognized alarm db version: " + this.version);
        }
        this.recordVersion = in.readInt();
        this.creationTime = in.readLong();
        this.pageSize = in.readInt();
        this.pagesPerBlock = in.readInt();
        this.dataOffset = in.readLong();
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPagesPerBlock() {
        return this.pagesPerBlock;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }
}

