/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db;

import com.tridium.alarm.AlarmUtil;
import com.tridium.alarm.db.AlarmQuery;
import com.tridium.alarm.db.BIAlarmResolver;
import javax.baja.agent.BIAgent;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"baja:LocalHost"})})
@NiagaraSingleton
public final class BLocalAlarmResolver
extends BSingleton
implements BIAlarmResolver,
BIAgent {
    @Generated
    public static final BLocalAlarmResolver INSTANCE = new BLocalAlarmResolver();
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalAlarmResolver.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BLocalAlarmResolver() {
    }

    @Override
    public OrdTarget resolve(BISession session, OrdTarget base, AlarmQuery query) {
        BOrd serviceOrd = BOrd.make((String)"service:alarm:AlarmService");
        BAlarmService alarmService = (BAlarmService)serviceOrd.resolve(base.get()).get();
        boolean archiveQuery = query != null && query.getBody() != null && query.getBody().startsWith("archive");
        try {
            if (archiveQuery) {
                if (!alarmService.getAlarmArchive().isPresent()) {
                    throw new UnresolvedException("Alarm archive is not present");
                }
                String queryBody = query.getBody().replace("archive", "");
                if (queryBody.isEmpty()) {
                    return new OrdTarget(base, (BObject)alarmService.getAlarmArchive().get());
                }
                query = new AlarmQuery(query.getBody().substring("archive".length() + 1));
                return AlarmUtil.resolveUuidQuery(base, query, alarmService.getAlarmArchive().get());
            }
            if (query.isDbQuery()) {
                return new OrdTarget(base, (BObject)alarmService.getAlarmDb());
            }
            return AlarmUtil.resolveUuidQuery(base, query, alarmService.getAlarmDb());
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder("Cannot access alarm ");
            message.append(archiveQuery ? "archive" : "database");
            throw new UnresolvedException(message.toString(), (Throwable)e);
        }
    }
}

