/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.archive;

import javax.baja.alarm.BAlarmRecord;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;

public final class CombinedAlarmRecordCursor
implements Cursor<BAlarmRecord> {
    private AlarmDatabaseType lastRecordReadFrom;
    private boolean dbNextAvailable;
    private boolean archiveNextAvailable;
    private final Cursor<BAlarmRecord> dbCursor;
    private final Cursor<BAlarmRecord> archiveCursor;
    private final Context cx;

    public CombinedAlarmRecordCursor(Cursor<BAlarmRecord> dbCursor, Cursor<BAlarmRecord> archiveCursor, Context cx) {
        this.dbCursor = dbCursor;
        this.archiveCursor = archiveCursor;
        this.cx = cx;
    }

    public Context getContext() {
        return this.cx;
    }

    public boolean next() {
        if (this.lastRecordReadFrom == null || this.lastRecordReadFrom == AlarmDatabaseType.DATABASE) {
            this.dbNextAvailable = this.dbCursor.next();
        }
        if (this.lastRecordReadFrom == null || this.lastRecordReadFrom == AlarmDatabaseType.ARCHIVE) {
            this.archiveNextAvailable = this.archiveCursor.next();
        }
        return this.dbNextAvailable || this.archiveNextAvailable;
    }

    public BAlarmRecord get() {
        BAlarmRecord dbRec = this.dbNextAvailable ? (BAlarmRecord)((Object)this.dbCursor.get()) : null;
        BAlarmRecord archiveRec = this.archiveNextAvailable ? (BAlarmRecord)((Object)this.archiveCursor.get()) : null;
        if (dbRec == null && archiveRec == null) {
            return null;
        }
        if (dbRec == null) {
            this.lastRecordReadFrom = AlarmDatabaseType.ARCHIVE;
            return archiveRec;
        }
        if (archiveRec == null) {
            this.lastRecordReadFrom = AlarmDatabaseType.DATABASE;
            return dbRec;
        }
        if (!dbRec.getTimestamp().isAfter(archiveRec.getTimestamp())) {
            this.lastRecordReadFrom = AlarmDatabaseType.DATABASE;
            return dbRec;
        }
        this.lastRecordReadFrom = AlarmDatabaseType.ARCHIVE;
        return archiveRec;
    }

    public void close() {
        try {
            this.dbCursor.close();
        }
        finally {
            this.archiveCursor.close();
        }
    }

    public static enum AlarmDatabaseType {
        DATABASE,
        ARCHIVE;

    }
}

