/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.ack;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=2051), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="ackAlarmsFromSameSource", type="boolean", defaultValue="true"), @NiagaraProperty(name="lastAlarmAcked", type="String", defaultValue="", flags=2115), @NiagaraProperty(name="lastAlarmAckedTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=2115), @NiagaraProperty(name="lastAlarmAckedFailureTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=2115), @NiagaraProperty(name="lastAlarmAckedFailureCause", type="String", defaultValue="", flags=2115), @NiagaraProperty(name="totalAlarmsAckedToday", type="int", defaultValue="0", flags=2115), @NiagaraProperty(name="totalAlarmAckedFailures", type="int", defaultValue="0", flags=2115), @NiagaraProperty(name="totalMessagesReceivedToday", type="int", defaultValue="0", flags=2115)})
@NiagaraAction(name="resetTotals", flags=20)
@NiagaraTopic(name="alarmAcked", eventType="BAlarmRecord")
public abstract class BAlarmAcknowledger
extends BComponent
implements BIStatus {
    @Generated
    public static final Property status = BAlarmAcknowledger.newProperty((int)2051, (BValue)BStatus.ok, null);
    @Generated
    public static final Property enabled = BAlarmAcknowledger.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property ackAlarmsFromSameSource = BAlarmAcknowledger.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property lastAlarmAcked = BAlarmAcknowledger.newProperty((int)2115, (String)"", null);
    @Generated
    public static final Property lastAlarmAckedTime = BAlarmAcknowledger.newProperty((int)2115, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastAlarmAckedFailureTime = BAlarmAcknowledger.newProperty((int)2115, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property lastAlarmAckedFailureCause = BAlarmAcknowledger.newProperty((int)2115, (String)"", null);
    @Generated
    public static final Property totalAlarmsAckedToday = BAlarmAcknowledger.newProperty((int)2115, (int)0, null);
    @Generated
    public static final Property totalAlarmAckedFailures = BAlarmAcknowledger.newProperty((int)2115, (int)0, null);
    @Generated
    public static final Property totalMessagesReceivedToday = BAlarmAcknowledger.newProperty((int)2115, (int)0, null);
    @Generated
    public static final Action resetTotals = BAlarmAcknowledger.newAction((int)20, null);
    @Generated
    public static final Topic alarmAcked = BAlarmAcknowledger.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmAcknowledger.class);
    private Clock.Ticket resetTicket = null;
    protected static final String UUID_TEXT = "UUID:";
    protected static final int UUID_LENGTH = 36;
    protected static final Logger log = Logger.getLogger("alarm.acknowledger");
    private static Worker worker = null;
    private static final Object compRefCountMonitor = new Object();
    private static int compRefCount = 0;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public boolean getAckAlarmsFromSameSource() {
        return this.getBoolean(ackAlarmsFromSameSource);
    }

    @Generated
    public void setAckAlarmsFromSameSource(boolean v) {
        this.setBoolean(ackAlarmsFromSameSource, v, null);
    }

    @Generated
    public String getLastAlarmAcked() {
        return this.getString(lastAlarmAcked);
    }

    @Generated
    public void setLastAlarmAcked(String v) {
        this.setString(lastAlarmAcked, v, null);
    }

    @Generated
    public BAbsTime getLastAlarmAckedTime() {
        return (BAbsTime)this.get(lastAlarmAckedTime);
    }

    @Generated
    public void setLastAlarmAckedTime(BAbsTime v) {
        this.set(lastAlarmAckedTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastAlarmAckedFailureTime() {
        return (BAbsTime)this.get(lastAlarmAckedFailureTime);
    }

    @Generated
    public void setLastAlarmAckedFailureTime(BAbsTime v) {
        this.set(lastAlarmAckedFailureTime, (BValue)v, null);
    }

    @Generated
    public String getLastAlarmAckedFailureCause() {
        return this.getString(lastAlarmAckedFailureCause);
    }

    @Generated
    public void setLastAlarmAckedFailureCause(String v) {
        this.setString(lastAlarmAckedFailureCause, v, null);
    }

    @Generated
    public int getTotalAlarmsAckedToday() {
        return this.getInt(totalAlarmsAckedToday);
    }

    @Generated
    public void setTotalAlarmsAckedToday(int v) {
        this.setInt(totalAlarmsAckedToday, v, null);
    }

    @Generated
    public int getTotalAlarmAckedFailures() {
        return this.getInt(totalAlarmAckedFailures);
    }

    @Generated
    public void setTotalAlarmAckedFailures(int v) {
        this.setInt(totalAlarmAckedFailures, v, null);
    }

    @Generated
    public int getTotalMessagesReceivedToday() {
        return this.getInt(totalMessagesReceivedToday);
    }

    @Generated
    public void setTotalMessagesReceivedToday(int v) {
        this.setInt(totalMessagesReceivedToday, v, null);
    }

    @Generated
    public void resetTotals() {
        this.invoke(resetTotals, null, null);
    }

    @Generated
    public void fireAlarmAcked(BAlarmRecord event) {
        this.fire(alarmAcked, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 12: {
                this.fwStopped();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fwStarted() {
        int temp;
        this.setStatus(this.getEnabled() ? BStatus.ok : BStatus.disabled);
        Object object = compRefCountMonitor;
        synchronized (object) {
            temp = ++compRefCount;
        }
        if (temp == 1) {
            log.fine("Starting Alarm Acknowledger Worker");
            worker = new Worker((Worker.ITodo)new Queue(512));
            worker.start("alarmAcknowledger");
        }
        this.startMidnightReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fwStopped() {
        int temp;
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
            this.resetTicket = null;
        }
        Object object = compRefCountMonitor;
        synchronized (object) {
            temp = --compRefCount;
        }
        if (temp <= 0) {
            log.fine("Stopping Alarm Acknowledger Worker");
            worker.stop();
            worker = null;
        }
    }

    private final void fwChanged(Property property) {
        if (this.isRunning() && property == enabled) {
            this.setStatus(this.getEnabled() ? BStatus.ok : BStatus.disabled);
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == resetTotals) {
            this.post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    private final void incTotalAlarmsAckedToday() {
        int n = this.getTotalAlarmsAckedToday();
        if (++n >= Integer.MAX_VALUE) {
            n = 0;
        }
        this.setTotalAlarmsAckedToday(n);
    }

    protected final void incTotalAlarmAckedFailures() {
        int n = this.getTotalAlarmAckedFailures();
        if (++n >= Integer.MAX_VALUE) {
            n = 0;
        }
        this.setTotalAlarmAckedFailures(n);
    }

    protected final void incTotalMessagesReceivedToday() {
        int n = this.getTotalMessagesReceivedToday();
        if (++n >= Integer.MAX_VALUE) {
            n = 0;
        }
        this.setTotalMessagesReceivedToday(n);
    }

    public final void doResetTotals() {
        this.setTotalAlarmsAckedToday(0);
        this.setTotalAlarmAckedFailures(0);
        this.setTotalMessagesReceivedToday(0);
        this.startMidnightReset();
    }

    protected final void doFail(String cause) {
        this.setLastAlarmAckedFailureCause(cause);
        this.setLastAlarmAckedFailureTime(BAbsTime.now());
        this.incTotalAlarmAckedFailures();
    }

    protected final void ackAlarm(BUuid uuid, String userName) {
        block37: {
            try {
                BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
                    BAlarmRecord rec = (BAlarmRecord)conn.getRecord(uuid).newCopy(true);
                    if (rec == null) {
                        this.doFail("Could not find alarm record to ack (" + this.getType() + ")");
                        return;
                    }
                    if (!rec.isAcknowledged()) {
                        rec.ackAlarm(userName);
                        rec.setAckState(BAckState.ackPending);
                        conn.update(rec);
                        this.setLastAlarmAcked(rec.getUuid().encodeToString());
                        alarmService.ackAlarm(rec);
                        this.fireAlarmAcked(rec);
                        this.incTotalAlarmsAckedToday();
                        this.setLastAlarmAckedTime(BAbsTime.now());
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this.getType() + " acknowledged " + rec.getUuid());
                        }
                    } else if (log.isLoggable(Level.FINE)) {
                        log.fine(this.getType() + " already acknowledged " + rec.getUuid());
                    }
                    if (!this.getAckAlarmsFromSameSource()) break block37;
                    StringBuilder bqlBuff = new StringBuilder();
                    bqlBuff.append("alarm:|bql:select from openAlarms where ackState != 'acked' and source='");
                    bqlBuff.append(SlotPath.escape((String)rec.getSource().encodeToString()));
                    bqlBuff.append("'");
                    BITable table = (BITable)BOrd.make((String)bqlBuff.toString()).get((BObject)this);
                    Array ar = new Array(BAlarmRecord.class);
                    try (TableCursor cursor = table.cursor();){
                        while (cursor.next()) {
                            ar.add((Object)((BAlarmRecord)((BAlarmRecord)((Object)cursor.get())).asValue().newCopy(true)));
                        }
                    }
                    boolean acked = false;
                    BAlarmRecord[] records = (BAlarmRecord[])ar.trim();
                    for (int i = 0; i < records.length; ++i) {
                        BAlarmRecord record = (BAlarmRecord)records[i].newCopy(true);
                        record.ackAlarm(userName);
                        record.setAckState(BAckState.ackPending);
                        conn.update(record);
                        alarmService.ackAlarm(record);
                        this.fireAlarmAcked(record);
                        this.setLastAlarmAcked(records[i].getUuid().encodeToString());
                        this.incTotalAlarmsAckedToday();
                        acked = true;
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine(this.getType() + " also acknowledged " + records[i].getUuid());
                    }
                    if (acked) {
                        this.setLastAlarmAckedTime(BAbsTime.now());
                    }
                }
            }
            catch (Exception e) {
                String s = "Failure to acknowledge alarm (" + this.getType() + ")";
                log.log(Level.SEVERE, s, e);
                this.doFail(s);
            }
        }
    }

    protected final void post(Runnable r) {
        ((Queue)worker.getTodo()).enqueue((Object)r);
    }

    private void startMidnightReset() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
        }
        BAbsTime now = BAbsTime.now();
        BAbsTime next = now.nextDay();
        BAbsTime midnight = next.timeOfDay(0, 0, 0, 0);
        this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)midnight, (Action)resetTotals, null);
    }
}

