/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAlarmExtStatusJob
extends BJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmExtStatusJob.class);
    private static final int BATCH_SIZE = 20;
    BAlarmService alarmService;
    BVector extOrds;
    BAlarmTransitionBits bits;
    boolean enableExt;
    boolean canceled = false;
    JobThread thread;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmExtStatusJob(BAlarmService alarmService, BVector extOrds, BAlarmTransitionBits bits, boolean enableExt) {
        this.alarmService = alarmService;
        this.extOrds = extOrds;
        this.enableExt = enableExt;
        this.bits = bits;
    }

    public BAlarmExtStatusJob() {
    }

    public void doRun(Context cx) {
        this.thread = new JobThread(this.toPathString(), cx);
        this.thread.start();
    }

    public void run(Context cx) throws Exception {
        if (this.alarmService == null) {
            throw new IllegalStateException("Must submit thru AlarmService.enable/disableExtensions()");
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        boolean success = true;
        String enableText = this.enableExt ? "Enabling" : "Disabling";
        this.log().start(enableText + " Selected Alarm Extensions");
        int iteration = 0;
        int total = this.extOrds.getSlotCount();
        if (total <= 0) {
            total = 1;
        }
        try (SlotCursor c = this.extOrds.getProperties();){
            while (c.next(BOrd.class)) {
                if (iteration % 20 == 0) {
                    this.progress((int)((float)iteration / (float)total * 100.0f));
                }
                ++iteration;
                BOrd extOrd = (BOrd)c.get();
                BAlarmSourceExt ext = null;
                try {
                    ext = (BAlarmSourceExt)extOrd.resolve((BObject)this.alarmService).get();
                    ext.setAlarmEnable(BAlarmTransitionBits.make(ext.getAlarmEnable(), this.bits, this.enableExt));
                }
                catch (Exception ex) {
                    this.log().failed("  Encountered Problem " + enableText + " " + (ext != null ? ext.getName() : "an unknown alarm extension.  "), (Throwable)ex);
                    success = false;
                }
                if (!this.canceled) continue;
                break;
            }
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        if (success) {
            this.log().success(enableText + " Selected Alarm Extensions Complete");
        } else {
            this.log().failed("Encountered Problems " + enableText + " Selected Alarm Extensions");
        }
    }

    public void doCancel(Context cx) {
        this.canceled = true;
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    class JobThread
    extends Thread {
        Context cx;

        JobThread(String name, Context cx) {
            super(name);
            this.cx = cx;
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                BAlarmExtStatusJob.this.run(this.cx);
                BAlarmExtStatusJob.this.success();
            }
            catch (Throwable e) {
                BAlarmExtStatusJob.this.failed(e);
            }
        }
    }
}

