/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.AlarmActionEnum;
import com.tridium.alarm.BConsoleRecipient;
import com.tridium.alarm.fox.FoxAlarmCodec;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.NiagaraStation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;

@NiagaraType
@NiagaraAction(name="routeAlarmAcks", flags=4)
public class BAlarmConsoleChannel
extends BFoxChannel
implements BiConsumer<BConsoleRecipient, BAlarmRecord> {
    @Generated
    public static final Action routeAlarmAcks = BAlarmConsoleChannel.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmConsoleChannel.class);
    private final BlockingQueue<FoxMessage> newQueue = new LinkedBlockingQueue<FoxMessage>();
    private final BlockingQueue<BAlarmRecord> ackQueue = new LinkedBlockingQueue<BAlarmRecord>();
    private final Map<BConsoleRecipient, Integer> registeredConsoleRecipients = new WeakHashMap<BConsoleRecipient, Integer>();
    private volatile Worker worker;
    private final Object workerMonitor = new Object();
    public static final Object CHANNEL_MUTEX = new Object();
    private static final Logger LOG = Logger.getLogger("alarmConsoleChannel.newAlarms");

    @Generated
    public void routeAlarmAcks() {
        this.invoke(routeAlarmAcks, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAlarmConsoleChannel() {
        this("alarmui");
    }

    protected BAlarmConsoleChannel(String logName) {
        super(logName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker() {
        Object object = this.workerMonitor;
        synchronized (object) {
            if (this.worker == null && this.getConnection() != null && !this.getConnection().getConnectionTarget(NiagaraStation.class).isPresent()) {
                this.worker = new Worker();
                this.worker.start();
                if (this.isTraceOn()) {
                    this.trace("Started alarm console channel worker");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorker() {
        Object object = this.workerMonitor;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.kill();
                this.worker = null;
                if (this.isTraceOn()) {
                    this.trace("Stopped alarm console channel worker");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped() throws Exception {
        this.stopWorker();
        Object object = this.workerMonitor;
        synchronized (object) {
            this.registeredConsoleRecipients.forEach((recipient, counter) -> recipient.unregisterAlarmHandler(this));
            this.registeredConsoleRecipients.clear();
        }
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (this.isTraceOn()) {
            this.trace("AlarmConsoleChannel: command = " + command);
        }
        if (command == "ack") {
            return this.ackAlarms(request);
        }
        if (command == "updateAlarm") {
            return this.updateAlarm(request);
        }
        if (command == "getInitialAlarmQuery") {
            return this.getInitialAlarmQuery(request);
        }
        if (command == "unregister") {
            return this.unregister(request);
        }
        throw new InvalidCommandException(command);
    }

    private void newAlarm(BConsoleRecipient recip, BAlarmRecord alarm) throws Exception {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass alarmClass = as.lookupAlarmClass(alarm.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = as.getDefaultAlarmClass();
        }
        BUser user = this.getSessionContext().getUser();
        user.check((BIProtected)alarmClass, BPermissions.operatorRead);
        FoxMessage rec = new FoxMessage("alarmRec");
        rec.add("alarm", FoxAlarmCodec.encodeAlarm(alarm));
        String recipOrd = recip.getOrdInSession().encodeToString();
        rec.add("ord", recipOrd);
        this.newQueue.add(rec);
    }

    private FoxResponse ackAlarms(FoxRequest request) throws Exception {
        BAlarmService as;
        if (this.isTraceOn()) {
            this.trace("received: ack");
        }
        BUser user = this.getSessionContext().getUser();
        try {
            as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            return null;
        }
        FoxTuple[] msgs = request.list("alarm");
        Array invalidAlarmClasses = new Array(String.class);
        for (FoxTuple msg : msgs) {
            BAlarmRecord alarm = null;
            try {
                alarm = FoxAlarmCodec.decodeAlarm((FoxMessage)msg);
                BAlarmClass alarmClass = as.lookupAlarmClass(alarm.getAlarmClass());
                if (alarmClass == null) {
                    alarmClass = as.getDefaultAlarmClass();
                }
                user.check((BIProtected)alarmClass, BPermissions.operatorWrite);
                this.ackQueue.add(alarm);
            }
            catch (PermissionException pe) {
                if (alarm == null) continue;
                alarm.setAckState(BAckState.unacked);
                FoxMessage rec = new FoxMessage("alarmRec");
                rec.add("alarm", FoxAlarmCodec.encodeAlarm(alarm));
                rec.add("ord", request.getString("ord"));
                this.newQueue.add(rec);
                if (invalidAlarmClasses.contains((Object)alarm.getAlarmClass())) continue;
                invalidAlarmClasses.add((Object)alarm.getAlarmClass());
                this.error(request.getString("ord"), "Cannot ack alarms from Alarm Class: " + alarm.getAlarmClass(), (Throwable)pe);
            }
            catch (Exception e) {
                this.log.error("Error receiving alarm acks from Console Recipient", (Throwable)e);
            }
        }
        this.routeAlarmAcks();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == routeAlarmAcks) {
            Queue q = (Queue)Sys.getService((Type)BAlarmService.TYPE).fw(601);
            q.enqueue((Object)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doRouteAlarmAcks() {
        BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        ArrayList alarms = new ArrayList();
        this.ackQueue.drainTo(alarms);
        try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
            for (BAlarmRecord alarm : alarms) {
                if (this.isTraceOn()) {
                    this.trace("BAlarmChannel: ack -> routeAlarm: " + alarm.getTimestamp() + " ");
                }
                try {
                    BAlarmRecord rec = conn.getRecord(alarm.getUuid());
                    if (rec == null || rec.getAckState() != BAckState.acked) {
                        String notes;
                        alarm.setLastUpdate(BAbsTime.now());
                        BFacets mergedAlarmData = alarm.getAlarmData();
                        if (rec != null) {
                            mergedAlarmData = BFacets.make((BFacets)alarm.getAlarmData(), (BFacets)rec.getAlarmData());
                        }
                        if ((notes = alarm.getAlarmData().gets("notes", null)) != null) {
                            mergedAlarmData = BFacets.make((BFacets)mergedAlarmData, (BFacets)BFacets.make((String)"notes", (String)notes));
                        }
                        alarm.setAlarmData(mergedAlarmData);
                        if (rec != null && alarm.getNormalTime().isBefore(rec.getNormalTime())) {
                            alarm.setNormalTime(rec.getNormalTime());
                        }
                        conn.update(alarm);
                    }
                    as.doAckAlarm(alarm);
                }
                catch (Exception e) {
                    this.log.error("Error acknowledging alarm from Console Recipient", (Throwable)e);
                }
            }
        }
    }

    private FoxResponse getInitialAlarmQuery(FoxRequest req) throws Exception {
        BConsoleRecipient recip;
        FoxResponse resp = new FoxResponse(req);
        try {
            BOrd recipOrd = (BOrd)BOrd.DEFAULT.decodeFromString(req.getString("ord"));
            recip = (BConsoleRecipient)recipOrd.resolve().get();
            this.registerAlarmHandler(recip);
        }
        catch (Exception e) {
            resp.add("error", e.toString());
            return resp;
        }
        String bqlQuery = recip.getInitialAlarmQuery(this.getSessionContext().getUser());
        resp.add("query", bqlQuery);
        return resp;
    }

    public void error(BConsoleRecipient recip, String message, Throwable t) throws Exception {
        String recipOrd = recip.getOrdInSession().encodeToString();
        this.error(recipOrd, message, t);
    }

    private void error(String recipOrd, String message, Throwable t) throws Exception {
        FoxRequest err = this.makeRequest("error");
        err.add("msg", message);
        err.add("error", t.toString());
        err.add("ord", recipOrd);
        this.sendAsync(err);
    }

    private FoxResponse unregister(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        try {
            BOrd recipOrd = (BOrd)BOrd.DEFAULT.decodeFromString(req.getString("ord"));
            BConsoleRecipient recip = (BConsoleRecipient)recipOrd.resolve().get();
            this.unregisterAlarmHandler(recip);
        }
        catch (Exception e) {
            resp.add("error", e.toString());
        }
        return resp;
    }

    private FoxResponse updateAlarm(FoxRequest request) throws Exception {
        BAlarmService as;
        if (this.isTraceOn()) {
            this.trace("received: updateAlarm");
        }
        FoxResponse resp = new FoxResponse(request);
        try {
            as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            resp.add("error", "Could not find AlarmService");
            return resp;
        }
        String ac = "";
        try {
            BAlarmRecord alarm = FoxAlarmCodec.decodeAlarm(request.getMessage("alarm"));
            AlarmActionEnum alarmAction = AlarmActionEnum.UNKNOWN;
            try {
                alarmAction = AlarmActionEnum.valueOf(request.getString("action"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            BAlarmClass alarmClass = as.lookupAlarmClass(alarm.getAlarmClass());
            if (alarmClass == null) {
                alarmClass = as.getDefaultAlarmClass();
            }
            BUser user = this.getSessionContext().getUser();
            switch (alarmAction) {
                case FORCE_CLEARED: {
                    user.check((BIProtected)alarmClass, BPermissions.adminWrite);
                    break;
                }
                default: {
                    user.check((BIProtected)alarmClass, BPermissions.operatorWrite);
                }
            }
            if (this.isTraceOn()) {
                this.trace("BAlarmChannel: ack -> updateAlarm: " + alarm.getTimestamp() + " " + (Object)((Object)alarm.getSourceState()) + " " + alarm.getAlarmClass());
            }
            alarm.setLastUpdate(BAbsTime.now());
            as.routeAlarm(alarm);
            as.doRouteToSource((BAlarmRecord)alarm.newCopy());
        }
        catch (PermissionException pe) {
            resp.add("error", "Invalid Permissions: " + (Object)((Object)pe));
            this.error(request.getString("ord"), "Cannot update alarms from Alarm Class: " + ac, (Throwable)pe);
        }
        catch (Exception e) {
            resp.add("error", "Could Not Route Alarm Update Request");
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerAlarmHandler(BConsoleRecipient recipient) {
        Object object = this.workerMonitor;
        synchronized (object) {
            this.registeredConsoleRecipients.compute(recipient, (rec, counter) -> {
                int n;
                if (counter == null) {
                    n = 1;
                } else {
                    counter = counter + 1;
                    n = counter;
                }
                return n;
            });
            recipient.registerAlarmHandler(this);
            this.startWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterAlarmHandler(BConsoleRecipient recipient) {
        Object object = this.workerMonitor;
        synchronized (object) {
            if (this.registeredConsoleRecipients.compute(recipient, (rec, counter) -> {
                if (counter == null) {
                    return null;
                }
                return (counter = Integer.valueOf(counter - 1)) <= 0 ? null : counter;
            }) == null) {
                recipient.unregisterAlarmHandler(this);
            }
            if (this.registeredConsoleRecipients.isEmpty()) {
                this.stopWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAlarmHandlerCount(BConsoleRecipient recipient) {
        Object object = this.workerMonitor;
        synchronized (object) {
            return this.registeredConsoleRecipients.getOrDefault((Object)recipient, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRegisteredConsoleRecipientEmpty() {
        Object object = this.workerMonitor;
        synchronized (object) {
            return this.registeredConsoleRecipients.isEmpty();
        }
    }

    @Override
    public void accept(BConsoleRecipient recipient, BAlarmRecord alarmRecord) {
        block2: {
            try {
                this.newAlarm(recipient, alarmRecord);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block2;
                LOG.log(Level.FINE, "Cannot buffer new alarm", e);
            }
        }
    }

    public String toString(Context context) {
        return super.toString(context) + " -> Console Recipients registered: " + this.registeredConsoleRecipients.size() + " -> " + this.getHandleOrd();
    }

    public final class Worker
    implements Runnable {
        public static final int WORKER_SLEEP = 1000;
        private volatile boolean isAlive = true;
        private volatile Thread thread;
        private final List<FoxMessage> alarms = new ArrayList<FoxMessage>();

        public void start() {
            this.isAlive = true;
            this.thread = new Thread((Runnable)this, "AlarmConsoleChannel:Worker");
            this.thread.start();
        }

        public void kill() {
            this.isAlive = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block6: while (this.isAlive) {
                try {
                    int stop;
                    Thread.sleep(1000L);
                    BAlarmConsoleChannel.this.newQueue.drainTo(this.alarms);
                    int BATCH_SIZE = 100;
                    int start = 0;
                    int n = stop = BATCH_SIZE < this.alarms.size() ? BATCH_SIZE : this.alarms.size();
                    if (this.alarms.size() <= 0) continue;
                    while (true) {
                        if (start >= this.alarms.size()) continue block6;
                        FoxRequest msg = BAlarmConsoleChannel.this.makeRequest("new");
                        for (int i = start; i < stop; ++i) {
                            msg.add("alarmRec", this.alarms.get(i));
                        }
                        BAlarmConsoleChannel.this.sendAsync(msg);
                        start = stop;
                        stop = (stop += BATCH_SIZE) < this.alarms.size() ? stop : this.alarms.size();
                    }
                }
                catch (InterruptedException BATCH_SIZE) {
                    continue;
                }
                catch (Throwable e) {
                    BAlarmConsoleChannel.this.log.error("Error sending alarms to Console Recipient", e);
                    continue;
                }
                finally {
                    this.alarms.clear();
                    continue;
                }
                break;
            }
            return;
        }
    }
}

