/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.driver.schedule;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="executionTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BIntervalTriggerMode.make(BRelTime.makeMinutes(5)))", override=true), @NiagaraProperty(name="supervisorId", type="String", defaultValue=""), @NiagaraProperty(name="subordinateVersion", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=9)})
public abstract class BScheduleExport
extends BDescriptor {
    @Generated
    public static final Property executionTime = BScheduleExport.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    @Generated
    public static final Property supervisorId = BScheduleExport.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property subordinateVersion = BScheduleExport.newProperty((int)9, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduleExport.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"cloud.png"), (BIcon)BIcon.std((String)"badges/export.png"));
    private static final String TRACE_REMOVE_LINK = "driver.export.removeLink";
    static Logger log = Logger.getLogger("schedule");

    @Generated
    public String getSupervisorId() {
        return this.getString(supervisorId);
    }

    @Generated
    public void setSupervisorId(String v) {
        this.setString(supervisorId, v, null);
    }

    @Generated
    public BAbsTime getSubordinateVersion() {
        return (BAbsTime)this.get(subordinateVersion);
    }

    @Generated
    public void setSubordinateVersion(BAbsTime v) {
        this.set(subordinateVersion, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public abstract void doExecute();

    public BIcon getIcon() {
        return icon;
    }

    public BAbstractSchedule getExportableSchedule() {
        BAbstractSchedule sup = this.getSupervisor();
        BAbstractSchedule ret = (BAbstractSchedule)sup.newCopy(true);
        this.inlineRefs((BComponent)ret);
        BScheduleExport.cleanLinks((BComponent)ret);
        ret.set("lastModified", (BValue)BScheduleDeviceExt.getVersionOf(sup));
        return ret;
    }

    public BAbstractSchedule getSupervisor() {
        BAbstractSchedule sch;
        try {
            BOrd supervisor = BOrd.make((String)this.getSupervisorId());
            sch = (BAbstractSchedule)supervisor.resolve((BObject)this).get();
        }
        catch (Exception x) {
            throw new BajaRuntimeException(this.getSupervisorId(), (Throwable)x);
        }
        return sch;
    }

    @Override
    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == BDescriptor.execute) {
            if (this.isDisabled()) {
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            try {
                if (BScheduleDeviceExt.getVersionOf(this.getSupervisor()).equals((Object)this.getSubordinateVersion())) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, arg, cx);
        }
        return super.post(action, arg, cx);
    }

    @Override
    protected abstract IFuture postExecute(Action var1, BValue var2, Context var3);

    private static void cleanLinks(BComponent c) {
        SlotCursor cur = c.getProperties();
        ArrayList<BLink> links = new ArrayList<BLink>();
        while (cur.next()) {
            BValue obj = cur.get();
            if (obj instanceof BLink) {
                links.add((BLink)obj);
            }
            if (!(obj instanceof BComponent)) continue;
            BScheduleExport.cleanLinks(obj.asComponent());
        }
        for (BLink link : links) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, Lexicon.make(BScheduleExport.class).getText(TRACE_REMOVE_LINK, new Object[]{c.getDisplayName(null), link.toString(null)}));
            }
            Property prop = link.getPropertyInParent();
            c.remove(prop);
            Slot targetSlot = c.getSlot(link.getTargetSlotName());
            int newFlags = c.getFlags(targetSlot) & 0xFFFF7FFF;
            c.setFlags(targetSlot, newFlags);
        }
    }

    void inlineRefs(BComponent c) {
        SlotCursor cur = c.getProperties();
        while (cur.next(BAbstractSchedule.class)) {
            BOrd ord;
            Property p = cur.property();
            BValue o = cur.get();
            if (o instanceof BScheduleReference && (o = (ord = ((BScheduleReference)o).getRef()).get((BObject)this.getComponentSpace())) != null) {
                o = o.asComponent().newCopy(true);
                c.set(p, o);
            }
            if (!(o instanceof BAbstractSchedule)) continue;
            this.inlineRefs(o.asComponent());
        }
    }
}

