/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driver.file.util;

import java.io.BufferedReader;
import java.io.IOException;
import javax.baja.nre.util.Array;

public class CsvParser {
    private Array<String[]> row = new Array(String[].class);
    private BufferedReader reader;
    private boolean hasNext = true;
    private static char quoteChar = (char)34;
    private static final char COMMA_DELIMITER = ',';

    public CsvParser(BufferedReader reader) {
        this.reader = reader;
    }

    public String[][] parseAll() throws IOException {
        Array list = new Array(String[].class);
        while (this.hasNext) {
            String[] row = this.readLine();
            if (row == null) continue;
            list.add((Object)row);
        }
        return (String[][])list.trim();
    }

    public String[] readLine() throws IOException {
        String nextLine = this.getNextLine();
        return this.hasNext ? this.parseLine(nextLine) : null;
    }

    private String getNextLine() throws IOException {
        String nextLine = this.reader.readLine();
        if (nextLine == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private String[] parseLine(String nextLine) throws IOException {
        if (nextLine == null) {
            return null;
        }
        Array parsedContents = new Array(String.class);
        StringBuilder sb = new StringBuilder();
        boolean inQuotes = false;
        do {
            if (inQuotes) {
                sb.append("\n");
                nextLine = this.getNextLine();
                if (nextLine == null) break;
            }
            for (int i = 0; i < nextLine.length(); ++i) {
                char c = nextLine.charAt(i);
                if (c == quoteChar) {
                    if (inQuotes && nextLine.length() > i + 1 && nextLine.charAt(i + 1) == quoteChar) {
                        sb.append(nextLine.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    inQuotes = !inQuotes;
                    continue;
                }
                if (c == ',' && !inQuotes) {
                    parsedContents.add((Object)sb.toString());
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(c);
            }
        } while (inQuotes);
        parsedContents.add((Object)sb.toString());
        return (String[])parsedContents.trim();
    }
}

