/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import java.util.ArrayList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BNetworkJobStage;
import javax.baja.batchJob.driver.BNetworkStepDetails;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.JobCancelException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BNetworkJobStep
extends BJobStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BNetworkJobStep.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void prepareStep(BObject target) throws Exception {
    }

    protected BNetworkStepDetails makeDetails(BDevice[] devices) {
        BNetworkStepDetails result = new BNetworkStepDetails(this, devices);
        this.add("details?", (BValue)result, 4);
        return result;
    }

    @Override
    public BJobStepDetails[] getJobStepDetails() {
        ArrayList<BJobStepDetails> result = new ArrayList<BJobStepDetails>();
        SlotCursor cr = this.getProperties();
        while (cr.next(BJobStepDetails.class)) {
            result.add((BJobStepDetails)cr.get());
        }
        return result.toArray(new BJobStepDetails[0]);
    }

    public final BNetworkStepDetails run(BBatchJobService svc, BDeviceNetwork nw, BDevice[] devices, DeviceNetworkJobOp op) {
        BNetworkStepDetails stepDetails = null;
        try {
            stepDetails = this.makeDetails(devices);
            this.checkCanceled();
            this.doRun(svc, stepDetails, nw, devices, op);
            this.checkCanceled();
            if (stepDetails.getState().isRunning()) {
                stepDetails.success();
            }
            return stepDetails;
        }
        catch (JobCancelException jce) {
            if (stepDetails != null) {
                stepDetails.canceled();
            }
            return stepDetails;
        }
        catch (Throwable e) {
            if (stepDetails != null) {
                stepDetails.failed(e);
            }
            return stepDetails;
        }
    }

    protected void doInit(BBatchJobService svc, DeviceNetworkJobOp op) throws Exception {
    }

    protected abstract void doRun(BBatchJobService var1, BNetworkStepDetails var2, BDeviceNetwork var3, BDevice[] var4, DeviceNetworkJobOp var5) throws Exception;

    public void jobComplete(DeviceNetworkJobOp op) {
        this.jobComplete((BatchJobOp)op);
    }

    public boolean canCombine(BNetworkJobStep step) {
        return false;
    }

    public void combine(BNetworkJobStep step) {
        throw new IllegalStateException();
    }

    public boolean isCanceled() {
        return this.getJob().isCanceled();
    }

    @Override
    public BBatchJob getJob() {
        return this.getStage().getJob();
    }

    @Override
    public BJobStage getStage() {
        BComplex p;
        for (p = this.getParent(); p != null && !(p instanceof BJobStage); p = p.getParent()) {
        }
        return (BJobStage)p;
    }

    public BNetworkJobStage getNetworkJobStage() {
        return (BNetworkJobStage)this.getStage();
    }

    protected void checkCanceled() {
        this.getNetworkJobStage().checkCanceled();
    }
}

