/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.history;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BIBatchHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.history.BHistoryRecord;
import javax.baja.job.BJobState;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="jobStartTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="detailsType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="stepType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", flags=1), @NiagaraProperty(name="stepDescription", type="String", defaultValue="", flags=1), @NiagaraProperty(name="stepState", type="BJobState", defaultValue="BJobState.unknown", flags=1), @NiagaraProperty(name="endTime", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="disposed", type="boolean", defaultValue="false", flags=1)})
public abstract class BJobStepHistoryRecord
extends BHistoryRecord
implements BIJobStepSummary,
BIBatchHistoryRecord {
    @Generated
    public static final Property jobStartTime = BJobStepHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property detailsType = BJobStepHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property stepType = BJobStepHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    @Generated
    public static final Property stepDescription = BJobStepHistoryRecord.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property stepState = BJobStepHistoryRecord.newProperty((int)1, (BValue)BJobState.unknown, null);
    @Generated
    public static final Property endTime = BJobStepHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property disposed = BJobStepHistoryRecord.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BJobStepHistoryRecord.class);
    protected BJobStepDetails stepDetails = null;
    protected BBatchJob job = null;
    protected BTimeZone localTz = BTimeZone.NULL;

    @Override
    @Generated
    public BAbsTime getJobStartTime() {
        return (BAbsTime)this.get(jobStartTime);
    }

    @Generated
    public void setJobStartTime(BAbsTime v) {
        this.set(jobStartTime, (BValue)v, null);
    }

    @Override
    @Generated
    public BTypeSpec getDetailsType() {
        return (BTypeSpec)this.get(detailsType);
    }

    @Generated
    public void setDetailsType(BTypeSpec v) {
        this.set(detailsType, (BValue)v, null);
    }

    @Override
    @Generated
    public BTypeSpec getStepType() {
        return (BTypeSpec)this.get(stepType);
    }

    @Generated
    public void setStepType(BTypeSpec v) {
        this.set(stepType, (BValue)v, null);
    }

    @Override
    @Generated
    public String getStepDescription() {
        return this.getString(stepDescription);
    }

    @Generated
    public void setStepDescription(String v) {
        this.setString(stepDescription, v, null);
    }

    @Override
    @Generated
    public BJobState getStepState() {
        return (BJobState)this.get(stepState);
    }

    @Generated
    public void setStepState(BJobState v) {
        this.set(stepState, (BValue)v, null);
    }

    @Override
    @Generated
    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    @Generated
    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    @Override
    @Generated
    public boolean getDisposed() {
        return this.getBoolean(disposed);
    }

    @Generated
    public void setDisposed(boolean v) {
        this.setBoolean(disposed, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BJobStepHistoryRecord() {
    }

    protected BJobStepHistoryRecord(BJobStepDetails stepDetails, BAbsTime jobStartTime) {
        this.setJobStartTime(jobStartTime);
        this.update(stepDetails);
    }

    public void setStartTime(BAbsTime value) {
        this.setTimestamp(value);
    }

    @Override
    public BAbsTime getStartTime() {
        return this.getTimestamp();
    }

    @Override
    public BBatchJob getJob(BObject base) throws Exception {
        if (this.job == null) {
            try {
                BBatchJobLogFile file = BBatchJobLogFile.find(this.getLocalJobStartTime(), base);
                this.job = file.getJob();
                this.job.setStartTimeLocalZone(this.localTz);
                this.job.setDisplayTimeZone(this.getJobStartTime().getTimeZone());
            }
            catch (UnresolvedException ue) {
                return null;
            }
        }
        return this.job;
    }

    @Override
    public void update(BJobStepDetails stepDetails) {
        if (stepDetails.getJob() != null) {
            this.setJobStartTime(stepDetails.getJob().getStartTime());
        }
        this.setStepType(stepDetails.getStepType());
        this.setDetailsType(stepDetails.getType().getTypeSpec());
        if (this.getStartTime().getMillis() != stepDetails.getStartTime().getMillis()) {
            this.setStartTime(stepDetails.getStartTime());
        }
        this.setStepState(stepDetails.getState());
        if (this.getEndTime().getMillis() != stepDetails.getEndTime().getMillis()) {
            this.setEndTime(stepDetails.getEndTime());
        }
        this.setStepDescription(stepDetails.getStepDescription());
        this.stepDetails = stepDetails;
    }

    @Override
    public abstract BJobStepDetails getStepDetails(BObject var1) throws Exception;

    @Override
    public void setLocalTimeZone(BTimeZone zone) {
        if (!this.localTz.equals((Object)zone)) {
            this.localTz = zone;
        }
    }

    @Override
    public BAbsTime getLocalJobStartTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getJobStartTime(), this.localTz);
    }

    @Override
    public BAbsTime getLocalStartTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.localTz);
    }

    public BAbsTime getLocalEndTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getEndTime(), this.localTz);
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.localTz = BTimeZone.NULL;
        this.setJobStartTime((BAbsTime)BAbsTime.DEFAULT.decodeFromString(in.readUTF()));
        this.setDetailsType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(in.readUTF()));
        this.setStepType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(in.readUTF()));
        this.setStepDescription(in.readUTF());
        this.setStepState((BJobState)BJobState.unknown.decodeFromString(in.readUTF()));
        this.setEndTime((BAbsTime)BAbsTime.DEFAULT.decodeFromString(in.readUTF()));
        this.setDisposed(in.readBoolean());
    }

    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getJobStartTime().encodeToString());
        out.writeUTF(this.getDetailsType().encodeToString());
        out.writeUTF(this.getStepType().encodeToString());
        out.writeUTF(this.getStepDescription());
        out.writeUTF(this.getStepState().encodeToString());
        out.writeUTF(this.getEndTime().encodeToString());
        out.writeBoolean(this.getDisposed());
    }
}

