/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui.expr;

import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.expr.ExprUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="buttonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4), @NiagaraAction(name="editExpr", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()", flags=4)})
public class BAceExprEditDialog
extends BDialog {
    @Generated
    public static final Action buttonPressed = BAceExprEditDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action editExpr = BAceExprEditDialog.newAction((int)4, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAceExprEditDialog.class);
    BTextEditorPane txtEditor;
    BTextField errorMsg;
    BButton cancelButton;
    BButton okButton;
    int result = 0;
    ExprUtil exprUtil;
    byte[] opCodes = null;
    String equation;
    private static Lexicon LEX = Lexicon.make(BAceExprEditDialog.class);

    @Generated
    public void buttonPressed(BWidgetEvent parameter) {
        this.invoke(buttonPressed, (BValue)parameter, null);
    }

    @Generated
    public void editExpr(BWidgetEvent parameter) {
        this.invoke(editExpr, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAceExprEditDialog() {
    }

    public BAceExprEditDialog(BWidget parent, String title, BAceComponent target) {
        super(parent, title, true);
        this.errorMsg = new BTextField();
        this.errorMsg.setVisibleColumns(60);
        this.errorMsg.setEditable(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        this.txtEditor = new BTextEditorPane(10, 60);
        this.txtEditor.setText(target.get("expr").toString(null));
        this.linkTo((BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo((BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo((BComponent)this.txtEditor.getEditor(), (Slot)BTextEditor.textModified, (Slot)editExpr);
        BGridPane grid = new BGridPane(2);
        grid.add("exprLbl", (BValue)new BLabel("Expr"));
        grid.add("expr", (BValue)this.txtEditor);
        grid.add("errorLbl", (BValue)new BLabel(LEX.getText("ace.expression.edit.error")));
        grid.add("error", (BValue)this.errorMsg);
        BFlowPane bottom = new BFlowPane();
        bottom.setAlign(BHalign.center);
        bottom.add("matchButton", (BValue)this.okButton);
        bottom.add("cancelButton", (BValue)this.cancelButton);
        BEdgePane pane = new BEdgePane();
        pane.setCenter((BWidget)new BBorderPane((BWidget)grid));
        pane.setBottom((BWidget)new BBorderPane((BWidget)bottom));
        this.setContent((BWidget)pane);
        this.exprUtil = new ExprUtil(target);
    }

    public byte[] getOpCodes() {
        return this.opCodes;
    }

    public String getEquation() {
        return this.equation;
    }

    public int getResult() {
        return this.result;
    }

    public void doButtonPressed(BWidgetEvent event) {
        this.close();
        if (event.getWidget().equals((Object)this.okButton)) {
            this.result = 1;
        } else if (event.getWidget().equals((Object)this.cancelButton)) {
            this.result = 2;
        }
    }

    public void doEditExpr(BWidgetEvent event) {
        try {
            this.equation = this.txtEditor.getText();
            this.opCodes = this.exprUtil.convertToOpCodes(this.equation);
            this.errorMsg.setText("");
            this.okButton.setEnabled(true);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            this.expressionError(msg);
        }
    }

    private void expressionError(String errMsg) {
        this.errorMsg.setText(errMsg);
        this.okButton.setEnabled(false);
    }

    public void windowClosing(BWindowEvent event) {
        this.result = 2;
        this.close();
    }
}

