/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.BAceNetwork;
import com.tridium.ace.app.App;
import com.tridium.ace.json.JAppReader;
import com.tridium.ace.kit.ACE;
import com.tridium.ace.kit.Catalog;
import com.tridium.ace.kit.CatalogKit;
import com.tridium.ace.kit.KitRegistry;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.sys.BAceAppFile;
import com.tridium.ace.ui.CatalogListUtil;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.ui.util.ValidatingTextController;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.util.BNotifyPane;

public final class NewAceAppWizard
extends WizardModel {
    private static Lexicon LEX = BAceNetwork.LEX;
    private static final Logger LOG = Logger.getLogger("AceNetwork");
    private static final BImage BANNER = BImage.make((String)"module://icons/x32/page.png");
    private static final String ACE_APP_DEFAULT_DIR = "~ace";
    private static final BOrd ACE_APP_DEFAULT_DIR_ORD = BOrd.make((String)"file:~ace");
    private static final String appFileExtension = ".ace";
    private static final String jsonExtension = "json";
    private static final String coreSysKitName = "core.sys";
    private static BOrd catalogOrd;
    private static BOrd appDirOrd;
    private static String appName;
    private static BNiagaraWbShell shell;
    private CatalogStep catalogStep;

    public static void open(BNiagaraWbShell shell) {
        NewAceAppWizard model = new NewAceAppWizard(shell);
        BWizard.open((BWidget)shell, (WizardModel)model);
    }

    private NewAceAppWizard(BNiagaraWbShell wbShell) {
        shell = wbShell;
        this.catalogStep = new CatalogStep();
    }

    public String getTitle() {
        return LEX.getText("ace.newAceApp.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(420.0, 400.0);
    }

    public void init() {
        this.catalogStep.enter();
    }

    public void back() {
    }

    public void next() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish() {
        shell.enterBusy();
        try {
            int index = this.catalogStep.catalogList.getList().getSelectedIndex();
            String df = this.catalogStep.listUtil.getItem(index);
            String catalogAddress = Sys.getRegistry().getDef(df);
            catalogOrd = BOrd.make((String)catalogAddress);
            if (this.catalogStep.validate()) {
                if (!this.isAppNameValid()) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.canOverwriteAppFile() && this.doesAppFileExist() && 4 != BDialog.confirm((BWidget)this.getWizard(), (Object)LEX.getText("ace.newAceApp.deleteExisting", new Object[]{appName}))) {
                    boolean bl = false;
                    return bl;
                }
                FilePath appDir = new FilePath(this.catalogStep.appDirTextField.getText());
                FilePath appFilePath = appDir.merge(appName + appFileExtension);
                BAceAppFile aceAppFile = new BAceAppFile();
                try {
                    BAceApp defaultAceApp = null;
                    Catalog catalog = ACE.getKitRegistry((String)catalogAddress);
                    App defaultApp = catalog.getDefaultApp();
                    if (defaultApp != null) {
                        HashMap aceComponents = new HashMap();
                        defaultAceApp = new JAppReader().buildComponentTree(defaultApp, aceComponents, catalog);
                        defaultAceApp.setAppName(appName);
                        defaultAceApp.setAppVersion("1.0.0");
                    }
                    aceAppFile.initialize(appName, appFilePath, defaultAceApp, shell.getContext(), catalog);
                }
                catch (Exception e) {
                    this.notifyFinish(LEX.getText("ace.newAceApp.appFileFailure", new Object[]{e.getLocalizedMessage()}), false);
                    LOG.warning(LEX.getText("ace.newAceApp.appFileFailure", new Object[]{e.getLocalizedMessage()}));
                    boolean bl = false;
                    shell.exitBusy();
                    return bl;
                }
                shell.hyperlink(aceAppFile.getNavOrd());
                this.notifyFinish(LEX.getText("ace.newAceApp.openAceAppFile"), true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            BDialog.error((BWidget)shell, (String)"Error", (Object)LEX.getText("ace.newAceApp.appFileFailure", new Object[]{appName}), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            shell.exitBusy();
        }
    }

    public boolean cancel() {
        return true;
    }

    private void notifyFinish(String detailText, boolean result) {
        BNotifyPane pane = new BNotifyPane();
        BGridPane notifyGrid = new BGridPane(1);
        BLabel label = new BLabel(BImage.make((BIcon)BIcon.make((String)LEX.getText("NewAceAppTool.icon"))), LEX.getText("ace.newAceApp." + (result ? "success" : "failure"), new Object[]{this.catalogStep.appNameTextField.getText()}));
        StyleUtils.addStyleClass((IStylable)label, (String)"strong");
        notifyGrid.add(null, (BValue)label);
        if (detailText != null) {
            label = new BLabel(detailText);
        }
        notifyGrid.add(null, (BValue)label);
        pane.setCenter((BWidget)notifyGrid);
        pane.open(7000);
    }

    private boolean isAppNameValid() {
        return SlotPath.isValidName((String)appName) && appName.length() <= 32;
    }

    private boolean doesAppFileExist() {
        boolean appFileExists = false;
        BDirectory appDir = (BDirectory)appDirOrd.resolve().get();
        if (appDir != null) {
            for (BIFile existingAppFile : appDir.listFiles()) {
                if (!existingAppFile.getFileName().equalsIgnoreCase(appName + appFileExtension)) continue;
                appFileExists = true;
                break;
            }
        }
        return appFileExists;
    }

    private boolean canOverwriteAppFile() {
        return this.catalogStep.deleteExistingApp.isVisible() && this.catalogStep.deleteExistingApp.isSelected();
    }

    private FilePath getAppPath(String appName) {
        FilePath appPath = new FilePath(ACE_APP_DEFAULT_DIR);
        if (appName == null || appName.trim().length() == 0) {
            return appPath;
        }
        return appPath.merge(appName);
    }

    private static String toLocal(FilePath path) {
        return BFileSystem.INSTANCE.pathToLocalFile(path).getAbsolutePath();
    }

    private boolean catalogContainsCoreSys(BOrd catalogFileOrd) {
        KitRegistry catalog = (KitRegistry)ACE.getKitRegistry((BOrd)catalogFileOrd);
        if (catalog == null) {
            LOG.warning(LEX.getText("ace.catalogError", new Object[]{"catalog", "File not exist"}));
        }
        for (CatalogKit kit : catalog.kits()) {
            if (!kit.name().equals(coreSysKitName)) continue;
            return true;
        }
        LOG.warning(LEX.getText("ace.catalogError", new Object[]{"catalog", "core.sys kit not found"}));
        return false;
    }

    public static class DeleteExistingApp {
        public BBooleanFE fieldEditor;
        public BLabel label;
        public BFlowPane content = new BFlowPane(BHalign.left);
        public Context facetsContext;

        public DeleteExistingApp() {
            this.label = new BLabel("");
            this.content.add(null, (BValue)this.label);
            StyleUtils.addStyleClass((IStylable)this.label, (String)"warning");
            this.fieldEditor = new BBooleanFE();
            this.content.add(null, (BValue)this.fieldEditor);
            Lexicon bajaui = Lexicon.make((String)"bajaui", (Context)shell.getContext());
            BFacets facets = BFacets.make((String[])new String[]{"trueText", "falseText"}, (BIDataValue[])new BIDataValue[]{BString.make((String)bajaui.getText("dialog.yes")), BString.make((String)bajaui.getText("dialog.no"))});
            this.facetsContext = new BasicContext(shell.getContext(), facets);
            this.setVisible(false);
            this.setSelected(false);
        }

        public void setVisible(boolean value) {
            this.content.setVisible(value);
            this.content.relayoutSync();
        }

        public boolean isVisible() {
            return this.content.isVisible();
        }

        public void setSelected(boolean value) {
            this.fieldEditor.loadValue((BObject)BBoolean.make((boolean)value), this.facetsContext);
        }

        public void setAppName(String stationName) {
            this.setText(LEX.getText("ace.newAceApp.deleteExisting", new Object[]{stationName}));
        }

        public void setText(String value) {
            this.label.setText(value);
        }

        public boolean isSelected() {
            try {
                return ((BBoolean)this.fieldEditor.saveValue(shell.getContext())).getBoolean();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }

        public BWidget content() {
            return this.content;
        }
    }

    public class SelectAppDir
    extends Command {
        BTextField appDir;
        BImage openIcon;

        public SelectAppDir(BWidget owner, BTextField appDirTextField) {
            super(owner, "");
            this.openIcon = BImage.make((String)"module://icons/x16/open.png");
            this.appDir = appDirTextField;
        }

        public CommandArtifact doInvoke() {
            BDirectoryChooser chooser = BDirectoryChooser.make((BWidget)this.getOwner());
            chooser.setCurrentDirectory(appDirOrd);
            BOrd ord = chooser.show();
            if (ord == null) {
                return null;
            }
            appDirOrd = ord;
            OrdQuery[] q = ord.parse();
            this.appDir.setText(q[q.length - 1].getBody());
            NewAceAppWizard.this.catalogStep.appFilePathUpdated();
            return null;
        }

        public BImage getIcon() {
            return this.openIcon;
        }
    }

    public class CatalogStep
    extends AppStep {
        public BWidget content;
        public BTextField catalogField;
        BListDropDown catalogList;
        CatalogListUtil listUtil;
        public BTextField appDirTextField;
        BButton appDirButton;
        public BTextField appNameTextField;
        public DeleteExistingApp deleteExistingApp;

        public CatalogStep() {
            OrdQuery[] q;
            this.listUtil = new CatalogListUtil();
            if (appDirOrd == null) {
                appDirOrd = ACE_APP_DEFAULT_DIR_ORD;
            }
            try {
                BIFile bIFile = (BIFile)appDirOrd.resolve().get();
            }
            catch (UnresolvedException e) {
                q = appDirOrd.parse();
                FilePath filepath = (FilePath)q[q.length - 1];
                q[q.length - 1] = new FilePath("");
                BFileSpace space = (BFileSpace)BOrd.make((OrdQuery[])q).resolve().get();
                try {
                    space.makeDir(filepath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.catalogList = new BListDropDown();
            this.listUtil.addItemToCatalogList(this.catalogList);
            if (this.catalogList.getList().getItemCount() > 0) {
                int index = 0;
                this.catalogList.getList().setSelectedIndex(index);
            }
            BFlowPane catalogFlow = new BFlowPane(BHalign.left);
            catalogFlow.add(null, (BValue)this.catalogList);
            this.deleteExistingApp = new DeleteExistingApp();
            this.appNameTextField = new BTextField("", 30);
            this.appNameTextField.setModel(new TextModel(){

                protected void textModified() {
                    CatalogStep.this.appNameUpdated();
                }
            });
            this.appNameTextField.setController((TextController)ValidatingTextController.make(updatedText -> updatedText == null || updatedText.length() == 0 || updatedText.length() <= 32 && SlotPath.isValidName((String)updatedText)));
            q = appDirOrd.parse();
            this.appDirTextField = new BTextField(q[q.length - 1].getBody(), 50, false);
            this.appDirButton = new BButton((Command)new SelectAppDir((BWidget)shell, this.appDirTextField));
            this.appDirButton.setButtonStyle(BButtonStyle.toolBar);
            BFlowPane appDirFlow = new BFlowPane(BHalign.left);
            appDirFlow.add(null, (BValue)this.appDirTextField);
            appDirFlow.add(null, (BValue)new BLabel("   "));
            appDirFlow.add(null, (BValue)this.appDirButton);
            appName = this.appNameTextField.getText();
            BGridPane fieldEditorsGrid = new BGridPane(1);
            fieldEditorsGrid.setValign(BValign.top);
            fieldEditorsGrid.add(null, (BValue)new BLabel(LEX.getText("ace.newAceApp.appPath")));
            fieldEditorsGrid.add(null, (BValue)appDirFlow);
            fieldEditorsGrid.add(null, (BValue)new BLabel(LEX.getText("ace.newAceApp.appName")));
            fieldEditorsGrid.add(null, (BValue)this.appNameTextField);
            fieldEditorsGrid.add(null, (BValue)new BLabel(LEX.getText("ace.newAceApp.catalog")));
            fieldEditorsGrid.add(null, (BValue)catalogFlow);
            fieldEditorsGrid.add(null, (BValue)this.deleteExistingApp.content());
            BEdgePane outerEdge = new BEdgePane();
            outerEdge.setTop((BWidget)new BWizardHeader(BANNER, NewAceAppWizard.this.getTitle()));
            outerEdge.setCenter((BWidget)new BBorderPane((BWidget)fieldEditorsGrid, 10.0, 10.0, 10.0, 10.0));
            this.content = outerEdge;
        }

        public void appNameUpdated() {
            appName = this.appNameTextField.getText();
            this.appFilePathUpdated();
        }

        private void appFilePathUpdated() {
            boolean appFileExists;
            BWizard wizard = NewAceAppWizard.this.getWizard();
            boolean appNameIsValid = NewAceAppWizard.this.isAppNameValid();
            boolean bl = appFileExists = appNameIsValid && NewAceAppWizard.this.doesAppFileExist();
            if (appFileExists) {
                this.deleteExistingApp.setAppName(appName);
                this.deleteExistingApp.setVisible(true);
                this.deleteExistingApp.setSelected(false);
            } else {
                this.deleteExistingApp.setVisible(false);
            }
            if (wizard != null) {
                NewAceAppWizard.this.getWizard().setFinishEnabled(appNameIsValid);
            }
        }

        @Override
        public void enter() {
            NewAceAppWizard.this.update(this.content, 0);
        }

        @Override
        public boolean validate() {
            try {
                if (!NewAceAppWizard.this.catalogContainsCoreSys(catalogOrd)) {
                    return false;
                }
                if (this.appDirTextField.getText().length() == 0) {
                    return false;
                }
                FilePath appDir = new FilePath(this.appDirTextField.getText());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private abstract class AppStep {
        private AppStep() {
        }

        public abstract void enter();

        public abstract boolean validate();
    }
}

