/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.BAceNetwork;
import com.tridium.ace.component.BAceComponent;
import com.tridium.ace.sys.BAceApp;
import com.tridium.ace.sys.BAceFolder;
import com.tridium.driver.util.DrUtil;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.BFolderManager;
import javax.baja.workbench.mgr.folder.FolderController;
import javax.baja.workbench.mgr.folder.FolderModel;

@NiagaraType(agent={@AgentOn(types={"ace:AceApp", "ace:AceFolder"})})
public class BAceCompManager
extends BFolderManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BAceCompManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colObjectId = new MgrColumn.PropPath("ObjectId", new Property[]{BAceComponent.objectId}, 4);
    MgrColumn colExeLevel = new LevelColumn();
    MgrColumn colExecOrder = new OrderColumn();
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colObjectId, this.colExeLevel, this.colExecOrder};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new CompModel(this);
    }

    protected MgrController makeController() {
        return new CompController(this);
    }

    public CommandArtifact doForceExe() {
        BComponent c = this.getTarget();
        BAceApp app = c instanceof BAceApp ? (BAceApp)c : (BAceApp)DrUtil.getParent((BComplex)c, (Type)BAceApp.TYPE);
        app.forceExeOrder();
        return null;
    }

    public static class OrderColumn
    extends MgrColumn {
        public OrderColumn() {
            super("Order", 1);
        }

        public Object get(Object tgt) {
            return BInteger.make((int)((BAceComponent)tgt).getExeParam().getExecOrder());
        }

        public BValue load(MgrEditRow row) {
            return (BValue)this.get(row.getTarget());
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAceComponent cp = (BAceComponent)row.getTarget();
            int order = ((BInteger)value).getInt();
            cp.setExecOrder(order, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            BValue v = rows[0].getCell(colIndex);
            if (e == null) {
                e = BWbFieldEditor.makeFor((BObject)v);
            }
            e.loadValue((BObject)v);
            return e;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            OrderColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }
    }

    public static class LevelColumn
    extends MgrColumn {
        public LevelColumn() {
            super("Level", 1);
        }

        public Object get(Object tgt) {
            int level = ((BAceComponent)tgt).getExeParam().getLevel();
            return BInteger.make((int)(level + 1));
        }

        public BValue load(MgrEditRow row) {
            return (BValue)this.get(row.getTarget());
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BAceComponent cp = (BAceComponent)row.getTarget();
            int level = ((BInteger)value).getInt() - 1;
            cp.setLevel(level, cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor e) {
            BValue v = rows[0].getCell(colIndex);
            if (e == null) {
                e = BWbFieldEditor.makeFor((BObject)v);
            }
            e.loadValue((BObject)v);
            return e;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            LevelColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }
    }

    public class CompModel
    extends FolderModel {
        CompModel(BAceCompManager manager) {
            super((BFolderManager)manager);
        }

        public MgrTypeInfo[] getNewTypes() {
            TypeInfo[] types = new TypeInfo[]{BAceComponent.TYPE.getTypeInfo()};
            return MgrTypeInfo.makeArray((TypeInfo[])types);
        }

        protected MgrColumn[] makeColumns() {
            return BAceCompManager.this.cols;
        }

        public Type[] getIncludeTypes() {
            return new Type[]{BAceComponent.TYPE};
        }

        public Type getFolderType() {
            return BAceFolder.TYPE;
        }
    }

    class ForceExeOrder
    extends MgrController.MgrCommand {
        ForceExeOrder(BWidget owner) {
            super(owner, BAceNetwork.LEX, "comp.commands.forceExeOrder");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BAceCompManager.this.doForceExe();
        }
    }

    public class CompController
    extends FolderController {
        public final MgrController.MgrCommand forceExeOrder;

        CompController(BAceCompManager manager) {
            super((BFolderManager)manager);
            this.forceExeOrder = new ForceExeOrder((BWidget)manager);
            this.forceExeOrder.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return CompController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.forceExeOrder});
        }
    }
}

