/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ace.ui;

import com.tridium.ace.BAceDevice;
import com.tridium.ace.BAceNetwork;
import com.tridium.ace.datatypes.BAceDownloadParams;
import com.tridium.ace.ui.BAceDeviceManager;
import com.tridium.driver.util.StringUtil;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;

public class AceDeviceController
extends DeviceController {
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    public static Lexicon LEX = Lexicon.make(BAceNetwork.class);
    public final MgrController.MgrCommand appDownload;

    AceDeviceController(BAceDeviceManager manager) {
        super((BDeviceManager)manager);
        this.appDownload = new AppDownload((BWidget)manager);
        this.appDownload.setFlags(7);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return AceDeviceController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.appDownload});
    }

    public void updateCommands() {
        super.updateCommands();
        this.appDownload.setEnabled(this.getSelectedDevices().length == 1);
    }

    public CommandArtifact doAppDownload() {
        BAceDevice[] devs = this.getSelectedDevices();
        try {
            BTextField tf = new BTextField("~ace", 60);
            tf.setEditable(false);
            BButton appFileBtn = new BButton((Command)new BrowseAceFile((BWidget)this.getManager().getShell(), tf));
            appFileBtn.setButtonStyle(BButtonStyle.toolBar);
            BGridPane appFilePn = new BGridPane(2);
            appFilePn.add(null, (BValue)tf);
            appFilePn.add(null, (BValue)appFileBtn);
            int retVal = BDialog.open((BWidget)this.getManager(), (String)LEX.getText("ace.appDownload.enterFile"), (Object)appFilePn, (int)3);
            if (retVal == 2) {
                return null;
            }
            if (tf.getText().equals("~ace")) {
                BDialog.error((BWidget)this.getManager(), (String)LEX.getText("ace.appDownload.error"), (Object)LEX.getText("ace.appDownload.error.nofile"));
                return null;
            }
            BOrd appOrd = BOrd.make((String)("file:" + tf.getText()));
            BIFile appFile = (BIFile)appOrd.resolve().get();
            byte[] a = appFile.read();
            BBlob blob = BBlob.make((byte[])a);
            BOrd[] ords = new BOrd[devs.length];
            for (int i = 0; i < devs.length; ++i) {
                ords[i] = devs[i].getHandleOrd();
            }
            String szOrds = StringUtil.toString((BSimple[])ords);
            BAceDownloadParams params = new BAceDownloadParams(szOrds, "app.ace", blob, true);
            this.getNetwork().downloadApp(params);
        }
        catch (Exception e) {
            BDialog.error((BWidget)this.getManager(), (String)"Error:", (Object)e, (Throwable)e);
            return null;
        }
        return null;
    }

    private BAceDevice[] getSelectedDevices() {
        if (this.getTable() == null) {
            return new BAceDevice[0];
        }
        BComponent[] a = this.getTable().getSelectedComponents();
        Array al = new Array(BAceDevice.class);
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getType().is(BAceDevice.TYPE)) continue;
            al.add((Object)((BAceDevice)a[i]));
        }
        return (BAceDevice[])al.trim();
    }

    private BAceNetwork getNetwork() {
        return ((BAceDeviceManager)this.getManager()).getNetwork();
    }

    static class BrowseAceFile
    extends Command {
        BTextField txt;

        BrowseAceFile(BWidget owner, BTextField t) {
            super(owner, "");
            this.txt = t;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd file = null;
            try {
                BFileChooser c = BFileChooser.makeOpen((BWidget)this.getShell());
                c.setCurrentDirectory(BOrd.make((String)("local:|file:" + this.txt.getText())));
                c.clearFilters();
                c.addFilter((IFileFilter)new ExtFileFilter(LEX.getText("ace.appFileDescription"), "ace"));
                file = c.show();
            }
            catch (Throwable c) {
                // empty catch block
            }
            if (file != null) {
                OrdQuery[] q = file.parse();
                this.txt.setText(q[q.length - 1].getBody());
                this.txt.repaint();
            } else {
                this.txt.setText("");
            }
            return null;
        }
    }

    class AppDownload
    extends MgrController.MgrCommand {
        AppDownload(BWidget owner) {
            super(owner, LEX, "commands.appDownload");
        }

        public CommandArtifact doInvoke() throws Exception {
            return AceDeviceController.this.doAppDownload();
        }
    }
}

