/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.processor;

import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.model.Range;
import java.util.LinkedList;
import java.util.Optional;

public class EnumProcessor {
    private final GeneratedCodeBlock cg;
    private final String className;

    public EnumProcessor(GeneratedCodeBlock cg, String className) {
        this.cg = cg;
        this.className = className;
    }

    public void accept(LinkedList<Range> rangeList, Optional<String> defaultValue) {
        if (rangeList.isEmpty()) {
            return;
        }
        int ordinal = 0;
        for (Range range : rangeList) {
            if (range.getOrdinal().isPresent()) continue;
            range.setOrdinal(String.valueOf(ordinal));
            ++ordinal;
        }
        this.cg.println();
        rangeList.stream().forEachOrdered(rs -> {
            String constName = CodeGenerator.toFlagName(rs.getName());
            String ordinalString = String.valueOf(rs.getOrdinal().orElseThrow(() -> new IllegalStateException("Range must have an ordinal")));
            this.cg.println("/** Ordinal value for " + rs.getName() + ". */");
            this.cg.println("public static final int " + constName + " = " + ordinalString + ";");
        });
        this.cg.println();
        rangeList.stream().forEachOrdered(rs -> {
            String constName = CodeGenerator.toFlagName(rs.getName());
            this.cg.println("/** " + this.className + " constant for " + rs.getName() + ". */");
            this.cg.println("public static final " + this.className + " " + rs.getName() + " = new " + this.className + "(" + constName + ");");
        });
        Range first = rangeList.getFirst();
        this.cg.println();
        this.cg.println("/** Factory method with ordinal. */");
        this.cg.println("public static " + this.className + " make(int ordinal)");
        this.cg.println("{");
        this.cg.println("  return (" + this.className + ")" + first.getName() + ".getRange().get(ordinal, false);");
        this.cg.println("}");
        this.cg.println();
        this.cg.println("/** Factory method with tag. */");
        this.cg.println("public static " + this.className + " make(String tag)");
        this.cg.println("{");
        this.cg.println("  return (" + this.className + ")" + first.getName() + ".getRange().get(tag);");
        this.cg.println("}");
        this.cg.println();
        this.cg.println("/** Private constructor. */");
        this.cg.println("private " + this.className + "(int ordinal)");
        this.cg.println("{");
        this.cg.println("  super(ordinal);");
        this.cg.println("}");
        this.cg.println();
        this.cg.println("public static final " + this.className + " DEFAULT = " + defaultValue.orElse(rangeList.get(0).getName()) + ";");
    }
}

