/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.comment;

import com.tridium.slottool.Constants;
import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.model.Action;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.Facet;
import com.tridium.slottool.model.OrionIndex;
import com.tridium.slottool.model.OrionLinkedCursor;
import com.tridium.slottool.model.OrionProperty;
import com.tridium.slottool.model.OrionRefCursor;
import com.tridium.slottool.model.Property;
import com.tridium.slottool.model.Range;
import com.tridium.slottool.model.Slot;
import com.tridium.slottool.model.Topic;
import com.tridium.slottool.model.comment.parsers.baja.AstAction;
import com.tridium.slottool.model.comment.parsers.baja.AstActionBlock;
import com.tridium.slottool.model.comment.parsers.baja.AstAnnotation;
import com.tridium.slottool.model.comment.parsers.baja.AstBajaType;
import com.tridium.slottool.model.comment.parsers.baja.AstClass;
import com.tridium.slottool.model.comment.parsers.baja.AstEnum;
import com.tridium.slottool.model.comment.parsers.baja.AstEnumDefault;
import com.tridium.slottool.model.comment.parsers.baja.AstFacets;
import com.tridium.slottool.model.comment.parsers.baja.AstJavaExpression;
import com.tridium.slottool.model.comment.parsers.baja.AstJavaExpressionList;
import com.tridium.slottool.model.comment.parsers.baja.AstProperty;
import com.tridium.slottool.model.comment.parsers.baja.AstPropertyBlock;
import com.tridium.slottool.model.comment.parsers.baja.AstRange;
import com.tridium.slottool.model.comment.parsers.baja.AstRangeBlock;
import com.tridium.slottool.model.comment.parsers.baja.AstSingleton;
import com.tridium.slottool.model.comment.parsers.baja.AstSlotFacets;
import com.tridium.slottool.model.comment.parsers.baja.AstTopic;
import com.tridium.slottool.model.comment.parsers.baja.AstTopicBlock;
import com.tridium.slottool.model.comment.parsers.baja.AstUnit;
import com.tridium.slottool.model.comment.parsers.baja.BajaParser;
import com.tridium.slottool.model.comment.parsers.baja.SimpleNode;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class CommentClass
extends BajaUnit {
    private final String name;
    private final boolean isInterface;
    private final AstUnit astUnit;
    private final Optional<AstClass> astClass;
    private final Optional<AstEnum> astEnum;
    private final List<Property> properties = new LinkedList<Property>();
    private final List<Action> actions = new LinkedList<Action>();
    private final List<Topic> topics = new LinkedList<Topic>();
    private final List<OrionIndex> orionIndexes = new LinkedList<OrionIndex>();
    private final List<OrionRefCursor> orionRefCursors = new LinkedList<OrionRefCursor>();
    private final List<OrionLinkedCursor> orionLinkedCursors = new LinkedList<OrionLinkedCursor>();

    public CommentClass(String name, String code, boolean isInterface) {
        this.name = name;
        this.isInterface = isInterface;
        try {
            code = code.trim().substring(3, code.length() - 3);
            BajaParser parser = new BajaParser(new StringReader(code));
            this.astUnit = parser.Unit();
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not process " + name + ": " + e.getMessage(), e);
        }
        this.astClass = Optional.ofNullable((AstClass)this.astUnit.getFirstOfType(AstClass.class));
        this.astEnum = Optional.ofNullable((AstEnum)this.astUnit.getFirstOfType(AstEnum.class));
        if (!this.astClass.isPresent() && !this.astEnum.isPresent()) {
            throw new IllegalArgumentException("Invalid baja unit: must have either class or enum");
        }
        if (this.astClass.isPresent() && this.astEnum.isPresent()) {
            throw new IllegalArgumentException("Invalid baja unit: cannot have both class and enum");
        }
        this.astClass.map(AstClass::getPropertyBlock).ifPresent(this::makeProperties);
        this.astClass.map(AstClass::getActionBlock).ifPresent(this::makeActions);
        this.astClass.map(AstClass::getTopicBlock).ifPresent(this::makeTopics);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMode() {
        AstAnnotation[] anno = this.astUnit.getAnnotations("Mode");
        if (anno.length == 0) {
            return super.getMode();
        }
        return anno[0].getValue("value").toString();
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public List<Topic> getTopics() {
        return this.topics;
    }

    @Override
    public LinkedList<Range> getRange() {
        AstEnum enm = this.astEnum.orElseThrow(CommentClassExceptions.notAnEnum());
        LinkedList<Range> rangeList = new LinkedList<Range>();
        Optional.ofNullable((AstRangeBlock)enm.getFirstOfType(AstRangeBlock.class)).ifPresent(rb -> {
            for (int i = 0; i < rb.size(); ++i) {
                SimpleNode node = rb.get(i);
                if (!(node instanceof AstRange)) continue;
                AstRange range = (AstRange)node;
                Optional<String> ordinal = Optional.empty();
                if (range.size() == 2) {
                    ordinal = Optional.ofNullable(((AstJavaExpression)range.get(1)).getExpression());
                }
                String name = range.getName();
                rangeList.addLast(ordinal.map(ord -> new Range(name, (String)ord)).orElse(new Range(name)));
            }
        });
        return rangeList;
    }

    @Override
    public Optional<String> getEnumDefault() {
        return this.astEnum.map(enm -> (AstEnumDefault)enm.getFirstOfType(AstEnumDefault.class)).map(astEnumDefault -> astEnumDefault.get(0).toString());
    }

    @Override
    public boolean isSingleton() {
        return this.astClass.map(cls -> (AstSingleton)cls.getFirstOfType(AstSingleton.class)).isPresent();
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isEnum() {
        return this.astEnum.isPresent();
    }

    @Override
    public boolean isOrionType() {
        return "Orion".equals(this.getMode());
    }

    @Override
    public List<OrionIndex> getOrionIndexes() {
        return this.orionIndexes;
    }

    @Override
    public List<OrionRefCursor> getOrionRefCursors() {
        return this.orionRefCursors;
    }

    @Override
    public List<OrionLinkedCursor> getOrionLinkedCursors() {
        return this.orionLinkedCursors;
    }

    private void makeProperties(AstPropertyBlock props) {
        for (int i = 0; i < props.size(); ++i) {
            if (!(props.get(i) instanceof AstProperty)) continue;
            AstProperty astProperty = (AstProperty)props.get(i);
            Property newProperty = CommentClass.makeProperty(astProperty);
            BajaAnnotation propertyAnnotation = new BajaAnnotation(astProperty);
            List<AstAnnotation> refAnnotations = propertyAnnotation.getAnnotations("Ref");
            if (refAnnotations.isEmpty()) {
                this.properties.add(newProperty);
                continue;
            }
            if (refAnnotations.size() > 1) {
                throw new IllegalStateException("Property " + newProperty.getName() + " cannot have more than one @Ref annotation");
            }
            String refType = newProperty.getDefaultValue().map(def -> {
                if (def.contains("TYPE.getTypeSpec()") || !def.contains(":")) {
                    return null;
                }
                String brefMake = "BRef.make(\"";
                if (!def.startsWith(brefMake)) {
                    return null;
                }
                return def.substring(brefMake.length(), def.length() - 2);
            }).orElseThrow(() -> new IllegalStateException("Orion default value must be typespec, not BType.TYPE.getTypeSpec() or BType"));
            OrionProperty orionProperty = new OrionProperty(newProperty.getName(), refType);
            orionProperty.setFacets(Optional.of(newProperty.getFacets()));
            orionProperty.setFlags(newProperty.getFlags());
            orionProperty.setJavaDoc(newProperty.getJavaDoc());
            this.properties.add(orionProperty);
        }
        BajaAnnotation propertyBlockAnnotations = new BajaAnnotation(props);
        propertyBlockAnnotations.getAnnotations("Cursor").forEach(this::extractOrionCursors);
        propertyBlockAnnotations.getAnnotations("LinkedCursor").forEach(this::extractOrionLinkedCursors);
        propertyBlockAnnotations.getAnnotations("Index").forEach(this::extractOrionIndexes);
    }

    private static Property makeProperty(AstProperty property) {
        String name = property.getName();
        AstBajaType type = property.getType();
        String typeName = type.getName();
        Property newProperty = new Property(name);
        newProperty.setTypeName(typeName);
        newProperty.setFlags(Optional.ofNullable(property.getFlags()));
        newProperty.setDefaultValue(Optional.ofNullable(property.getDefault()));
        CommentClass.addFacets(newProperty, property);
        newProperty.setJavaDoc(Optional.ofNullable(property.getComment()));
        return newProperty;
    }

    private void makeActions(AstActionBlock actionBlock) {
        for (int i = 0; i < actionBlock.size(); ++i) {
            if (!(actionBlock.get(i) instanceof AstAction)) continue;
            this.actions.add(CommentClass.makeAction((AstAction)actionBlock.get(i)));
        }
    }

    private static Action makeAction(AstAction action) {
        String name = action.getName();
        Action newAction = new Action(name);
        newAction.setFlags(Optional.ofNullable(action.getFlags()));
        CommentClass.addFacets(newAction, action);
        newAction.setJavaDoc(Optional.ofNullable(action.getComment()));
        newAction.setDefaultValue(Optional.ofNullable(action.getDefault()));
        Optional.ofNullable(action.getFormalParameter()).ifPresent(fp -> {
            newAction.setParameterName(Optional.ofNullable(fp.getName()));
            newAction.setParameterType(Optional.ofNullable(fp.getType()).map(AstBajaType::getName));
        });
        newAction.setReturnType(Optional.ofNullable(action.getType()).map(AstBajaType::getName));
        return newAction;
    }

    private void makeTopics(AstTopicBlock topicBlock) {
        for (int i = 0; i < topicBlock.size(); ++i) {
            if (!(topicBlock.get(i) instanceof AstTopic)) continue;
            this.topics.add(CommentClass.makeTopic((AstTopic)topicBlock.get(i)));
        }
    }

    private static Topic makeTopic(AstTopic topic) {
        String name = topic.getName();
        Topic newTopic = new Topic(name);
        newTopic.setFlags(Optional.ofNullable(topic.getFlags()));
        newTopic.setJavaDoc(Optional.ofNullable(topic.getComment()));
        CommentClass.addFacets(newTopic, topic);
        newTopic.setReturnType(Optional.ofNullable(topic.getType()).map(AstBajaType::getName));
        return newTopic;
    }

    private void extractOrionCursors(AstAnnotation annotation) {
        String name = annotation.getValue("name").toString();
        String type = annotation.getValue("type").toString();
        String ref = annotation.getValue("ref").toString();
        OrionRefCursor orionRefCursor = new OrionRefCursor(name, type, ref);
        this.orionRefCursors.add(orionRefCursor);
    }

    private void extractOrionLinkedCursors(AstAnnotation annotation) {
        String name = annotation.getValue("name").toString();
        String type = annotation.getValue("type").toString();
        String link = annotation.getValue("link").toString();
        OrionLinkedCursor orionLinkedCursor = new OrionLinkedCursor(name, type, link);
        this.orionLinkedCursors.add(orionLinkedCursor);
    }

    private void extractOrionIndexes(AstAnnotation annotation) {
        String name = annotation.getValue("name").toString();
        boolean unique = Boolean.valueOf(annotation.getValue("unique").toString());
        String clustered = Optional.ofNullable(annotation.getValue("clustered")).map(Object::toString).map(s -> {
            if ("true".equals(s)) {
                return "BClustered.clustered";
            }
            if ("false".equals(s)) {
                return "BClustered.nonClustered";
            }
            return "BClustered.unspecified";
        }).orElse("BClustered.unspecified");
        OrionIndex orionIndex = new OrionIndex(name, unique, clustered);
        AstJavaExpressionList fields = (AstJavaExpressionList)annotation.getValue("fields");
        for (int i = 0; i < fields.size(); ++i) {
            orionIndex.addField(fields.get(i).toString());
        }
        this.orionIndexes.add(orionIndex);
    }

    private static void addFacets(Slot slot, SimpleNode node) {
        slot.setFacets(Optional.ofNullable((AstSlotFacets)node.getFirstOfType(AstSlotFacets.class)).map(CommentClass::extractFacets));
    }

    private static List<Facet> extractFacets(AstSlotFacets slotFacets) {
        LinkedList<Facet> facets = new LinkedList<Facet>();
        block4: for (int i = 0; i < slotFacets.size(); ++i) {
            SimpleNode child = slotFacets.get(i);
            if (!(child instanceof AstFacets)) continue;
            AstFacets astFacets = (AstFacets)child;
            switch (astFacets.size()) {
                case 1: {
                    facets.add(new Facet(null, CommentClass.trimFacetValue(astFacets.get(0).toString())));
                    continue block4;
                }
                case 2: {
                    facets.add(new Facet(CommentClass.makeFacetKey(astFacets.get(0).toString()), CommentClass.trimFacetValue(astFacets.get(1).toString())));
                }
            }
        }
        return facets;
    }

    private static String makeFacetKey(String key) {
        return CodeGenerator.isFacetKey(key) ? "BFacets." + key : key;
    }

    private static String trimFacetValue(String value) {
        return Arrays.stream(Constants.EOL.split(value)).map(String::trim).collect(Collectors.joining(" "));
    }

    private static final class CommentClassExceptions {
        private CommentClassExceptions() {
        }

        public static Supplier<RuntimeException> notAnEnum() {
            return new Supplier<RuntimeException>(){

                @Override
                public RuntimeException get() {
                    return new RuntimeException("Not an enum class");
                }
            };
        }
    }

    public static class BajaAnnotation {
        private final Map<String, List<AstAnnotation>> annotations = new HashMap<String, List<AstAnnotation>>();

        public BajaAnnotation(SimpleNode node) {
            for (int i = 0; i < node.size(); ++i) {
                if (!(node.get(i) instanceof AstAnnotation)) continue;
                AstAnnotation annotation = (AstAnnotation)node.get(i);
                this.annotations.computeIfAbsent(annotation.getName(), v -> new LinkedList()).add(annotation);
            }
        }

        public List<AstAnnotation> getAnnotations(String name) {
            return this.annotations.getOrDefault(name, Collections.emptyList());
        }
    }
}

