/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.model.annotation;

import com.tridium.slottool.model.Action;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.OrionIndex;
import com.tridium.slottool.model.OrionLinkedCursor;
import com.tridium.slottool.model.OrionRefCursor;
import com.tridium.slottool.model.Property;
import com.tridium.slottool.model.Range;
import com.tridium.slottool.model.Topic;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AnnotationClass
extends BajaUnit {
    private final List<Property> properties = new LinkedList<Property>();
    private final List<Action> actions = new LinkedList<Action>();
    private final List<Topic> topics = new LinkedList<Topic>();
    private LinkedList<Range> range = new LinkedList();
    private Optional<String> defaultEnumValue = Optional.empty();
    private final List<OrionIndex> orionIndexes = new LinkedList<OrionIndex>();
    private final List<OrionRefCursor> orionRefCursors = new LinkedList<OrionRefCursor>();
    private final List<OrionLinkedCursor> orionLinkedCursors = new LinkedList<OrionLinkedCursor>();
    private final String name;
    private final boolean isSingleton;
    private final boolean isEnum;
    private final boolean isInterface;
    private final boolean isOrionType;

    public AnnotationClass(String name, boolean isSingleton, boolean isEnum, boolean isInterface, boolean isOrionType) {
        this.name = name;
        this.isSingleton = isSingleton;
        this.isEnum = isEnum;
        this.isInterface = isInterface;
        this.isOrionType = isOrionType;
    }

    public AnnotationClass(String name) {
        this(name, false, false, false, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMode() {
        if (this.isOrionType()) {
            return "Orion";
        }
        return super.getMode();
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public List<Topic> getTopics() {
        return this.topics;
    }

    @Override
    public LinkedList<Range> getRange() {
        return this.range;
    }

    @Override
    public Optional<String> getEnumDefault() {
        return this.defaultEnumValue;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public boolean isEnum() {
        return this.isEnum;
    }

    @Override
    public boolean isOrionType() {
        return this.isOrionType;
    }

    @Override
    public List<OrionIndex> getOrionIndexes() {
        return this.orionIndexes;
    }

    @Override
    public List<OrionRefCursor> getOrionRefCursors() {
        return this.orionRefCursors;
    }

    @Override
    public List<OrionLinkedCursor> getOrionLinkedCursors() {
        return this.orionLinkedCursors;
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void addTopic(Topic topic) {
        this.topics.add(topic);
    }

    public void setRange(LinkedList<Range> range) {
        this.range = range;
    }

    public void setDefaultEnumValue(Optional<String> defaultEnumValue) {
        this.defaultEnumValue = defaultEnumValue;
    }

    public void addOrionIndex(OrionIndex orionIndex) {
        this.orionIndexes.add(orionIndex);
    }

    public void addOrionRefCursor(OrionRefCursor orionRefCursor) {
        this.orionRefCursors.add(orionRefCursor);
    }

    public void addOrionLinkedCursor(OrionLinkedCursor orionLinkedCursor) {
        this.orionLinkedCursors.add(orionLinkedCursor);
    }
}

