/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.mode;

import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.generator.GeneratedCodeBlock;
import com.tridium.slottool.mode.SlotMode;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.OrionIndex;
import com.tridium.slottool.model.OrionLinkedCursor;
import com.tridium.slottool.model.OrionProperty;
import com.tridium.slottool.model.OrionRefCursor;
import com.tridium.slottool.model.Property;
import com.tridium.slottool.model.annotation.AnnotationProcessor;
import com.tridium.slottool.processor.SlotProcessor;
import java.util.List;
import java.util.stream.Collectors;

public class Orion
extends SlotMode {
    public Orion(GeneratedCodeBlock cg, BajaUnit bajaUnit) {
        super(cg, bajaUnit);
        this.propertyProcessors.addLast(new OrionPropertyProcessor(cg));
    }

    @Override
    public String getType() {
        return "getTypeFromSpace(TYPE)";
    }

    @Override
    public void typeDeclaration() {
        super.typeDeclaration();
        this.cg.println("public static final OrionType ORION_TYPE = (OrionType)TYPE;");
    }

    @Override
    public void propertyBlock() {
        super.propertyBlock();
        List<OrionRefCursor> orionRefCursors = this.bajaUnit.getOrionRefCursors();
        List<OrionLinkedCursor> orionLinkedCursors = this.bajaUnit.getOrionLinkedCursors();
        List<OrionIndex> orionIndexes = this.bajaUnit.getOrionIndexes();
        if (!orionRefCursors.isEmpty()) {
            this.cg.startRegion("Cursors");
            this.cg.println();
            orionRefCursors.forEach(this::cursor);
            this.cg.endRegion();
        }
        if (!orionLinkedCursors.isEmpty()) {
            this.cg.startRegion("Linked Cursors");
            this.cg.println();
            orionLinkedCursors.forEach(this::linkedCursor);
            this.cg.endRegion();
        }
        if (!orionIndexes.isEmpty()) {
            this.cg.startRegion("Indexes");
            this.cg.println();
            this.cg.println("public Index[] getIndexes() { return INDEXES; }");
            this.cg.println("private static final Index[] INDEXES = new Index[]");
            this.cg.println("{");
            orionIndexes.forEach(this::index);
            this.cg.println("};");
            this.cg.endRegion();
        }
    }

    private void index(OrionIndex orionIndex) {
        String name = orionIndex.getName();
        String unique = String.valueOf(orionIndex.isUnique());
        String clustered = orionIndex.getClustered();
        List<String> fields = orionIndex.getFields();
        String fieldsList = fields.stream().collect(Collectors.joining(", "));
        this.cg.println("  new Index(\"" + name + '\"' + ", " + unique + ", " + clustered + ", new Property[] { " + fieldsList + " }, new boolean[" + fields.size() + "]),");
    }

    private void cursor(OrionRefCursor cursor) {
        String name = cursor.getName();
        String type = cursor.getType();
        String ref = cursor.getRef();
        this.cg.println("/**");
        this.cg.println(" * Get all objects of type '" + type + "' that are associated with this object.");
        this.cg.println(" */");
        this.cg.println("public " + name + "Cursor get" + name + "(OrionSession session)");
        this.cg.println("{");
        this.cg.println("  return new " + name + "Cursor(");
        this.cg.println("    session.select(");
        this.cg.println("      " + type + ".ORION_TYPE,");
        this.cg.println("      new PropertyValue(");
        this.cg.println("        " + type + "." + ref + ",");
        this.cg.println("        BRef.make(this))));");
        this.cg.println("}");
        this.cg.println();
        this.cursorClass(name, type);
    }

    private void linkedCursor(OrionLinkedCursor linkedCursor) {
        String name = linkedCursor.getName();
        String type = linkedCursor.getType();
        String link = linkedCursor.getLink();
        this.cg.println("/**");
        this.cg.println(" * Get all objects of type '" + type + "' that are associated with this object.");
        this.cg.println(" */");
        this.cg.println("public " + name + "Cursor get" + name + "(OrionSession session)");
        this.cg.println("{");
        this.cg.println("  return new " + name + "Cursor(");
        this.cg.println("    session.linkedScan(");
        this.cg.println("      this,");
        this.cg.println("      " + link + ".ORION_TYPE,");
        this.cg.println("      " + type + ".ORION_TYPE));");
        this.cg.println("}");
        this.cg.println();
        this.cursorClass(name, type);
    }

    private void cursorClass(String name, String type) {
        this.cg.println("public static class " + name + "Cursor implements OrionCursor");
        this.cg.println("{");
        this.cg.println("  private " + name + "Cursor(OrionCursor cursor) { this.cursor = cursor; }");
        this.cg.println("  private final OrionCursor cursor;");
        this.cg.println();
        this.cg.println("  public Context getContext()         { return cursor.getContext();    }");
        this.cg.println("  public OrionType getOrionType()     { return cursor.getOrionType();  }");
        this.cg.println("  public BIOrionObject[] toArray()    { return cursor.toArray();       }");
        this.cg.println("  public boolean next()               { return cursor.next();          }");
        this.cg.println("  public boolean nextComponent()      { return cursor.nextComponent(); }");
        this.cg.println("  public boolean next(Class<?> cls)   { return cursor.next(cls);       }");
        this.cg.println("  public BObject get()                { return cursor.get();           }");
        this.cg.println("  public OrionSession getSession()    { return cursor.getSession();    }");
        this.cg.println("  public void close()                 { cursor.close();                }");
        this.cg.println();
        this.cg.println("  public " + type + " get" + type.substring(1) + "() { return (" + type + ") cursor.get(); }");
        this.cg.println("}");
    }

    private static class OrionPropertyProcessor
    extends SlotProcessor<Property> {
        public OrionPropertyProcessor(GeneratedCodeBlock cg) {
            super(cg);
        }

        @Override
        public void accept(Property property) {
            if (property instanceof OrionProperty) {
                OrionProperty orionProperty = (OrionProperty)property;
                String name = property.getName();
                String getter = "get" + CodeGenerator.getMethodizedName(name);
                String resolver = "resolve" + CodeGenerator.getMethodizedName(name);
                String refType = AnnotationProcessor.makeType(orionProperty.getRefType());
                this.cg.println();
                this.cg.println("/**");
                this.cg.println(" * Resolve the {@code " + name + "} property.");
                this.cg.println(" * @see #" + name);
                this.cg.println(" */");
                this.cg.println("public " + refType + " " + resolver + "(OrionSession session)");
                this.cg.println("{");
                this.cg.println("  return (" + refType + ")" + getter + "().getTarget(session);");
                this.cg.println("}");
            }
        }
    }
}

