/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.github.javaparser.ast.ImportDeclaration;
import com.tridium.slottool.generator.BaseGeneratedCodeBlock;
import com.tridium.slottool.generator.ImportType;
import com.tridium.slottool.generator.JavaImport;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class SortedImportCodeBlock
extends BaseGeneratedCodeBlock {
    private final EnumMap<ImportType, TreeSet<JavaImport>> imports = new EnumMap(ImportType.class);
    private String prefix = null;
    private String suffix = null;
    private List<String> generatedLines = null;

    public SortedImportCodeBlock(String lineSeparator) {
        super(lineSeparator);
    }

    private List<String> generate() {
        LinkedList<String> lines = new LinkedList<String>();
        if (this.prefix != null) {
            lines.add(this.prefix);
        }
        Iterator<Map.Entry<ImportType, TreeSet<JavaImport>>> iterator = this.imports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ImportType, TreeSet<JavaImport>> entry = iterator.next();
            for (JavaImport javaImport : entry.getValue()) {
                lines.add(javaImport.asStatement());
            }
            if (!iterator.hasNext()) continue;
            lines.add("");
        }
        if (this.suffix != null) {
            lines.add(this.suffix);
        }
        return lines;
    }

    @Override
    public List<String> getLines() {
        if (this.generatedLines == null) {
            this.generatedLines = this.generate();
        }
        return Collections.unmodifiableList(this.generatedLines);
    }

    public void addImport(ImportDeclaration importDeclaration) {
        this.addImport(new JavaImport(importDeclaration));
    }

    public void addImport(String importName) {
        this.addImport(importName, false, false);
    }

    public void addStaticImport(String importName) {
        this.addImport(importName, true, false);
    }

    public void addImport(String importName, boolean isStatic, boolean isOnDemand) {
        this.addImport(new JavaImport(importName, isStatic, isOnDemand));
    }

    public void deleteImport(String importName) {
        this.deleteImport(importName, false, false);
    }

    public void deleteImport(String importName, boolean isStatic, boolean isOnDemand) {
        this.deleteImport(new JavaImport(importName, isStatic, isOnDemand));
    }

    protected void addImport(JavaImport javaImport) {
        JavaImport onDemandImport;
        if (this.generatedLines != null) {
            throw new IllegalStateException("no longer mutable");
        }
        ImportType type = ImportType.forImport(javaImport);
        TreeSet javaImports = this.imports.computeIfAbsent(type, k -> new TreeSet());
        if (!javaImports.contains(onDemandImport = new JavaImport(javaImport.getPackageName(), javaImport.isStatic(), true))) {
            javaImports.add(javaImport);
        }
    }

    protected void deleteImport(JavaImport javaImport) {
        if (this.generatedLines != null) {
            throw new IllegalStateException("no longer mutable");
        }
        ImportType type = ImportType.forImport(javaImport);
        TreeSet javaImports = this.imports.computeIfAbsent(type, k -> new TreeSet());
        javaImports.remove(javaImport);
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

