/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.tridium.slottool.generator.JavaImport;

public enum ImportType {
    STATIC_OTHER,
    STATIC_JAVAX_BAJA,
    STATIC_COM_TRIDIUM,
    STATIC_TEST_JAVAX_BAJA,
    STATIC_TEST_COM_TRIDIUM,
    JAVA_JAVAX,
    JAVAX_BAJA,
    OTHER,
    COM_TRIDIUM,
    TEST_JAVAX_BAJA,
    TEST_COM_TRIDIUM;


    public static ImportType forImport(JavaImport javaImport) {
        return ImportType.forImport(javaImport.getName(), javaImport.isStatic());
    }

    public static ImportType forImport(String importName, boolean isStatic) {
        if (importName.startsWith("test.")) {
            if (importName.startsWith("test.javax.")) {
                return isStatic ? STATIC_TEST_JAVAX_BAJA : TEST_JAVAX_BAJA;
            }
            if (importName.startsWith("test.com.tridium.")) {
                return isStatic ? STATIC_TEST_COM_TRIDIUM : TEST_COM_TRIDIUM;
            }
        }
        if (importName.startsWith("javax.baja.")) {
            return isStatic ? STATIC_JAVAX_BAJA : JAVAX_BAJA;
        }
        if (importName.startsWith("com.tridium.")) {
            return isStatic ? STATIC_COM_TRIDIUM : COM_TRIDIUM;
        }
        if (importName.startsWith("java.") || importName.startsWith("javax.")) {
            return isStatic ? STATIC_OTHER : JAVA_JAVAX;
        }
        return isStatic ? STATIC_OTHER : OTHER;
    }
}

