/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.tridium.slottool.Constants;
import com.tridium.slottool.generator.BaseGeneratedCodeBlock;
import com.tridium.slottool.generator.CodeGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class GeneratedCodeBlock
extends BaseGeneratedCodeBlock {
    private final StringBuffer sb = new StringBuffer();
    private String indentLevel = "";
    private String region = null;
    private final Set<String> imports = new HashSet<String>();

    public GeneratedCodeBlock(String lineSeparator) {
        super(lineSeparator);
    }

    @Override
    public List<String> getLines() {
        return Constants.EOL.splitAsStream(this.sb.toString()).map(CodeGenerator::trimRight).collect(Collectors.toList());
    }

    @Override
    public int getLength() {
        return this.sb.length();
    }

    public Set<String> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public void printJavadocComment(String comment) {
        this.printComment(" * ", comment);
    }

    public void printComment(String comment) {
        this.printComment(" ", comment);
    }

    private void printComment(String prefix, String comment) {
        int start;
        if (comment == null) {
            return;
        }
        String[] lines = Constants.EOL.split(comment);
        if (lines[start = 0].isEmpty()) {
            start = 1;
        }
        for (int x = start; x < lines.length; ++x) {
            this.println(CodeGenerator.trimRight(prefix + lines[x]));
        }
    }

    public void startRegion(String comment) {
        if (this.region != null) {
            throw new IllegalStateException("Cannot start a new region without ending the previous one (" + this.region + ")");
        }
        this.region = comment;
        this.println();
        this.printComment("//region ", this.region);
    }

    public void endRegion() {
        if (this.region == null) {
            throw new IllegalStateException("Cannot end a region without starting one");
        }
        this.println();
        this.printComment("//endregion ", this.region);
        this.region = null;
    }

    public void println() {
        this.sb.append(this.lineSeparator);
    }

    public void println(String s) {
        this.print(s + this.lineSeparator);
    }

    public void print(String s) {
        this.sb.append(this.indentLevel + s);
    }

    public void indent() {
        this.indentLevel = this.indentLevel + "  ";
    }

    public void outdent() {
        this.indentLevel = this.indentLevel.substring(0, this.indentLevel.length() - 2);
    }

    public void deleteLast() {
        this.sb.deleteCharAt(this.sb.length() - this.lineSeparator.length() - 1);
    }

    public void delete(int start, int end) {
        this.sb.delete(start, end);
    }

    public void trim() {
        String trimmed = this.sb.toString().trim();
        this.sb.delete(0, this.sb.length());
        this.sb.append(trimmed);
    }

    public void prepend(String s) {
        this.sb.insert(0, s);
    }

    public void append(String s) {
        this.sb.append(s);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void addImport(String importName) {
        this.imports.add(importName);
    }

    public void printImport(String importName) {
        this.println("import " + importName + ";");
    }
}

