/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.tridium.slottool.generator.CodeBlock;
import com.tridium.slottool.generator.LineRange;
import java.util.List;

public class ExistingCodeBlock
implements CodeBlock {
    private final LineRange range;
    private final List<String> sourceLines;
    private final String lineSeparator;

    public ExistingCodeBlock(LineRange range, List<String> sourceLines, String lineSeparator) {
        if (range.getEndIndex() >= sourceLines.size()) {
            throw new IllegalArgumentException("Provided position runs past the end of the source");
        }
        this.range = range;
        this.lineSeparator = lineSeparator;
        this.sourceLines = sourceLines.subList(range.getStartIndex(), range.getEndIndex() + 1);
    }

    @Override
    public String getBlock() {
        return String.join((CharSequence)this.lineSeparator, this.getLines());
    }

    @Override
    public LineRange getRange() {
        return this.range;
    }

    @Override
    public List<String> getLines() {
        return this.sourceLines;
    }
}

