/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool.generator;

import com.github.javaparser.utils.StringEscapeUtils;
import com.tridium.slottool.SlotomaticOptions;
import com.tridium.slottool.generator.CodeGenerator;
import com.tridium.slottool.model.Action;
import com.tridium.slottool.model.AgentOn;
import com.tridium.slottool.model.BajaUnit;
import com.tridium.slottool.model.Facet;
import com.tridium.slottool.model.NiagaraType;
import com.tridium.slottool.model.OrionIndex;
import com.tridium.slottool.model.OrionLinkedCursor;
import com.tridium.slottool.model.OrionProperty;
import com.tridium.slottool.model.OrionRefCursor;
import com.tridium.slottool.model.Property;
import com.tridium.slottool.model.Range;
import com.tridium.slottool.model.Slot;
import com.tridium.slottool.model.Topic;
import java.util.List;
import java.util.stream.Collectors;

public class AnnotationGenerator
extends CodeGenerator {
    public AnnotationGenerator(SlotomaticOptions slotomaticOptions, BajaUnit unit) {
        super(slotomaticOptions, unit);
    }

    @Override
    protected void generate() {
        NiagaraType niagaraType = this.unit.getNiagaraType();
        this.cb.addImport("javax.baja.nre.annotations.NiagaraType");
        niagaraType.getJavaDoc().ifPresent(doc -> this.cb.println((String)doc));
        if (niagaraType.equals(NiagaraType.EMPTY)) {
            this.cb.println("@NiagaraType");
        } else {
            this.cb.println("@NiagaraType(");
            this.cb.indent();
            List<AgentOn> agentOns = niagaraType.getAgentOn();
            if (!agentOns.isEmpty()) {
                if (agentOns.size() == 1) {
                    this.cb.print("agent = ");
                    this.printAgentOn(agentOns.get(0), false);
                } else {
                    this.cb.println("agent = {");
                    this.cb.indent();
                    agentOns.forEach(this::printAgentOn);
                    this.cb.deleteLast();
                    this.cb.outdent();
                    this.cb.println("},");
                }
            }
            niagaraType.getAdapter().ifPresent(adapter -> {
                this.cb.addImport("javax.baja.nre.annotations.Adapter");
                this.cb.println("adapter = @Adapter(from = \"" + adapter.getFrom() + "\", to = \"" + adapter.getTo() + "\"),");
            });
            niagaraType.getOrdScheme().ifPresent(ordScheme -> this.cb.println("ordScheme = \"" + ordScheme + "\","));
            List<String> fileExts = niagaraType.getFileExt();
            if (!fileExts.isEmpty()) {
                this.cb.addImport("javax.baja.nre.annotations.FileExt");
                if (fileExts.size() == 1) {
                    this.cb.println("ext = @FileExt(name = \"" + fileExts.get(0) + "\"),");
                } else {
                    this.cb.println("ext = {");
                    this.cb.indent();
                    fileExts.forEach(fileExt -> this.cb.println("@FileExt(name = \"" + fileExt + "\"),"));
                    this.cb.deleteLast();
                    this.cb.outdent();
                    this.cb.println("},");
                }
            }
            this.cb.deleteLast();
            this.cb.outdent();
            this.cb.println(")");
        }
        if (this.unit.isEnum()) {
            this.printEnum(this.unit);
        } else if (this.unit.isSingleton()) {
            this.cb.addImport("javax.baja.nre.annotations.NiagaraSingleton");
            this.cb.println("@NiagaraSingleton");
        } else {
            if (this.unit.isOrionType()) {
                this.printOrion(this.unit);
            }
            this.printProperties(this.unit);
            this.printActions(this.unit);
            this.printTopics(this.unit);
        }
    }

    private void printEnum(BajaUnit unit) {
        this.cb.addImport("javax.baja.nre.annotations.NiagaraEnum");
        this.cb.addImport("javax.baja.nre.annotations.Range");
        this.cb.println("@NiagaraEnum(");
        this.cb.indent();
        this.cb.println("range = {");
        this.cb.indent();
        for (Range range : unit.getRange()) {
            this.cb.println("@Range(" + range.getOrdinal().map(ordinal -> "value = \"" + range.getName() + "\", ordinal = " + ordinal).orElse("\"" + range.getName() + "\"") + "),");
        }
        this.cb.deleteLast();
        this.cb.outdent();
        this.cb.println("},");
        unit.getEnumDefault().ifPresent(defaultValue -> this.cb.println("defaultValue = \"" + defaultValue + "\","));
        this.cb.deleteLast();
        this.cb.outdent();
        this.cb.println(")");
    }

    private void printOrion(BajaUnit unit) {
        List<OrionIndex> orionIndexes;
        List<OrionLinkedCursor> orionLinkedCursors;
        this.cb.addImport("com.tridium.orion.annotations.NiagaraOrionType");
        this.cb.println("@NiagaraOrionType");
        List<OrionRefCursor> orionRefCursors = unit.getOrionRefCursors();
        if (!orionRefCursors.isEmpty()) {
            this.cb.addImport("com.tridium.orion.annotations.OrionRefCursor");
            orionRefCursors.forEach(orionCursor -> {
                this.cb.println("@OrionRefCursor(");
                this.cb.indent();
                this.cb.println("name = \"" + orionCursor.getName() + "\",");
                this.cb.println("type = \"" + orionCursor.getType() + "\",");
                this.cb.println("ref = \"" + orionCursor.getRef() + "\"");
                this.cb.outdent();
                this.cb.println(")");
            });
        }
        if (!(orionLinkedCursors = unit.getOrionLinkedCursors()).isEmpty()) {
            this.cb.addImport("com.tridium.orion.annotations.OrionLinkedCursor");
            orionLinkedCursors.forEach(orionLinkedCursor -> {
                this.cb.println("@OrionLinkedCursor(");
                this.cb.indent();
                this.cb.println("name = \"" + orionLinkedCursor.getName() + "\",");
                this.cb.println("type = \"" + orionLinkedCursor.getType() + "\",");
                this.cb.println("link = \"" + orionLinkedCursor.getLink() + "\"");
                this.cb.outdent();
                this.cb.println(")");
            });
        }
        if (!(orionIndexes = unit.getOrionIndexes()).isEmpty()) {
            this.cb.addImport("com.tridium.orion.annotations.OrionIndex");
            orionIndexes.forEach(orionIndex -> {
                this.cb.println("@OrionIndex(");
                this.cb.indent();
                this.cb.println("name = \"" + orionIndex.getName() + "\",");
                this.cb.println("unique = " + orionIndex.isUnique() + ",");
                this.cb.println("clustered = \"" + orionIndex.getClustered() + "\",");
                List<String> fields = orionIndex.getFields();
                if (!fields.isEmpty()) {
                    if (fields.size() > 1) {
                        String fieldString = fields.stream().collect(Collectors.joining("\", \"", "\"", "\""));
                        this.cb.println("fields = { " + fieldString + " },");
                    } else {
                        this.cb.println("fields = \"" + fields.get(0) + "\",");
                    }
                }
                this.cb.deleteLast();
                this.cb.outdent();
                this.cb.println(")");
            });
        }
    }

    private void printProperties(BajaUnit unit) {
        List<Property> properties = unit.getProperties();
        if (!properties.isEmpty()) {
            for (Property prop : properties) {
                this.printDocs(prop);
                if (prop instanceof OrionProperty) {
                    this.cb.addImport("com.tridium.orion.annotations.OrionProperty");
                    OrionProperty orionProperty = (OrionProperty)prop;
                    this.cb.println("@OrionProperty(");
                    this.cb.indent();
                    this.cb.println("name = \"" + orionProperty.getName() + "\",");
                    this.cb.println("refType = \"" + orionProperty.getRefType() + "\",");
                } else {
                    this.cb.addImport("javax.baja.nre.annotations.NiagaraProperty");
                    this.cb.println("@NiagaraProperty(");
                    this.cb.indent();
                    this.cb.println("name = \"" + prop.getName() + "\",");
                    this.cb.println("type = \"" + prop.getTypeName() + "\",");
                    prop.getDefaultValue().ifPresent(defaultValue -> this.printDefaultValue((String)defaultValue, prop.getTypeName()));
                }
                this.printFlags(prop);
                this.printFacets(prop.getFacets());
                if (prop.isOverride()) {
                    this.cb.println("override = true,");
                }
                if (prop.isDeprecated()) {
                    this.cb.println("deprecated = true,");
                }
                this.cb.deleteLast();
                this.cb.outdent();
                this.cb.println(")");
            }
        }
    }

    private void printActions(BajaUnit unit) {
        List<Action> actions = unit.getActions();
        if (!actions.isEmpty()) {
            this.cb.addImport("javax.baja.nre.annotations.NiagaraAction");
            for (Action action : actions) {
                this.printDocs(action);
                this.cb.println("@NiagaraAction(");
                this.cb.indent();
                this.cb.println("name = \"" + action.getName() + "\",");
                action.getParameterType().ifPresent(parameterType -> {
                    this.cb.println("parameterType = \"" + parameterType + "\",");
                    this.printDefaultValue(action.getDefaultValue().orElseThrow(IllegalStateException::new), (String)parameterType);
                });
                action.getReturnType().ifPresent(returnType -> this.cb.println("returnType = \"" + returnType + "\","));
                this.printFlags(action);
                this.printFacets(action.getFacets());
                if (action.isOverride()) {
                    this.cb.println("override = true,");
                }
                if (action.isDeprecated()) {
                    this.cb.println("deprecated = true,");
                }
                this.cb.deleteLast();
                this.cb.outdent();
                this.cb.println(")");
            }
        }
    }

    private void printTopics(BajaUnit unit) {
        List<Topic> topics = unit.getTopics();
        if (!topics.isEmpty()) {
            this.cb.addImport("javax.baja.nre.annotations.NiagaraTopic");
            for (Topic topic : unit.getTopics()) {
                this.printDocs(topic);
                this.cb.println("@NiagaraTopic(");
                this.cb.indent();
                this.cb.println("name = \"" + topic.getName() + "\",");
                topic.getReturnType().ifPresent(returnType -> this.cb.println("eventType = \"" + returnType + "\","));
                this.printFlags(topic);
                this.printFacets(topic.getFacets());
                if (topic.isOverride()) {
                    this.cb.println("override = true,");
                }
                if (topic.isDeprecated()) {
                    this.cb.println("deprecated = true,");
                }
                this.cb.deleteLast();
                this.cb.outdent();
                this.cb.println(")");
            }
        }
    }

    private void printDocs(Slot slot) {
        slot.getJavaDoc().ifPresent(doc -> {
            this.cb.println("/*");
            this.cb.printComment((String)doc);
            this.cb.println(" */");
        });
    }

    private void printDefaultValue(String defaultValue, String type) {
        String printString = AnnotationGenerator.getDefaultValue(defaultValue, type);
        this.cb.println("defaultValue = " + printString + ",");
    }

    private static String getDefaultValue(String defaultValue, String type) {
        if ("null".equals(defaultValue)) {
            return defaultValue;
        }
        if ("BString".equals(type) && !defaultValue.contains("BString")) {
            return defaultValue;
        }
        if ("String".equals(type) && defaultValue.startsWith("\"")) {
            return defaultValue;
        }
        return AnnotationGenerator.escapeString(defaultValue);
    }

    private void printFlags(Slot slot) {
        slot.getFlags().ifPresent(flags -> {
            if (!"0".equals(flags)) {
                this.cb.println("flags = " + flags + ",");
            }
        });
    }

    private void printFacets(List<Facet> facets) {
        if (!facets.isEmpty()) {
            this.cb.addImport("javax.baja.nre.annotations.Facet");
            if (facets.size() > 1) {
                this.cb.println("facets = {");
                this.cb.indent();
                facets.stream().map(AnnotationGenerator::makeFacetString).forEach(this.cb::println);
                this.cb.deleteLast();
                this.cb.outdent();
                this.cb.println("},");
            } else {
                Facet facet = facets.get(0);
                this.cb.println("facets = " + AnnotationGenerator.makeFacetString(facet));
            }
        }
    }

    private void printAgentOn(AgentOn agentOn) {
        this.printAgentOn(agentOn, true);
    }

    private void printAgentOn(AgentOn agentOn, boolean indent) {
        this.cb.addImport("javax.baja.nre.annotations.AgentOn");
        if (indent) {
            this.cb.println("@AgentOn(");
        } else {
            this.cb.append("@AgentOn(");
            this.cb.println();
        }
        this.cb.indent();
        List<String> types = agentOn.getTypes();
        if (!types.isEmpty()) {
            if (types.size() > 1) {
                String typeString = types.stream().collect(Collectors.joining("\", \"", "{ \"", "\" }"));
                if (typeString.length() + 12 > 120) {
                    this.cb.println("types = {");
                    this.cb.indent();
                    for (String type : types) {
                        this.cb.println("\"" + type + "\",");
                    }
                    this.cb.deleteLast();
                    this.cb.outdent();
                    this.cb.println("},");
                } else {
                    this.cb.println("types = " + typeString + ",");
                }
            } else {
                this.cb.println("types = \"" + types.get(0) + "\",");
            }
        }
        agentOn.getApp().ifPresent(app -> this.cb.println("app = \"" + app + "\","));
        agentOn.getRequiredPermissions().ifPresent(perms -> this.cb.println("requiredPermissions = \"" + perms + "\","));
        agentOn.getPreferredDefault().ifPresent(preferredDefault -> {
            this.cb.addImport("javax.baja.nre.annotations.AgentOn.Preference");
            if ("true".equals(preferredDefault)) {
                this.cb.println("defaultAgent = Preference.PREFERRED,");
            } else if ("false".equals(preferredDefault)) {
                this.cb.println("defaultAgent = Preference.NOT_PREFERRED,");
            }
        });
        this.cb.deleteLast();
        this.cb.outdent();
        this.cb.println("),");
    }

    private static String makeFacetString(Facet facet) {
        String value = AnnotationGenerator.escapeString(facet.getValue());
        return "@Facet(" + facet.getName().map(name -> "name = " + AnnotationGenerator.escapeString(name) + ", value = " + value).orElse(value) + "),";
    }

    private static String escapeString(String source) {
        return '\"' + StringEscapeUtils.escapeJava(source) + '\"';
    }
}

