/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.slottool;

import com.tridium.slottool.JavaUnit;

public class BajaMetadata {
    private long checksum;
    private String packageName;
    private String className;
    private String version = "1.0";

    private BajaMetadata() {
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getVersion() {
        return this.version;
    }

    public static BajaMetadata fromExisting(String source) {
        BajaMetadata metadata = new BajaMetadata();
        int a = source.indexOf(36);
        int b = source.indexOf(40);
        if (a == -1 || b == -1) {
            throw new IllegalArgumentException("Cannot find generated package name in " + source);
        }
        String fullyQualifiedName = source.substring(a + 1, b);
        int dotIndex = fullyQualifiedName.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new IllegalArgumentException("Cannot find package/class name in " + source);
        }
        metadata.packageName = fullyQualifiedName.substring(0, dotIndex);
        metadata.className = fullyQualifiedName.substring(dotIndex + 1);
        int c = source.indexOf(41);
        if (c == -1) {
            throw new IllegalArgumentException("Cannot find generated checksum in " + source);
        }
        metadata.checksum = Long.parseLong(source.substring(b + 1, c));
        int d = source.indexOf(36, c);
        if (d == -1) {
            throw new IllegalArgumentException("Cannot find generated version in " + source);
        }
        metadata.version = source.substring(c + 1, d);
        return metadata;
    }

    public static BajaMetadata fromJavaUnit(JavaUnit unit) {
        BajaMetadata metadata = new BajaMetadata();
        metadata.checksum = unit.getBajaChecksum();
        metadata.packageName = unit.getPackageName();
        metadata.className = unit.getName();
        return metadata;
    }

    public String asHeader() {
        return String.format("/*@ $%s.%s(%d)%s$ @*/", this.packageName, this.className, this.checksum, this.version);
    }
}

