/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.GradleProjectGenerator;
import com.tridium.gradle.plugins.templates.ModuleDependency;
import com.tridium.gradle.plugins.templates.ModuleRuntimeProfile;
import com.tridium.gradle.plugins.templates.NDriverModuleGenerator;
import com.tridium.gradle.plugins.templates.NiagaraModuleDependencies;
import com.tridium.gradle.plugins.templates.NiagaraModulePartGenerator;
import com.tridium.gradle.plugins.templates.util.NiagaraTypeInfo;
import com.tridium.gradle.plugins.templates.util.VideoCameraInfo;
import com.tridium.slottool.Slotomatic;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;

public class VideoDriverModuleGenerator
extends NDriverModuleGenerator {
    protected NiagaraTypeInfo dvr = new NiagaraTypeInfo();
    protected VideoCameraInfo camera = new VideoCameraInfo();
    protected boolean dvrSupport = false;
    protected boolean dvrDiscovery = false;
    protected boolean dvrDisplay = false;
    private static final List<String> DEFAULT_RT_DEPENDENCIES = Arrays.asList("gx-rt", "net-rt", "nvideo-rt", "videoDriver-rt");
    private static final List<String> DEFAULT_WB_DEPENDENCIES = Arrays.asList("ffmpeg-wb", "nvideo-wb", "videoDriver-wb");

    protected VideoDriverModuleGenerator(GradleProjectGenerator projectGenerator, String modulePath, String moduleName) {
        super(projectGenerator, modulePath, moduleName);
        this.addWbPart();
        NiagaraModuleDependencies rtDependencies = this.getModulePart(ModuleRuntimeProfile.rt).getDependencies();
        NiagaraModuleDependencies wbDependencies = this.getModulePart(ModuleRuntimeProfile.wb).getDependencies();
        for (String dependency : DEFAULT_RT_DEPENDENCIES) {
            rtDependencies.addDependency(new ModuleDependency("", dependency));
            wbDependencies.addDependency(new ModuleDependency("", dependency));
        }
        for (String dependency : DEFAULT_WB_DEPENDENCIES) {
            wbDependencies.addDependency(new ModuleDependency("", dependency));
        }
        this.context.put("dvr", (Object)this.dvr);
        this.context.put("camera", (Object)this.camera);
        this.doSetClassPrefix(this.basePrefix);
    }

    public static VideoDriverModuleGenerator make(GradleProjectGenerator projectGenerator, String moduleName) {
        return VideoDriverModuleGenerator.make(projectGenerator, moduleName, "");
    }

    public static VideoDriverModuleGenerator make(GradleProjectGenerator projectGenerator, String moduleName, String moduleRoot) {
        StringJoiner joiner = new StringJoiner("/");
        if (moduleRoot != null && !moduleRoot.isEmpty()) {
            joiner.add(moduleRoot);
        }
        joiner.add(moduleName);
        String modulePath = joiner.toString();
        return new VideoDriverModuleGenerator(projectGenerator, modulePath, moduleName);
    }

    @Override
    public void setClassPrefix(String classPrefix) {
        super.setClassPrefix(classPrefix);
        this.doSetClassPrefix(classPrefix);
    }

    private void doSetClassPrefix(String classPrefix) {
        this.dvr.setType(classPrefix + "Dvr");
    }

    @Override
    public void generate() {
        NiagaraModulePartGenerator rt = this.getModulePart(ModuleRuntimeProfile.rt);
        rt.addTemplateWrite("gradle/videodriver/module.palette.vm", "module.palette");
        String srcMain = "src";
        String packagePath = this.basePackage.replace('.', '/');
        String srcPathPrefix = srcMain + "/" + packagePath + "/";
        rt.addTemplateWrite("gradle/videodriver/BNfooNetwork.java.vm", srcPathPrefix + this.network.getCls() + ".java");
        if (this.dvrSupport) {
            String dvrPackagePathPrefix = srcPathPrefix + "dvr/";
            rt.addTemplateWrite("gradle/videodriver/BNfooDvr.java.vm", dvrPackagePathPrefix + this.dvr.getCls() + ".java");
            rt.addTemplateWrite("gradle/videodriver/BNfooDvrFolder.java.vm", dvrPackagePathPrefix + this.dvr.getCls() + "Folder.java");
            rt.addTemplateWrite("gradle/videodriver/BNfooDvrId.java.vm", dvrPackagePathPrefix + this.dvr.getCls() + "Id.java");
            rt.addTemplateWrite("gradle/videodriver/BNfooMultistreamPreferences.java.vm", dvrPackagePathPrefix + "B" + this.basePrefix + "MultistreamPreferences.java");
        }
        String cameraPackagePathPrefix = srcPathPrefix + "camera/";
        rt.addTemplateWrite("gradle/videodriver/BNfooCamera.java.vm", cameraPackagePathPrefix + "B" + this.basePrefix + "Camera.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooCameraDeviceExt.java.vm", cameraPackagePathPrefix + "B" + this.basePrefix + "CameraDeviceExt.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooCameraDeviceId.java.vm", cameraPackagePathPrefix + "B" + this.basePrefix + "CameraDeviceId.java");
        if (this.dvrDiscovery) {
            rt.addTemplateWrite("gradle/videodriver/BNfooCameraDiscoveryLeaf.java.vm", cameraPackagePathPrefix + "B" + this.basePrefix + "CameraDiscoveryLeaf.java");
            rt.addTemplateWrite("gradle/videodriver/BNfooCameraDiscoveryPreferences.java.vm", cameraPackagePathPrefix + "B" + this.basePrefix + "CameraDiscoveryPreferences.java");
        }
        rt.addTemplateWrite("gradle/videodriver/BNfooCameraFolder.java.vm", cameraPackagePathPrefix + "B" + this.basePrefix + "CameraFolder.java");
        if (this.dvrDisplay) {
            String displayPackagePathPrefix = srcPathPrefix + "display/";
            rt.addTemplateWrite("gradle/videodriver/BNfooVideoDisplay.java.vm", displayPackagePathPrefix + "B" + this.basePrefix + "Display.java");
            rt.addTemplateWrite("gradle/videodriver/BNfooVideoDisplayMultistream.java.vm", displayPackagePathPrefix + "B" + this.basePrefix + "DisplayMultistream.java");
            rt.addTemplateWrite("gradle/videodriver/NfooVideoDisplayController.java.vm", displayPackagePathPrefix + this.basePrefix + "DisplayController.java");
        }
        String eventPackagePathPrefix = srcPathPrefix + "event/";
        rt.addTemplateWrite("gradle/videodriver/BNfooEventCameraExt.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "EventCameraExt.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooEventDiscoveryLeaf.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "EventDiscoveryLeaf.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooEventDiscoveryList.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "EventDiscoveryList.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooEventDiscoveryPreferences.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "EventDiscoveryPreferences.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooEventFolder.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "EventFolder.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooEventProxyExt.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "EventProxyExt.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooVideoEventRecall.java.vm", eventPackagePathPrefix + "B" + this.basePrefix + "VideoEventRecall.java");
        String datatypesPackagePathPrefix = srcPathPrefix + "datatypes/";
        rt.addTemplateWrite("gradle/videodriver/BNfooIpAddress.java.vm", datatypesPackagePathPrefix + "B" + this.basePrefix + "IpAddress.java");
        rt.addTemplateWrite("gradle/videodriver/BNfooTimeSyncParams.java.vm", datatypesPackagePathPrefix + "B" + this.basePrefix + "TimeSyncParams.java");
        String enumsPackagePathPrefix = srcPathPrefix + "enums/";
        rt.addTemplateWrite("gradle/videodriver/BNfooEventTypesEnum.java.vm", enumsPackagePathPrefix + "B" + this.basePrefix + "EventTypesEnum.java");
        if (this.dvrDisplay) {
            rt.addTemplateWrite("gradle/videodriver/BNfooDisplayLayoutTypesEnum.java.vm", enumsPackagePathPrefix + "B" + this.basePrefix + "DisplayLayoutTypesEnum.java");
        }
        if (this.getCommInfo().isHttp()) {
            String utilPackagePathPrefix = srcPathPrefix + "util/";
            rt.addTemplateWrite("gradle/videodriver/NfooHttpUtil.java.vm", utilPackagePathPrefix + this.basePrefix + "HttpUtil.java");
            rt.addTemplateWrite("gradle/videodriver/NfooVideoStreamUtil.java.vm", utilPackagePathPrefix + this.basePrefix + "VideoStreamUtil.java");
        }
        String messagePackagePathPrefix = srcPathPrefix + "messages/";
        if (this.camera.isPanTiltSupport()) {
            rt.addTemplateWrite("gradle/videodriver/NfooPanTiltReq.java.vm", messagePackagePathPrefix + this.basePrefix + "PanTiltReq.java");
        }
        if (this.camera.isFocusSupport()) {
            rt.addTemplateWrite("gradle/videodriver/NfooFocusControlReq.java.vm", messagePackagePathPrefix + this.basePrefix + "FocusControlReq.java");
        }
        NiagaraModulePartGenerator wb = this.getModulePart(ModuleRuntimeProfile.wb);
        String uiPackagePathPrefix = srcPathPrefix + "ui/";
        wb.addTemplateWrite("gradle/videodriver/NfooVideoDecoder.java.vm", uiPackagePathPrefix + this.basePrefix + "VideoDecoder.java");
        wb.addTemplateWrite("gradle/videodriver/BNfooVideoAgent.java.vm", uiPackagePathPrefix + "B" + this.basePrefix + "VideoAgent.java");
        this.writeNiagaraModuleFiles();
        Slotomatic.builder().withModulePath(rt.generator.getBaseDirectory().toPath()).compile().runSlotomatic();
        Slotomatic.builder().withModulePath(wb.generator.getBaseDirectory().toPath()).compile().runSlotomatic();
    }

    public void setDvr(String dvr) {
        this.dvr.setType(dvr);
    }

    public void useDvr(boolean dvr) {
        this.dvrSupport = dvr;
        this.context.put("hasDvrSupport", (Object)dvr);
    }

    public void useDvrDiscovery(boolean discovery) {
        this.dvrDiscovery = discovery;
        this.context.put("hasDvrDiscovery", (Object)discovery);
    }

    public void useDvrDisplay(boolean display) {
        this.dvrDisplay = display;
        this.context.put("hasDvrDisplay", (Object)display);
    }

    public VideoCameraInfo getCamera() {
        return this.camera;
    }
}

