/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.TemplateCopyInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityGenerator {
    private final VelocityEngine ve;
    private final VelocityContext baseContext;
    private final File baseDirectory;
    private static final Map<String, String> utils = new HashMap<String, String>();
    private static final List<String> REQUIRED_PLUGIN_VERSIONS;

    public VelocityGenerator(File baseDirectory) {
        this.ve = new VelocityEngine();
        this.ve.setProperty("resource.loaders", (Object)"classpath");
        this.ve.setProperty("resource.loader.classpath.class", (Object)ClasspathResourceLoader.class.getName());
        this.baseContext = new VelocityContext();
        this.initContext(this.baseContext);
        this.baseDirectory = Objects.requireNonNull(baseDirectory);
        this.ensureDirectoryCreated(this.baseDirectory);
    }

    public VelocityGenerator(VelocityGenerator generator, String subdirectory) {
        Objects.requireNonNull(generator);
        this.ve = generator.ve;
        this.baseContext = new VelocityContext((Context)generator.getBaseContext());
        this.baseDirectory = new File(generator.getBaseDirectory(), subdirectory);
        this.ensureDirectoryCreated(this.baseDirectory);
    }

    public VelocityContext getBaseContext() {
        return this.baseContext;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void writeTemplate(VelocityContext context, String templatePath, String destinationPath) {
        File target = new File(this.baseDirectory, destinationPath);
        this.ensureDirectoryCreated(target.getParentFile());
        Template t = this.ve.getTemplate(templatePath);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(target), StandardCharsets.UTF_8));){
            t.merge((Context)context, (Writer)writer);
            writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeTemplate(VelocityContext context, TemplateCopyInfo copyInfo) {
        this.writeTemplate(context, copyInfo.getSourcePath(), copyInfo.getDestinationPath());
    }

    public void writeTemplates(VelocityContext context, Iterable<TemplateCopyInfo> templateWrites) {
        for (TemplateCopyInfo copyInfo : templateWrites) {
            this.writeTemplate(context, copyInfo);
        }
    }

    public void copyFile(String sourcePath, String destinationPath, boolean makeExecutable) {
        File target = new File(this.baseDirectory, destinationPath);
        this.ensureDirectoryCreated(target.getParentFile());
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(sourcePath);
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(target));){
            Path targetPath;
            int n;
            if (is == null) {
                throw new IllegalArgumentException("Cannot find '" + sourcePath + "' on the classpath");
            }
            int len = 4096;
            byte[] buf = new byte[len];
            while ((n = is.read(buf, 0, len)) >= 0) {
                ((OutputStream)os).write(buf, 0, n);
            }
            if (makeExecutable && Files.getFileStore(targetPath = target.toPath()).supportsFileAttributeView(PosixFileAttributeView.class)) {
                Files.setPosixFilePermissions(targetPath, PosixFilePermissions.fromString("rwxr-xr-x"));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void copyFile(String sourcePath, String destinationPath) {
        this.copyFile(sourcePath, destinationPath, false);
    }

    public void copyFile(TemplateCopyInfo copyInfo) {
        this.copyFile(copyInfo.getSourcePath(), copyInfo.getDestinationPath(), copyInfo.isMakeExecutable());
    }

    public void copyFiles(Iterable<TemplateCopyInfo> fileCopies) {
        for (TemplateCopyInfo copyInfo : fileCopies) {
            this.copyFile(copyInfo);
        }
    }

    public void ensureDirectoryCreated(File target) {
        if (!target.exists() && !target.mkdirs()) {
            throw new UncheckedIOException(new FileNotFoundException("Cannot create directory " + target));
        }
    }

    private void initContext(VelocityContext context) {
        Properties pluginVersions = this.readPluginVersions();
        for (String versionKey : REQUIRED_PLUGIN_VERSIONS) {
            String version = pluginVersions.getProperty(versionKey);
            if (version == null) {
                throw new IllegalStateException("Required key " + versionKey + " was not found in 'plugin-version.properties");
            }
            context.put(versionKey, (Object)version);
        }
        context.put("today", this.createToday());
        context.put("utils", utils);
    }

    private Map<String, Object> createToday() {
        HashMap<String, Object> today = new HashMap<String, Object>();
        Calendar now = Calendar.getInstance(Locale.ENGLISH);
        today.put("year", now.get(1));
        today.put("month", now.get(2) + 1);
        today.put("date", now.get(5));
        return today;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties readPluginVersions() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("plugin-version.properties");){
            if (is == null) {
                throw new IllegalArgumentException("Cannot find 'plugin-version.properties' on the classpath");
            }
            Properties properties = new Properties();
            properties.load(is);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        utils.put("D", "$");
        utils.put("H", "#");
        REQUIRED_PLUGIN_VERSIONS = Arrays.asList("gradlePluginVersion", "settingsPluginVersion");
    }
}

