/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gradle.plugins.templates;

import com.tridium.gradle.plugins.templates.GradleProjectGenerator;
import com.tridium.gradle.plugins.templates.ModuleDependency;
import com.tridium.gradle.plugins.templates.ModuleRuntimeProfile;
import com.tridium.gradle.plugins.templates.NiagaraModuleDependencies;
import com.tridium.gradle.plugins.templates.NiagaraModuleGenerator;
import com.tridium.gradle.plugins.templates.NiagaraModulePartGenerator;
import com.tridium.gradle.plugins.templates.exception.TemplateGenerationException;
import com.tridium.gradle.plugins.templates.util.GeneratorUtils;
import com.tridium.gradle.plugins.templates.util.NDriverCommInfo;
import com.tridium.gradle.plugins.templates.util.NiagaraTypeInfo;
import com.tridium.slottool.Slotomatic;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class NDriverModuleGenerator
extends NiagaraModuleGenerator {
    protected String basePackage;
    protected String basePrefix;
    protected NDriverCommInfo comm = new NDriverCommInfo();
    protected NiagaraTypeInfo network = new NiagaraTypeInfo();
    protected NiagaraTypeInfo device = new NiagaraTypeInfo();
    protected NiagaraTypeInfo deviceFolder = new NiagaraTypeInfo();
    protected NiagaraTypeInfo deviceManager = new NiagaraTypeInfo();
    protected NiagaraTypeInfo learnDeviceEntry = new NiagaraTypeInfo();
    protected NiagaraTypeInfo learnDevicesJob = new NiagaraTypeInfo();
    protected NiagaraTypeInfo pointDeviceExt = new NiagaraTypeInfo();
    protected NiagaraTypeInfo pointFolder = new NiagaraTypeInfo();
    protected NiagaraTypeInfo proxyExt = new NiagaraTypeInfo();
    protected NiagaraTypeInfo pointManager = new NiagaraTypeInfo();
    protected boolean points = false;
    protected boolean deviceManagerDiscovery = false;
    protected boolean pointManagerDiscovery = false;
    protected final SimpleDateFormat defaultDateFormat = new SimpleDateFormat("dd MMM yyyy");
    private static final List<String> DEFAULT_RT_DEPENDENCIES = Arrays.asList("baja", "alarm-rt", "driver-rt", "control-rt", "ndriver-rt");
    private static final List<String> DEFAULT_WB_DEPENDENCIES = Arrays.asList("gx-rt", "gx-wb", "bajaui-wb", "driver-wb", "ndriver-wb", "workbench-wb");

    protected NDriverModuleGenerator(GradleProjectGenerator projectGenerator, String modulePath, String moduleName) {
        super(projectGenerator, modulePath, moduleName);
        super.setRuntimeProfiles(ModuleRuntimeProfile.rt);
        NiagaraModulePartGenerator rt = this.getModulePart(ModuleRuntimeProfile.rt);
        NiagaraModuleDependencies rtDependencies = rt.getDependencies();
        for (String dependency : DEFAULT_RT_DEPENDENCIES) {
            rtDependencies.addDependency(new ModuleDependency("", dependency));
        }
        this.context.put("comm", (Object)this.comm);
        this.context.put("device", (Object)this.device);
        this.context.put("network", (Object)this.network);
        this.context.put("deviceFolder", (Object)this.deviceFolder);
        this.context.put("deviceManager", (Object)this.deviceManager);
        this.context.put("learnDeviceEntry", (Object)this.learnDeviceEntry);
        this.context.put("learnDevicesJob", (Object)this.learnDevicesJob);
        this.context.put("pointDeviceExt", (Object)this.pointDeviceExt);
        this.context.put("pointFolder", (Object)this.pointFolder);
        this.context.put("proxyExt", (Object)this.proxyExt);
        this.context.put("pointManager", (Object)this.pointManager);
        this.setBasePackage(String.join((CharSequence)".", "com", projectGenerator.getVendor(), moduleName));
        this.doSetClassPrefix(StringUtils.capitalize((String)moduleName));
        this.setAuthor(projectGenerator.getVendor());
        this.setLocalizedDate(this.defaultDateFormat.format(new Date()));
    }

    public static NDriverModuleGenerator make(GradleProjectGenerator projectGenerator, String moduleName) {
        return NDriverModuleGenerator.make(projectGenerator, moduleName, "");
    }

    public static NDriverModuleGenerator make(GradleProjectGenerator projectGenerator, String moduleName, String moduleRoot) {
        StringJoiner joiner = new StringJoiner("/");
        if (moduleRoot != null && !moduleRoot.isEmpty()) {
            joiner.add(moduleRoot);
        }
        joiner.add(moduleName);
        String modulePath = joiner.toString();
        return new NDriverModuleGenerator(projectGenerator, modulePath, moduleName);
    }

    @Override
    public void setRuntimeProfiles(ModuleRuntimeProfile ... runtimeProfiles) {
        throw new TemplateGenerationException("NDriver runtime profiles cannot be customized");
    }

    @Override
    public void generate() {
        NiagaraModulePartGenerator wb;
        this.context.put("autoDeviceLearn", (Object)(!this.deviceManager.isCustom() && this.deviceManagerDiscovery ? 1 : 0));
        this.context.put("deviceManagerLearn", (Object)(this.deviceManager.isCustom() && this.deviceManagerDiscovery ? 1 : 0));
        boolean autoPointDiscover = this.points && this.pointManagerDiscovery;
        this.context.put("autoPointDiscover", (Object)autoPointDiscover);
        this.context.put("addNPntMgr", (Object)(!this.pointManager.isCustom() && !autoPointDiscover ? 1 : 0));
        NiagaraModulePartGenerator rt = this.getModulePart(ModuleRuntimeProfile.rt);
        rt.addTemplateWrite("gradle/ndriver/module.palette.vm", "module.palette");
        String srcMain = "src";
        String packagePath = this.basePackage.replace('.', '/');
        String srcPathPrefix = srcMain + "/" + packagePath + "/";
        rt.addTemplateWrite("gradle/ndriver/BNfooNetwork.java.vm", srcPathPrefix + this.network.getCls() + ".java");
        rt.addTemplateWrite("gradle/ndriver/BNfooDevice.java.vm", srcPathPrefix + this.device.getCls() + ".java");
        rt.addTemplateWrite("gradle/ndriver/BNfooDeviceFolder.java.vm", srcPathPrefix + this.deviceFolder.getCls() + ".java");
        String messagePackagePathPrefix = srcPathPrefix + "message/";
        rt.addTemplateWrite("gradle/ndriver/NfooMessage.java.vm", messagePackagePathPrefix + this.basePrefix + "Message.java");
        rt.addTemplateWrite("gradle/ndriver/NfooMessageFactory.java.vm", messagePackagePathPrefix + this.basePrefix + "MessageFactory.java");
        String commPackagePathPrefix = srcPathPrefix + "comm/";
        if (this.comm.isSerial()) {
            rt.addTemplateWrite("gradle/ndriver/BNfooSerialCommConfig.java.vm", commPackagePathPrefix + "B" + this.basePrefix + "SerialCommConfig.java");
            rt.addTemplateWrite("gradle/ndriver/NfooSerialLinkMessage.java.vm", commPackagePathPrefix + this.basePrefix + this.comm.getSerialLinkMsg() + ".java");
        }
        if (this.comm.isTcp()) {
            rt.addTemplateWrite("gradle/ndriver/BNfooTcpCommConfig.java.vm", commPackagePathPrefix + "B" + this.basePrefix + "TcpCommConfig.java");
            rt.addTemplateWrite("gradle/ndriver/NfooTcpLinkMessage.java.vm", commPackagePathPrefix + this.basePrefix + this.comm.getTcpLinkMsg() + ".java");
        }
        if (this.comm.isProcessUnsolicited()) {
            rt.addTemplateWrite("gradle/ndriver/NfooListener.java.vm", commPackagePathPrefix + this.basePrefix + "Listener.java");
        }
        if (this.deviceManagerDiscovery) {
            String learnPackagePathPrefix = srcPathPrefix + "learn/";
            if (this.deviceManager.isCustom()) {
                rt.addTemplateWrite("gradle/ndriver/BNfooLearnDeviceEntry.java.vm", learnPackagePathPrefix + this.learnDeviceEntry.getCls() + ".java");
                rt.addTemplateWrite("gradle/ndriver/BNfooLearnDevicesJob.java.vm", learnPackagePathPrefix + this.learnDevicesJob.getCls() + ".java");
            } else {
                rt.addTemplateWrite("gradle/ndriver/BNfooDeviceDiscoveryPreferences.java.vm", learnPackagePathPrefix + "B" + this.basePrefix + "DeviceDiscoveryPreferences.java");
                rt.addTemplateWrite("gradle/ndriver/BNfooDeviceDiscoveryLeaf.java.vm", learnPackagePathPrefix + "B" + this.basePrefix + "DeviceDiscoveryLeaf.java");
            }
        }
        if (this.points) {
            String pointPackagePathPrefix = srcPathPrefix + "point/";
            rt.addTemplateWrite("gradle/ndriver/BNfooPointDeviceExt.java.vm", pointPackagePathPrefix + this.pointDeviceExt.getCls() + ".java");
            rt.addTemplateWrite("gradle/ndriver/BNfooPointFolder.java.vm", pointPackagePathPrefix + this.pointFolder.getCls() + ".java");
            rt.addTemplateWrite("gradle/ndriver/BNfooProxyExt.java.vm", pointPackagePathPrefix + this.proxyExt.getCls() + ".java");
            if (autoPointDiscover) {
                rt.addTemplateWrite("gradle/ndriver/BNfooPointDiscoveryPreferences.java.vm", pointPackagePathPrefix + "B" + this.basePrefix + "PointDiscoveryPreferences.java");
                rt.addTemplateWrite("gradle/ndriver/BNfooPointDiscoveryLeaf.java.vm", pointPackagePathPrefix + "B" + this.basePrefix + "PointDiscoveryLeaf.java");
            }
        }
        if (this.runtimeProfiles.containsKey((Object)ModuleRuntimeProfile.wb)) {
            wb = this.getModulePart(ModuleRuntimeProfile.wb);
            if (this.deviceManager.isCustom()) {
                wb.addTemplateWrite("gradle/ndriver/BNfooDeviceManager.java.vm", srcPathPrefix + "ui/" + this.deviceManager.getCls() + ".java");
            }
            if (this.pointManager.isCustom()) {
                wb.addTemplateWrite("gradle/ndriver/BNfooPointManager.java.vm", srcPathPrefix + "ui/" + this.pointManager.getCls() + ".java");
            }
        }
        super.generate();
        Slotomatic.builder().withModulePath(rt.generator.getBaseDirectory().toPath()).compile().runSlotomatic();
        if (this.runtimeProfiles.containsKey((Object)ModuleRuntimeProfile.wb)) {
            wb = this.getModulePart(ModuleRuntimeProfile.wb);
            Slotomatic.builder().withModulePath(wb.generator.getBaseDirectory().toPath()).compile().runSlotomatic();
        }
    }

    public void setAuthor(String author) {
        this.context.put("author", (Object)author);
    }

    public void setLocalizedDate(String date) {
        this.context.put("date", (Object)date);
    }

    public void setBasePackage(String basePackage) {
        if (!GeneratorUtils.isValidJavaPackage(basePackage)) {
            throw new IllegalArgumentException(basePackage + " is not a valid package name");
        }
        this.basePackage = basePackage;
        this.context.put("package", (Object)this.basePackage);
    }

    public NDriverCommInfo getCommInfo() {
        return this.comm;
    }

    public void setClassPrefix(String classPrefix) {
        this.doSetClassPrefix(classPrefix);
    }

    private void doSetClassPrefix(String classPrefix) {
        if (!GeneratorUtils.isValidJavaIdentifier(classPrefix)) {
            throw new IllegalArgumentException(classPrefix + " is not a valid class name");
        }
        this.basePrefix = classPrefix;
        this.context.put("basePrefix", (Object)this.basePrefix);
        this.network.setType(classPrefix + "Network");
        this.device.setType(classPrefix + "Device");
        this.deviceFolder.setType(classPrefix + "DeviceFolder");
        this.deviceManager.setType(classPrefix + "DeviceManager");
        this.pointDeviceExt.setType(classPrefix + "PointDeviceExt");
        this.pointFolder.setType(classPrefix + "PointFolder");
        this.proxyExt.setType(classPrefix + "ProxyExt");
        this.pointManager.setType(classPrefix + "PointManager");
        this.learnDeviceEntry.setType(classPrefix + "LearnDeviceEntry");
        this.learnDevicesJob.setType(classPrefix + "LearnDevicesJob");
    }

    public void setDeviceNetwork(String deviceNetwork) {
        this.network.setType(deviceNetwork);
    }

    public void setDevice(String device) {
        this.device.setType(device);
    }

    public void setDeviceFolder(String deviceFolder) {
        this.deviceFolder.setType(deviceFolder);
    }

    public void useCustomDeviceManager(boolean custom) {
        if (custom) {
            this.addWbPart();
        }
        this.deviceManager.setCustom(custom);
    }

    public void useCustomDeviceManager() {
        this.useCustomDeviceManager(true);
    }

    public void setDeviceManager(String deviceManager) {
        this.deviceManager.setType(deviceManager);
    }

    public void useDeviceDiscovery(boolean discovery) {
        this.deviceManagerDiscovery = discovery;
    }

    public void useDeviceDiscovery() {
        this.useDeviceDiscovery(true);
    }

    public void usePointDeviceExtension(boolean points) {
        this.points = points;
        this.context.put("points", (Object)points);
    }

    public void usePointDeviceExtension() {
        this.usePointDeviceExtension(true);
    }

    public void setPointDeviceExtension(String pointDeviceExtension) {
        this.pointDeviceExt.setType(pointDeviceExtension);
    }

    public void setPointFolder(String pointFolder) {
        this.pointFolder.setType(pointFolder);
    }

    public void setProxyExt(String proxyExt) {
        this.proxyExt.setType(proxyExt);
    }

    public void useCustomPointManager(boolean custom) {
        if (custom) {
            this.addWbPart();
        }
        this.pointManager.setCustom(custom);
    }

    public void useCustomPointManager() {
        this.useCustomPointManager(true);
    }

    public void setPointManager(String pointManager) {
        this.pointManager.setType(pointManager);
    }

    public void usePointDiscovery(boolean discovery) {
        this.pointManagerDiscovery = discovery;
    }

    public void usePointDiscovery() {
        this.usePointDiscovery(true);
    }

    protected void addWbPart() {
        if (!this.runtimeProfiles.containsKey((Object)ModuleRuntimeProfile.wb)) {
            NiagaraModulePartGenerator wb = NiagaraModulePartGenerator.make(this, ModuleRuntimeProfile.wb);
            this.runtimeProfiles.put(ModuleRuntimeProfile.wb, wb);
            NiagaraModuleDependencies wbDependencies = wb.getDependencies();
            for (String dependency : DEFAULT_RT_DEPENDENCIES) {
                wbDependencies.addDependency(new ModuleDependency("", dependency));
            }
            for (String dependency : DEFAULT_WB_DEPENDENCIES) {
                wbDependencies.addDependency(new ModuleDependency("", dependency));
            }
            wbDependencies.addProjectDependency(this.moduleName + "-rt");
        }
    }
}

