/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.util.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedDataOutput
implements DataOutput {
    private File file;
    private int maxBufSize;
    private RandomAccessFile raf;
    private ByteArrayOutputStream bs;
    private DataOutputStream ds;

    public BufferedDataOutput(File file, boolean deleteExisting, int maxBufSize) throws IOException {
        this.file = file;
        this.maxBufSize = maxBufSize;
        if (deleteExisting && file.exists()) {
            file.delete();
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.bs = new ByteArrayOutputStream();
        this.ds = new DataOutputStream(this.bs);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ds.writeByte(v);
        this.checkBuffer();
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ds.writeLong(v);
        this.checkBuffer();
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.ds.writeUTF(str);
        this.checkBuffer();
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ds.writeInt(v);
        this.checkBuffer();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ds.writeBoolean(v);
        this.checkBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeShort(int v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeChar(int v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeFloat(float v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new IllegalStateException();
    }

    public void close() throws IOException {
        if (this.bs.size() > 0) {
            this.raf.write(this.bs.toByteArray());
        }
        this.ds = null;
        this.bs = null;
    }

    public long length() throws IOException {
        return this.raf.length() + (long)this.bs.size();
    }

    private void checkBuffer() throws IOException {
        if (this.bs.size() > this.maxBufSize) {
            byte[] b = this.bs.toByteArray();
            this.raf.write(b);
            this.ds = null;
            this.bs = null;
            b = null;
            System.gc();
            this.bs = new ByteArrayOutputStream();
            this.ds = new DataOutputStream(this.bs);
        }
    }
}

