/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.ui.lexicon;

import com.tridium.devkit.ui.lexicon.BLexiconEditor;
import com.tridium.devkit.ui.lexicon.BLexiconEditorOptions;
import com.tridium.devkit.ui.lexicon.BLexiconTool;
import com.tridium.sys.Nre;
import com.tridium.sys.module.ModuleManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"devkit:LexiconTool"})})
@NiagaraAction(name="filterLexicon")
public class BLexiconReport
extends BWbView {
    @Generated
    public static final Action filterLexicon = BLexiconReport.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLexiconReport.class);
    BList languageList;
    DefaultListModel listModel;
    BTable languageDetailsTable;
    DefaultTableModel languageDetailsTableModel;
    BFlowPane filterPane;
    DefaultTableModel searchTableModel;
    BTable searchTable;
    BCheckBox refValuesFilter;
    BCheckBox accelFilter;
    BCheckBox colorsFilter;
    BCheckBox fontsFilter;
    BCheckBox typesFilter;
    BEdgePane detailsPane;
    ToggleCommand hideRefValuesCmd;
    ToggleCommand hideAccelsCmd;
    ToggleCommand hideColorsCmd;
    ToggleCommand hideFontsCmd;
    ToggleCommand hideTypesCmd;
    BLexiconTool tool;
    File lexiconHome = new File(Nre.getNiagaraHome(), "lexicon");
    private static final Logger LOGGER = Logger.getLogger("sys.lexicon");

    @Generated
    public void filterLexicon() {
        this.invoke(filterLexicon, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLexiconReport() {
        this.languageList = new BList();
        this.languageList.setController((ListController)new LController());
        this.languageDetailsTable = new BTable();
        this.languageDetailsTable.setController((TableController)new TController());
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.tool = (BLexiconTool)value;
        String[] lexicons = BLexiconReport.listLanguages();
        this.listModel = new DefaultListModel();
        this.languageList.setModel((ListModel)this.listModel);
        this.languageList.setMultipleSelection(false);
        for (String lexicon : lexicons) {
            this.listModel.addItem((Object)lexicon);
        }
        Command newCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.newLexicon"){

            public CommandArtifact doInvoke() {
                BLexiconReport.this.newLexicon();
                return null;
            }
        };
        BButton newButton = new BButton(newCommand, true, true);
        Command deleteCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.deleteLexicon"){

            public CommandArtifact doInvoke() {
                BLexiconReport.this.deleteLexicon();
                return null;
            }
        };
        BButton deleteButton = new BButton(deleteCommand, true, true);
        Command searchCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.searchLexicon"){

            public CommandArtifact doInvoke() {
                BLexiconReport.this.searchLexicon();
                return null;
            }
        };
        BButton searchButton = new BButton(searchCommand, true, true);
        this.hideRefValuesCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.refValuesFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideRefValues(BLexiconReport.this.hideRefValuesCmd.isSelected());
                BLexiconReport.this.filterLexicon();
                return null;
            }
        };
        this.hideAccelsCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.accelFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideAccelerators(BLexiconReport.this.hideAccelsCmd.isSelected());
                BLexiconReport.this.filterLexicon();
                return null;
            }
        };
        this.hideColorsCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.colorsFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideColors(BLexiconReport.this.hideColorsCmd.isSelected());
                BLexiconReport.this.filterLexicon();
                return null;
            }
        };
        this.hideFontsCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.fontsFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideFonts(BLexiconReport.this.hideFontsCmd.isSelected());
                BLexiconReport.this.filterLexicon();
                return null;
            }
        };
        this.hideTypesCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.typesFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideTypes(BLexiconReport.this.hideTypesCmd.isSelected());
                BLexiconReport.this.filterLexicon();
                return null;
            }
        };
        this.detailsPane = new BEdgePane();
        this.filterPane = new BFlowPane();
        this.refValuesFilter = new BCheckBox(this.hideRefValuesCmd);
        this.accelFilter = new BCheckBox(this.hideAccelsCmd);
        this.colorsFilter = new BCheckBox(this.hideColorsCmd);
        this.fontsFilter = new BCheckBox(this.hideFontsCmd);
        this.typesFilter = new BCheckBox(this.hideTypesCmd);
        BLexiconEditorOptions options = BLexiconEditorOptions.getDefault();
        this.refValuesFilter.setSelected(options.getHideRefValues());
        this.accelFilter.setSelected(options.getHideAccelerators());
        this.colorsFilter.setSelected(options.getHideColors());
        this.fontsFilter.setSelected(options.getHideFonts());
        this.typesFilter.setSelected(options.getHideTypes());
        this.filterPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("LexiconEditor.hide.label") + ":"));
        this.filterPane.add(null, (BValue)this.refValuesFilter);
        this.filterPane.add(null, (BValue)this.accelFilter);
        this.filterPane.add(null, (BValue)this.colorsFilter);
        this.filterPane.add(null, (BValue)this.fontsFilter);
        this.filterPane.add(null, (BValue)this.typesFilter);
        this.detailsPane.setTop((BWidget)this.filterPane);
        String[] tableHeader = new String[]{BLexiconTool.lexicon.getText("lexicon.module"), BLexiconTool.lexicon.getText("lexicon.moduleLastModified"), BLexiconTool.lexicon.getText("lexicon.defaultLastModified"), BLexiconTool.lexicon.getText("lexicon.lexiconLastModified"), BLexiconTool.lexicon.getText("lexicon.missing"), BLexiconTool.lexicon.getText("lexicon.complete")};
        this.languageDetailsTableModel = new DefaultTableModel(tableHeader);
        this.languageDetailsTable.setModel((TableModel)new DynamicTableModel((TableModel)this.languageDetailsTableModel));
        this.languageDetailsTable.setMultipleSelection(false);
        this.detailsPane.setCenter((BWidget)this.languageDetailsTable);
        BEdgePane listPane = new BEdgePane();
        listPane.setCenter((BWidget)this.languageList);
        BGridPane buttonBox = new BGridPane(1);
        buttonBox.setColumnAlign(BHalign.fill);
        buttonBox.add(null, (BValue)newButton);
        buttonBox.add(null, (BValue)deleteButton);
        buttonBox.add(null, (BValue)searchButton);
        listPane.setBottom((BWidget)new BBorderPane((BWidget)buttonBox));
        BEdgePane edgePane = new BEdgePane();
        edgePane.setLeft((BWidget)new BBorderPane((BWidget)listPane, BLexiconTool.lexicon.getText("lexicon")));
        edgePane.setCenter((BWidget)new BBorderPane((BWidget)this.detailsPane));
        this.setContent((BWidget)edgePane);
        String lexiconName = this.tool.lexiconName;
        String moduleName = this.tool.moduleName;
        if (lexiconName != null) {
            for (int i = 0; i < this.listModel.getItemCount(); ++i) {
                if (!this.listModel.getItem(i).equals(lexiconName)) continue;
                this.languageList.setSelectedIndex(i);
                break;
            }
        }
        this.showDetails();
        if (moduleName != null) {
            TableSelection sel = this.languageDetailsTable.getSelection();
            for (int i = 0; i < this.languageDetailsTableModel.getRowCount(); ++i) {
                if (!this.languageDetailsTableModel.getValueAt(i, 0).equals(moduleName)) continue;
                sel.select(i);
                break;
            }
        }
    }

    public BMenu[] getViewMenus() {
        BMenu menu = BLexiconTool.lexicon.buildMenu("menu.lexiconReport.label");
        BMenu hideSubMenu = BLexiconTool.lexicon.buildMenu("LexiconEditor.hide.label");
        hideSubMenu.add("menuRefValuesFilter", (Command)this.hideRefValuesCmd);
        hideSubMenu.add("menuAccelFilter", (Command)this.hideAccelsCmd);
        hideSubMenu.add("menuColorsFilter", (Command)this.hideColorsCmd);
        hideSubMenu.add("menuFontsFilter", (Command)this.hideFontsCmd);
        hideSubMenu.add("menuTypesFilter", (Command)this.hideTypesCmd);
        menu.add("hideSubMenu", (BValue)new BSubMenuItem((BIMenu)hideSubMenu));
        return new BMenu[]{menu};
    }

    static String[] listLanguages() {
        File lexiconHome = new File(Nre.getNiagaraHome(), "lexicon");
        if (!lexiconHome.exists() && !lexiconHome.mkdir()) {
            return new String[0];
        }
        TreeSet<String> languages = new TreeSet<String>();
        for (LexiconInfo aLexRegistry : Sys.getRegistry().getLexicons()) {
            String lang = aLexRegistry.getLanguage();
            if (lang == null || lang.length() <= 0) continue;
            languages.add(aLexRegistry.getLanguage());
        }
        Collections.addAll(languages, lexiconHome.list());
        return languages.toArray(new String[0]);
    }

    static String[] listModulesWithLexicons() {
        TreeSet<String> accum = new TreeSet<String>();
        ModuleManager moduleManager = AccessController.doPrivileged(() -> Nre.getModuleManager());
        for (ModuleInfo moduleInfo : Sys.getRegistry().getModules()) {
            BModule module = moduleManager.loadModule(moduleInfo.getModuleName(), moduleInfo.getRuntimeProfile()).bmodule();
            BIFileStore store = module.findStore(new FilePath("module", String.format("/%s.lexicon", moduleInfo.getModulePartName())));
            if (store == null) continue;
            accum.add(moduleInfo.getModuleName());
        }
        return accum.toArray(new String[0]);
    }

    public void doFilterLexicon() {
        this.showDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void showDetails() {
        try {
            String lexicon;
            this.enterBusy();
            if (this.languageList.getSelection().getItem() < 0) {
                this.exitBusy();
                return;
            }
            this.tool.lexiconName = lexicon = (String)this.listModel.getItem(this.languageList.getSelection().getItem());
            this.filterPane.relayout();
            this.languageDetailsTableModel.removeAllRows();
            ModuleManager moduleManager = AccessController.doPrivileged(() -> Nre.getModuleManager());
            TreeSet<String> processedModuleNames = new TreeSet<String>();
            for (ModuleInfo moduleInfo : Sys.getRegistry().getModules()) {
                Object[] row = new Object[6];
                if (processedModuleNames.contains(moduleInfo.getModuleName())) continue;
                processedModuleNames.add(moduleInfo.getModuleName());
                row[0] = moduleInfo.getModuleName();
                try {
                    void var15_23;
                    Object iconKey;
                    BModule module = moduleManager.loadModule(moduleInfo.getModuleName(), moduleInfo.getRuntimeProfile()).bmodule();
                    Properties bProps = null;
                    BIFileStore store = module.findStore(new FilePath("module", String.format("/%s.lexicon", moduleInfo.getModulePartName())));
                    if (store != null) {
                        if (bProps == null) {
                            bProps = new Properties();
                            row[1] = store.getLastModified();
                        } else if (store.getLastModified().compareTo(row[1]) > 0) {
                            row[1] = store.getLastModified();
                        }
                        try (InputStream in = store.getInputStream();){
                            bProps.load(in);
                        }
                    }
                    try {
                        for (TypeInfo typeInfo : Sys.getRegistry().getLexicons(moduleInfo.getModuleName(), lexicon)) {
                            if (!typeInfo.isDefault()) continue;
                            try (InputStream in = Lexicon.getInputStreamFromModule((LexiconInfo)typeInfo);){
                                if (in == null) continue;
                                bProps.load(in);
                                row[2] = typeInfo.getLastModified();
                            }
                        }
                    }
                    catch (Exception in) {
                        // empty catch block
                    }
                    for (TypeInfo typeInfo : moduleInfo.getTypes()) {
                        String nameKey = typeInfo.getTypeName() + ".displayName";
                        if (!bProps.containsKey(nameKey)) {
                            bProps.put(nameKey, "");
                        }
                        if (bProps.containsKey(iconKey = typeInfo.getTypeName() + ".icon")) continue;
                        bProps.put(iconKey, "");
                    }
                    File lFile = new File(this.lexiconHome, lexicon + File.separatorChar + moduleInfo.getModuleName() + ".lexicon");
                    int bPropCount = 0;
                    int lPropCount = 0;
                    Object var15_29 = null;
                    if (lFile.exists()) {
                        Properties properties = new Properties();
                        FileInputStream lStream = new FileInputStream(lFile);
                        iconKey = null;
                        try {
                            properties.load(lStream);
                        }
                        catch (Throwable throwable) {
                            iconKey = throwable;
                            throw throwable;
                        }
                        finally {
                            if (lStream != null) {
                                if (iconKey != null) {
                                    try {
                                        lStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)iconKey).addSuppressed(throwable);
                                    }
                                } else {
                                    lStream.close();
                                }
                            }
                        }
                        BAbsTime modifiedDate = BAbsTime.make((long)lFile.lastModified());
                        if (!(row[3] instanceof BAbsTime) || modifiedDate.compareTo(row[3]) > 0) {
                            row[3] = modifiedDate;
                        }
                    }
                    try {
                        for (LexiconInfo aLexRegistry : Sys.getRegistry().getLexicons(moduleInfo.getModuleName(), lexicon)) {
                            if (aLexRegistry.isDefault()) continue;
                            try (InputStream in = Lexicon.getInputStreamFromModule((LexiconInfo)aLexRegistry);){
                                if (in == null) continue;
                                if (var15_23 == null) {
                                    Properties properties = new Properties();
                                }
                                var15_23.load(in);
                                BAbsTime modifiedDate = aLexRegistry.getLastModified();
                                if (row[3] instanceof BAbsTime && modifiedDate.compareTo(row[3]) <= 0) continue;
                                row[3] = modifiedDate;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (var15_23 != null) {
                        for (String name : bProps.stringPropertyNames()) {
                            String value = bProps.getProperty(name);
                            if (this.refValuesFilter.isSelected() && value != null && value.contains(":/") || this.accelFilter.isSelected() && name.endsWith(".accelerator") || this.colorsFilter.isSelected() && (name.endsWith(".fg") || name.endsWith(".bg")) || this.fontsFilter.isSelected() && (name.endsWith(".font") || name.contains(".font.")) || this.typesFilter.isSelected() && (name.endsWith(".displayName") || name.endsWith(".icon")) && BLexiconEditor.countOccurrences(name, '.') == 1) continue;
                            ++bPropCount;
                            if (!var15_23.containsKey(name)) continue;
                            ++lPropCount;
                        }
                        row[4] = bPropCount - lPropCount;
                        row[5] = lPropCount;
                    }
                    if (lPropCount == 0) {
                        for (String name : bProps.stringPropertyNames()) {
                            String value = bProps.getProperty(name);
                            if (this.refValuesFilter.isSelected() && value != null && value.contains(":/") || this.accelFilter.isSelected() && name.endsWith(".accelerator") || this.colorsFilter.isSelected() && (name.endsWith(".fg") || name.endsWith(".bg")) || this.fontsFilter.isSelected() && (name.endsWith(".font") || name.contains(".font.")) || this.typesFilter.isSelected() && (name.endsWith(".displayName") || name.endsWith(".icon")) && BLexiconEditor.countOccurrences(name, '.') == 1) continue;
                            ++bPropCount;
                        }
                        row[4] = bPropCount;
                        row[5] = 0;
                    }
                    row[3] = null;
                }
                catch (Exception e) {
                    row[5] = null;
                    row[4] = null;
                    row[3] = null;
                    row[2] = null;
                    row[1] = null;
                }
                this.languageDetailsTableModel.addRow(row);
            }
            this.languageDetailsTable.sizeColumnsToFit();
        }
        catch (Exception exception) {
        }
        finally {
            this.exitBusy();
        }
    }

    public void newLexicon() {
        BLabel searchLabel = new BLabel(BLexiconTool.lexicon.getText("lexiconTool.newLexicon"));
        BTextField lexiconField = new BTextField();
        BFlowPane searchTextPane = new BFlowPane();
        searchTextPane.add(null, (BValue)searchLabel);
        searchTextPane.add(null, (BValue)lexiconField);
        int retVal = BDialog.open((BWidget)this, (String)BLexiconTool.lexicon.getText("commands.newLexicon.label"), (Object)searchTextPane, (int)3);
        if (retVal == 2) {
            return;
        }
        File newLexicon = new File(this.lexiconHome, lexiconField.getText());
        if (!newLexicon.mkdir()) {
            throw new BajaRuntimeException(String.format("cannot create new lexicon file: %s", lexiconField.getText()));
        }
        this.refresh();
    }

    public void deleteLexicon() {
        String lexiconName = (String)this.languageList.getSelectedItem();
        if (lexiconName == null) {
            return;
        }
        Object[] lexStrings = new Object[]{lexiconName};
        int retVal = BDialog.confirm((BWidget)this, (String)BLexiconTool.lexicon.getText("commands.deleteLexicon.label"), (Object)BLexiconTool.lexicon.getText("commands.deleteLexicon.warning", lexStrings));
        if (retVal == 4) {
            File delLexicon = new File(this.lexiconHome, lexiconName);
            if (delLexicon.exists()) {
                for (File lex : delLexicon.listFiles()) {
                    lex.delete();
                }
                delLexicon.delete();
            }
            this.refresh();
        }
    }

    public void searchLexicon() {
        BWbShell shell;
        BLabel searchLabel = new BLabel(BLexiconTool.lexicon.getText("lexiconTool.searchText"));
        BTextField lexiconField = new BTextField();
        BFlowPane searchTextPane = new BFlowPane();
        searchTextPane.add(null, (BValue)searchLabel);
        searchTextPane.add(null, (BValue)lexiconField);
        int retVal = BDialog.open((BWidget)this, (String)BLexiconTool.lexicon.getText("commands.searchLexicon.label"), (Object)searchTextPane, (int)3);
        if (retVal == 2) {
            return;
        }
        String searchString = lexiconField.getText();
        if (searchString.length() < 3 && (retVal = BDialog.open((BWidget)this, (String)BLexiconTool.lexicon.getText("commands.searchLexicon.label"), (Object)new BLabel(BLexiconTool.lexicon.getText("commands.searchLexicon.confirm")), (int)3)) == 2) {
            return;
        }
        List<String[]> searchResult = this.searchLexiconFilesAndModules(searchString, null);
        String[] cols = new String[]{BLexiconTool.lexicon.getText("commands.searchLexicon.column.lexicon"), BLexiconTool.lexicon.getText("commands.searchLexicon.column.language"), BLexiconTool.lexicon.getText("commands.searchLexicon.column.propertyKey"), BLexiconTool.lexicon.getText("commands.searchLexicon.column.propertyValue")};
        this.searchTableModel = new DefaultTableModel(cols);
        searchResult.forEach(arg_0 -> ((DefaultTableModel)this.searchTableModel).addRow(arg_0));
        this.searchTable = new BTable();
        this.searchTable.setModel((TableModel)this.searchTableModel);
        this.searchTable.setMultipleSelection(false);
        double searchMaxWidth = 800.0;
        double searchMaxHeight = 400.0;
        BConstrainedPane cp = new BConstrainedPane((BWidget)this.searchTable, searchMaxWidth, searchMaxHeight);
        retVal = BDialog.open((BWidget)this, (String)BLexiconTool.lexicon.getText("commands.searchLexicon.label"), (Object)cp, (int)3);
        if (retVal == 2) {
            return;
        }
        int lexRow = this.searchTable.getSelection().getRow();
        if (lexRow < 0) {
            return;
        }
        String selectedModule = (String)this.searchTableModel.getValueAt(lexRow, 0);
        String selectedLanguage = (String)this.searchTableModel.getValueAt(lexRow, 1);
        String selectedKey = (String)this.searchTableModel.getValueAt(lexRow, 2);
        if (selectedModule != null && selectedModule.length() > 0 && selectedLanguage != null && selectedLanguage.length() > 0 && (shell = this.getWbShell()) != null) {
            this.tool.lexiconName = selectedLanguage;
            this.tool.moduleName = selectedModule;
            this.tool.key = selectedKey;
            shell.hyperlink(BOrd.make((String)("view:" + BLexiconEditor.TYPE)));
        }
        if (this.languageDetailsTableModel == null) {
            return;
        }
        for (int i = 0; i < this.languageDetailsTableModel.getRowCount(); ++i) {
            if (!((String)this.languageDetailsTableModel.getValueAt(i, 0)).contains(selectedModule)) continue;
            this.languageDetailsTable.getSelection().deselectAll();
            this.languageDetailsTable.getSelection().select(i);
            this.languageDetailsTable.ensureRowIsVisible(i);
            return;
        }
    }

    private List<String[]> searchLexiconFilesAndModules(String search, String language) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("  Searching for Lexicon entries containing " + search + " for language " + language);
        }
        String[] lexicons = new String[1];
        if (language == null || language.length() == 0) {
            lexicons = BLexiconReport.listLanguages();
        } else {
            lexicons[0] = language;
        }
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String module1 : BLexiconReport.listModulesWithLexicons()) {
            try {
                BModule module = Sys.loadModule((String)module1);
                BIFile defaultFile = module.findFile(new FilePath(module1 + ".lexicon"));
                try (InputStream in = defaultFile.getInputStream();){
                    Properties langProps = new Properties();
                    langProps.load(in);
                    result.addAll(this.searchProperties(langProps, search, module1, ""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = lexicons;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                InputStream in;
                BModule module2;
                String lexicon;
                String lexiconName = lexicon = stringArray[i];
                try {
                    module2 = Sys.loadModule((String)module1);
                    in = Lexicon.getInputStreamFromModule((BModule)module2, (String)lexiconName, (boolean)true);
                    object = null;
                    try {
                        Properties langProps = new Properties();
                        langProps.load(in);
                        result.addAll(this.searchProperties(langProps, search, module1, lexiconName));
                    }
                    catch (Throwable langProps) {
                        object = langProps;
                        throw langProps;
                    }
                    finally {
                        if (in != null) {
                            if (object != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable langProps) {
                                    ((Throwable)object).addSuppressed(langProps);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (Exception module2) {
                    // empty catch block
                }
                try {
                    module2 = Sys.loadModule((String)module1);
                    Properties langProps = new Properties();
                    for (InputStream anIn : Lexicon.getInputStreamsFromModule((BModule)module2, (String)lexiconName)) {
                        langProps.load(anIn);
                        anIn.close();
                    }
                    result.addAll(this.searchProperties(langProps, search, module1, lexiconName));
                }
                catch (Exception module3) {
                    // empty catch block
                }
                try {
                    module2 = Sys.loadModule((String)module1);
                    in = Lexicon.getInputStream((BModule)module2, (String)lexiconName);
                    object = null;
                    try {
                        Properties langProps = new Properties();
                        langProps.load(in);
                        result.addAll(this.searchProperties(langProps, search, module1, lexiconName));
                        continue;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            if (object != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private List<String[]> searchProperties(Properties props, String search, String moduleName, String language) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            if (search != null && search.length() != 0 && !value.contains(search)) continue;
            String[] s = new String[]{moduleName, language, key, value};
            result.add(s);
        }
        return result;
    }

    public void refresh() {
        this.listModel.removeAllItems();
        for (String lexicon : BLexiconReport.listLanguages()) {
            this.listModel.addItem((Object)lexicon);
        }
    }

    class SController
    extends TableController {
        SController() {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                String selectedModule = (String)BLexiconReport.this.searchTableModel.getValueAt(BLexiconReport.this.searchTable.getSelection().getRow(), 0);
                String selectedLanguage = (String)BLexiconReport.this.searchTableModel.getValueAt(BLexiconReport.this.searchTable.getSelection().getRow(), 1);
                String selectedKey = (String)BLexiconReport.this.searchTableModel.getValueAt(BLexiconReport.this.searchTable.getSelection().getRow(), 2);
                if (selectedModule == null) {
                    return;
                }
                BWbShell shell = BLexiconReport.this.getWbShell();
                if (shell != null) {
                    BLexiconReport.this.tool.lexiconName = selectedLanguage;
                    BLexiconReport.this.tool.moduleName = selectedModule;
                    BLexiconReport.this.tool.key = selectedKey;
                    shell.hyperlink(BOrd.make((String)("view:" + BLexiconEditor.TYPE)));
                }
            } else if (event.getClickCount() == 1) {
                BLexiconReport.this.tool.lexiconName = (String)BLexiconReport.this.searchTableModel.getValueAt(BLexiconReport.this.searchTable.getSelection().getRow(), 1);
                BLexiconReport.this.tool.moduleName = (String)BLexiconReport.this.searchTableModel.getValueAt(BLexiconReport.this.searchTable.getSelection().getRow(), 0);
                BLexiconReport.this.tool.key = (String)BLexiconReport.this.searchTableModel.getValueAt(BLexiconReport.this.searchTable.getSelection().getRow(), 2);
            }
        }
    }

    class TController
    extends TableController {
        TController() {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            if (event.getClickCount() == 2) {
                String lexicon = (String)BLexiconReport.this.languageList.getSelectedItem();
                String module = (String)BLexiconReport.this.languageDetailsTableModel.getValueAt(BLexiconReport.this.languageDetailsTable.getSelection().getRow(), 0);
                if (module == null || lexicon == null) {
                    return;
                }
                BWbShell shell = BLexiconReport.this.getWbShell();
                BLexiconReport.this.tool.key = null;
                if (shell != null) {
                    BLexiconReport.this.tool.lexiconName = lexicon;
                    BLexiconReport.this.tool.moduleName = module;
                    shell.hyperlink(BOrd.make((String)("view:" + BLexiconEditor.TYPE)));
                }
            } else if (event.getClickCount() == 1) {
                BLexiconReport.this.tool.lexiconName = (String)BLexiconReport.this.languageList.getSelectedItem();
                BLexiconReport.this.tool.moduleName = (String)BLexiconReport.this.languageDetailsTableModel.getValueAt(BLexiconReport.this.languageDetailsTable.getSelection().getRow(), 0);
            }
        }
    }

    class LController
    extends ListController {
        LController() {
        }

        protected void itemReleased(BMouseEvent event, int index) {
            super.itemReleased(event, index);
            BLexiconReport.this.showDetails();
        }
    }
}

