/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.devkit.ui.lexicon;

import com.tridium.devkit.ui.lexicon.BLexiconEditorOptions;
import com.tridium.devkit.ui.lexicon.BLexiconEditorValueFilterEnum;
import com.tridium.devkit.ui.lexicon.BLexiconReport;
import com.tridium.devkit.ui.lexicon.BLexiconTool;
import com.tridium.devkit.ui.lexicon.LexiconEditorTableModel;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import com.tridium.workbench.colorchooser.BColorChooser;
import com.tridium.workbench.ord.BFileOrdChooser;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BScrollingWidgetPane;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BColor;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BModuleSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"devkit:LexiconTool"})})
@NiagaraActions(value={@NiagaraAction(name="editLexicon", flags=20), @NiagaraAction(name="filterLexicon", flags=4), @NiagaraAction(name="changeEntry", flags=4), @NiagaraAction(name="saveEntry", flags=4), @NiagaraAction(name="newKey", flags=4), @NiagaraAction(name="colorEntry"), @NiagaraAction(name="ordEntry", flags=4), @NiagaraAction(name="optionChanged", parameterType="BString", defaultValue="BString.DEFAULT")})
public class BLexiconEditor
extends BWbView {
    @Generated
    public static final Action editLexicon = BLexiconEditor.newAction((int)20, null);
    @Generated
    public static final Action filterLexicon = BLexiconEditor.newAction((int)4, null);
    @Generated
    public static final Action changeEntry = BLexiconEditor.newAction((int)4, null);
    @Generated
    public static final Action saveEntry = BLexiconEditor.newAction((int)4, null);
    @Generated
    public static final Action newKey = BLexiconEditor.newAction((int)4, null);
    @Generated
    public static final Action colorEntry = BLexiconEditor.newAction((int)0, null);
    @Generated
    public static final Action ordEntry = BLexiconEditor.newAction((int)4, null);
    @Generated
    public static final Action optionChanged = BLexiconEditor.newAction((int)0, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLexiconEditor.class);
    private static final char[] nibbles = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    BTable table;
    LexiconEditorTableModel tableModel;
    BListDropDown lexiconSelect;
    BListDropDown moduleSelect;
    BListDropDown lexiconSearchSelect;
    Command changeCommand;
    Command saveCommand;
    Command searchCommand;
    Command colorCommand;
    Command ordCommand;
    BTextField keyField;
    BTextEditorPane defaultField;
    BTextEditorPane valueField;
    BTextField searchField;
    BLink lexiconSelectLink;
    BLink moduleSelectLink;
    BCheckBox refValuesFilter;
    BCheckBox accelFilter;
    BCheckBox colorsFilter;
    BCheckBox fontsFilter;
    BCheckBox typesFilter;
    BCheckBox missingFilter;
    BCheckBox completedFilter;
    ToggleCommand hideRefValuesCmd;
    ToggleCommand hideAccelsCmd;
    ToggleCommand hideColorsCmd;
    ToggleCommand hideFontsCmd;
    ToggleCommand hideTypesCmd;
    ToggleCommand showMissingCmd;
    ToggleCommand showCompletedCmd;
    BCheckBox addNewKeyCB;
    Command addNewKeyCmd;
    Context context;
    boolean editorModified = false;
    BLexiconTool tool;
    File lexiconHome = new File(Nre.getNiagaraHome(), "lexicon");
    File lexiconFile;
    Properties lexiconStrings;
    Properties defaultStrings;
    boolean defaultStringsChanged = false;
    private static Logger LOGGER = Logger.getLogger("sys.lexicon");
    static UiLexicon lex = UiLexicon.makeUiLexicon(BLexiconEditor.class);

    @Generated
    public void editLexicon() {
        this.invoke(editLexicon, null, null);
    }

    @Generated
    public void filterLexicon() {
        this.invoke(filterLexicon, null, null);
    }

    @Generated
    public void changeEntry() {
        this.invoke(changeEntry, null, null);
    }

    @Generated
    public void saveEntry() {
        this.invoke(saveEntry, null, null);
    }

    @Generated
    public void newKey() {
        this.invoke(newKey, null, null);
    }

    @Generated
    public void colorEntry() {
        this.invoke(colorEntry, null, null);
    }

    @Generated
    public void ordEntry() {
        this.invoke(ordEntry, null, null);
    }

    @Generated
    public void optionChanged(BString parameter) {
        this.invoke(optionChanged, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLexiconEditor() {
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
    }

    protected void doLoadValue(BObject value, Context cx) {
        this.context = cx;
        this.tool = (BLexiconTool)value;
        String queryLexicon = this.tool.lexiconName;
        String queryModule = this.tool.moduleName;
        String tableKey = this.tool.key;
        this.lexiconSelect = new BListDropDown();
        BList lList = this.lexiconSelect.getList();
        for (String lexicon : BLexiconReport.listLanguages()) {
            lList.addItem((Object)lexicon);
        }
        this.moduleSelect = new BListDropDown();
        BList mList = this.moduleSelect.getList();
        for (String module : BLexiconReport.listModulesWithLexicons()) {
            mList.addItem((Object)module);
        }
        this.hideRefValuesCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.refValuesFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideRefValues(BLexiconEditor.this.hideRefValuesCmd.isSelected());
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        this.hideAccelsCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.accelFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideAccelerators(BLexiconEditor.this.hideAccelsCmd.isSelected());
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        this.hideColorsCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.colorsFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideColors(BLexiconEditor.this.hideColorsCmd.isSelected());
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        this.hideFontsCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.fontsFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideFonts(BLexiconEditor.this.hideFontsCmd.isSelected());
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        this.hideTypesCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.typesFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditorOptions.getDefault().setHideTypes(BLexiconEditor.this.hideTypesCmd.isSelected());
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        this.showMissingCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.missingFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditor.this.setValueFilterCheckboxes(1);
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        this.showCompletedCmd = new ToggleCommand((BWidget)this, BLexiconTool.lexicon.module, "commands.completedFilter"){

            public CommandArtifact doInvoke() {
                BLexiconEditor.this.setValueFilterCheckboxes(2);
                BLexiconEditor.this.filterLexiconMenu();
                return null;
            }
        };
        BFlowPane selectionPane = new BFlowPane();
        selectionPane.setVgap(10);
        selectionPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconTool.lexicon") + ":"));
        selectionPane.add(null, (BValue)this.lexiconSelect);
        selectionPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconTool.module") + ":"));
        selectionPane.add(null, (BValue)this.moduleSelect);
        this.refValuesFilter = new BCheckBox(this.hideRefValuesCmd);
        this.accelFilter = new BCheckBox(this.hideAccelsCmd);
        this.colorsFilter = new BCheckBox(this.hideColorsCmd);
        this.fontsFilter = new BCheckBox(this.hideFontsCmd);
        this.typesFilter = new BCheckBox(this.hideTypesCmd);
        this.missingFilter = new BCheckBox(this.showMissingCmd);
        this.completedFilter = new BCheckBox(this.showCompletedCmd);
        BLexiconEditorOptions options = BLexiconEditorOptions.getDefault();
        this.setCheckboxesFromOptions();
        BFlowPane filterPane = new BFlowPane();
        filterPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("LexiconEditor.hide.label") + ":"));
        filterPane.add(null, (BValue)this.refValuesFilter);
        filterPane.add(null, (BValue)this.accelFilter);
        filterPane.add(null, (BValue)this.colorsFilter);
        filterPane.add(null, (BValue)this.fontsFilter);
        filterPane.add(null, (BValue)this.typesFilter);
        BBorderPane filterBorder = new BBorderPane((BWidget)filterPane, BBorder.ridge);
        filterBorder.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        BFlowPane exclusiveFilterPane = new BFlowPane();
        exclusiveFilterPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("LexiconEditor.show.label") + ":"));
        exclusiveFilterPane.add(null, (BValue)this.missingFilter);
        exclusiveFilterPane.add(null, (BValue)this.completedFilter);
        BBorderPane border = new BBorderPane((BWidget)exclusiveFilterPane, BBorder.ridge);
        border.setPadding(BInsets.make((double)2.0, (double)2.0, (double)2.0, (double)2.0));
        selectionPane.add(null, (BValue)filterBorder);
        selectionPane.add(null, (BValue)border);
        this.lexiconSelectLink = this.linkTo((BComponent)this.lexiconSelect, (Slot)BListDropDown.valueModified, (Slot)editLexicon);
        this.moduleSelectLink = this.linkTo((BComponent)this.moduleSelect, (Slot)BListDropDown.valueModified, (Slot)editLexicon);
        this.linkTo((BComponent)options, (Slot)BLexiconEditorOptions.propertyChanged, (Slot)optionChanged);
        this.lexiconSearchSelect = new BListDropDown();
        BList sList = this.lexiconSearchSelect.getList();
        sList.addItem((Object)BLexiconTool.lexicon.getText("lexiconEditor.key"));
        sList.addItem((Object)BLexiconTool.lexicon.getText("lexiconEditor.default"));
        sList.addItem((Object)BLexiconTool.lexicon.getText("lexiconEditor.value"));
        this.lexiconSearchSelect.setSelectedIndex(0);
        this.searchField = new BTextField("", 40, true);
        this.searchCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.findNext"){

            public CommandArtifact doInvoke() {
                BLexiconEditor.this.doFindNext();
                return null;
            }
        };
        BButton searchButton = new BButton(this.searchCommand, true, true);
        BFlowPane searchPane = new BFlowPane();
        searchPane.setVgap(10);
        searchPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconTool.searchOn") + ":"));
        searchPane.add(null, (BValue)this.lexiconSearchSelect);
        searchPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconTool.searchText") + ":"));
        searchPane.add(null, (BValue)this.searchField);
        searchPane.add(null, (BValue)searchButton);
        String[] cols = new String[]{BLexiconTool.lexicon.getText("lexiconEditor.key"), BLexiconTool.lexicon.getText("lexiconEditor.default"), BLexiconTool.lexicon.getText("lexiconEditor.value")};
        this.tableModel = new LexiconEditorTableModel(cols);
        this.table.setModel((TableModel)new DynamicTableModel((TableModel)this.tableModel));
        this.table.setMultipleSelection(false);
        BEdgePane innerTablePane = new BEdgePane();
        innerTablePane.setCenter((BWidget)this.table);
        BGridPane editPane = new BGridPane(3);
        editPane.setRowAlign(BValign.top);
        BGridPane defaultEditPane = new BGridPane(2);
        BGridPane valueEditPane = new BGridPane(2);
        valueEditPane.setValign(BValign.top);
        valueEditPane.setRowAlign(BValign.top);
        this.keyField = new BTextField("", 40, false);
        this.defaultField = new BTextEditorPane("", 3, 40, false);
        this.valueField = new BTextEditorPane("", 3, 40, true);
        defaultEditPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconEditor.key") + ":"));
        defaultEditPane.add(null, (BValue)this.keyField);
        defaultEditPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconEditor.default") + ":"));
        defaultEditPane.add(null, (BValue)this.defaultField);
        this.colorCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.color"){

            public CommandArtifact doInvoke() {
                BLexiconEditor.this.doColorEntry();
                return null;
            }
        };
        BButton colorButton = new BButton(this.colorCommand, true, true);
        this.ordCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.ord"){

            public CommandArtifact doInvoke() {
                BLexiconEditor.this.doOrdEntry();
                return null;
            }
        };
        BButton ordButton = new BButton(this.ordCommand, true, true);
        BFlowPane buttonPane = new BFlowPane();
        buttonPane.setVgap(10);
        buttonPane.add(null, (BValue)colorButton);
        buttonPane.add(null, (BValue)ordButton);
        valueEditPane.add(null, (BValue)new BLabel(BLexiconTool.lexicon.getText("lexiconEditor.value") + ":"));
        valueEditPane.add(null, (BValue)this.valueField);
        valueEditPane.add(null, (BValue)new BLabel(""));
        valueEditPane.add(null, (BValue)buttonPane);
        editPane.add(null, (BValue)defaultEditPane);
        editPane.add(null, (BValue)valueEditPane);
        this.changeCommand = new Command((BWidget)this, BLexiconTool.lexicon.module, "commands.change"){

            public CommandArtifact doInvoke() {
                BLexiconEditor.this.doChangeEntry();
                return null;
            }
        };
        BButton changeButton = new BButton(this.changeCommand, true, true);
        this.addNewKeyCB = new BCheckBox(BLexiconTool.lexicon.getText("commands.addNewKey.label"), false);
        this.linkTo((BComponent)this.addNewKeyCB, (Slot)BCheckBox.actionPerformed, (Slot)newKey);
        BGridPane editCmdPane = new BGridPane(1);
        editCmdPane.add(null, (BValue)changeButton);
        editCmdPane.add(null, (BValue)this.addNewKeyCB);
        editPane.add(null, (BValue)editCmdPane);
        innerTablePane.setBottom((BWidget)new BBorderPane((BWidget)new BScrollingWidgetPane((BWidget)editPane)));
        BEdgePane tablePane = new BEdgePane();
        tablePane.setTop((BWidget)new BSeparator());
        tablePane.setCenter((BWidget)new BBorderPane((BWidget)innerTablePane));
        tablePane.setBottom((BWidget)new BSeparator());
        BEdgePane controlsPane = new BEdgePane();
        controlsPane.setTop((BWidget)selectionPane);
        BBorderPane searchBorder = new BBorderPane((BWidget)searchPane, BBorder.none);
        searchBorder.setPadding(BInsets.make((double)4.0, (double)0.0, (double)0.0, (double)0.0));
        controlsPane.setBottom((BWidget)searchBorder);
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)new BScrollingWidgetPane((BWidget)controlsPane)));
        pane.setCenter((BWidget)tablePane);
        this.setContent((BWidget)pane);
        if (queryLexicon != null) {
            this.lexiconSelect.setSelectedItem((Object)queryLexicon);
        }
        if (queryModule != null) {
            this.moduleSelect.setSelectedItem((Object)queryModule);
        }
        if (tableKey != null) {
            this.initSelection(tableKey);
        }
    }

    private boolean initSelection(String tableKey) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!((String)this.tableModel.getValueAt(i, 0)).contains(tableKey)) continue;
            this.table.getSelection().deselectAll();
            this.table.getSelection().select(i);
            this.table.ensureRowIsVisible(i);
            this.keyField.setText((String)this.tableModel.getValueAt(i, 0));
            String defaultValue = (String)this.tableModel.getValueAt(i, 1);
            this.defaultField.setText(TextUtil.replace((String)defaultValue, (String)"\\n", (String)"\n"));
            String customValue = (String)this.tableModel.getValueAt(i, 2);
            this.valueField.setText(TextUtil.replace((String)customValue, (String)"\\n", (String)"\n"));
            return true;
        }
        return false;
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (this.editorModified) {
            if (cx != null) {
                throw new IllegalStateException("Don't know if this is supposed to happend?");
            }
            String lexiconName = this.tool.lexiconName;
            String moduleName = this.tool.moduleName;
            File lexiconFolder = new File(this.lexiconHome, lexiconName);
            if (!lexiconFolder.exists() && !lexiconFolder.mkdir()) {
                throw new BajaRuntimeException(String.format("Failed to make directory %s", lexiconName));
            }
            this.lexiconFile = new File(this.lexiconHome, lexiconName + File.separatorChar + moduleName + ".lexicon");
            if (!this.lexiconFile.exists() && !this.lexiconFile.createNewFile()) {
                throw new BajaRuntimeException(String.format("Failed to make lexicon file %s", this.lexiconFile.getAbsolutePath()));
            }
            try (FileOutputStream lexiconOs = new FileOutputStream(this.lexiconFile);){
                this.lexiconStrings.store(lexiconOs, "");
            }
        }
        this.repaint();
        this.editorModified = false;
        return value;
    }

    public BMenu[] getViewMenus() {
        BMenu menu = BLexiconTool.lexicon.buildMenu("menu.lexiconEditor.label");
        BMenu hideSubMenu = BLexiconTool.lexicon.buildMenu("LexiconEditor.hide.label");
        hideSubMenu.add("menuRefValuesFilter", (Command)this.hideRefValuesCmd);
        hideSubMenu.add("menuAccelFilter", (Command)this.hideAccelsCmd);
        hideSubMenu.add("menuColorsFilter", (Command)this.hideColorsCmd);
        hideSubMenu.add("menuFontsFilter", (Command)this.hideFontsCmd);
        hideSubMenu.add("menuTypesFilter", (Command)this.hideTypesCmd);
        BMenu showOnlyMenu = BLexiconTool.lexicon.buildMenu("LexiconEditor.show.label");
        showOnlyMenu.add("menuMissingFilter", (Command)this.showMissingCmd);
        showOnlyMenu.add("menuCompletedFilter", (Command)this.showCompletedCmd);
        menu.add("hideSubMenu", (BValue)new BSubMenuItem((BIMenu)hideSubMenu));
        menu.add("showCompletedSubMenu", (BValue)new BSubMenuItem((BIMenu)showOnlyMenu));
        return new BMenu[]{menu};
    }

    private void setCheckboxesFromOptions() {
        BLexiconEditorOptions options = BLexiconEditorOptions.getDefault();
        this.refValuesFilter.setSelected(options.getHideRefValues());
        this.accelFilter.setSelected(options.getHideAccelerators());
        this.colorsFilter.setSelected(options.getHideColors());
        this.fontsFilter.setSelected(options.getHideFonts());
        this.typesFilter.setSelected(options.getHideTypes());
        int showFilter = options.getShowValueFilter().getOrdinal();
        if (showFilter == 1) {
            this.missingFilter.setSelected(true);
            this.completedFilter.setSelected(false);
        } else if (showFilter == 2) {
            this.missingFilter.setSelected(false);
            this.completedFilter.setSelected(true);
        } else {
            this.missingFilter.setSelected(false);
            this.completedFilter.setSelected(false);
        }
    }

    private void filterLexiconMenu() {
        this.filterLexicon();
    }

    public void doEditLexicon(Context cx) {
        Object in;
        if (this.isModified()) {
            int buttons;
            this.editorModified = true;
            String msg = UiLexicon.bajaui().getText("confirmHyperlink.message", new Object[]{this.tool.lexiconName + " - " + this.tool.moduleName});
            int result = BDialog.confirm((BWidget)this, null, (Object)msg, (int)(buttons = 14));
            if (result == 2) {
                try {
                    while (this.lexiconSelect.isDropDownOpen()) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.lexiconSelectLink.deactivate();
                this.lexiconSelect.setSelectedItem((Object)this.tool.lexiconName);
                this.lexiconSelectLink.activate();
                this.lexiconSelect.repaint();
                try {
                    while (this.moduleSelect.isDropDownOpen()) {
                        Thread.sleep(100L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.moduleSelectLink.deactivate();
                this.moduleSelect.setSelectedItem((Object)this.tool.moduleName);
                this.moduleSelectLink.activate();
                this.moduleSelect.repaint();
                return;
            }
            if (result == 4) {
                this.doSaveEntry();
            } else if (result == 8) {
                this.editorModified = false;
                this.clearModified();
            }
        }
        String lexiconName = (String)this.lexiconSelect.getSelectedItem();
        String moduleName = (String)this.moduleSelect.getSelectedItem();
        this.tool.lexiconName = lexiconName;
        this.tool.moduleName = moduleName;
        if (lexiconName == null || moduleName == null) {
            return;
        }
        try {
            BModule module = Sys.loadModule((String)moduleName);
            this.defaultStrings = new Properties();
            for (ModuleInfo moduleInfo : module.getAllModuleInfo()) {
                BIFileStore defaultStore = module.findStore(new FilePath("module", String.format("/%s.lexicon", moduleInfo.getModulePartName())));
                if (defaultStore == null) continue;
                try (InputStream in2 = defaultStore.getInputStream();){
                    this.defaultStrings.load(in2);
                }
            }
        }
        catch (Exception e) {
            this.defaultStrings = new Properties();
        }
        try {
            BModule module2 = Sys.loadModule((String)moduleName);
            in = Lexicon.getInputStreamFromModule((BModule)module2, (String)lexiconName, (boolean)true);
            Throwable throwable = null;
            try {
                this.defaultStrings.load((InputStream)in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        catch (Exception module2) {
            // empty catch block
        }
        this.lexiconStrings = new Properties();
        this.lexiconFile = new File(this.lexiconHome, lexiconName + File.separatorChar + moduleName + ".lexicon");
        try {
            FileInputStream lexiconIs = new FileInputStream(this.lexiconFile);
            in = null;
            try {
                this.lexiconStrings.load(lexiconIs);
            }
            catch (Throwable throwable) {
                in = throwable;
                throw throwable;
            }
            finally {
                if (lexiconIs != null) {
                    if (in != null) {
                        try {
                            lexiconIs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)in).addSuppressed(throwable);
                        }
                    } else {
                        lexiconIs.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.lexiconStrings = new Properties();
        }
        for (NModule m : AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModuleParts(moduleName)) {
            for (String t : m.getTypeList()) {
                String iconKey;
                String nameKey = t + ".displayName";
                if (!this.defaultStrings.containsKey(nameKey)) {
                    this.defaultStrings.put(nameKey, "");
                }
                if (this.defaultStrings.containsKey(iconKey = t + ".icon")) continue;
                this.defaultStrings.put(iconKey, "");
            }
        }
        try {
            BModule module3 = Sys.loadModule((String)moduleName);
            for (InputStream inputStream : Lexicon.getInputStreamsFromModule((BModule)module3, (String)lexiconName)) {
                this.lexiconStrings.load(inputStream);
                inputStream.close();
            }
        }
        catch (Exception module3) {
            // empty catch block
        }
        Enumeration<Object> keys = this.lexiconStrings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (this.defaultStrings.containsKey(key)) continue;
            this.defaultStrings.put(key, "");
        }
        this.doFilterLexicon();
        if (this.tool.key != null && this.initSelection(this.tool.key)) {
            this.tool.key = null;
            return;
        }
        this.keyField.setText("");
        this.defaultField.setText("");
        this.valueField.setText("");
        this.table.getSelection().deselectAll();
    }

    public void doFilterLexicon() {
        if (this.defaultStrings == null) {
            return;
        }
        this.tableModel.removeAllRows();
        Enumeration<Object> keys = this.defaultStrings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String defaultVal = (String)this.defaultStrings.get(key);
            String lexiconVal = (String)this.lexiconStrings.get(key);
            if (this.refValuesFilter.isSelected() && (defaultVal != null && defaultVal.contains(":/") || lexiconVal != null && lexiconVal.contains(":/")) || this.accelFilter.isSelected() && key.endsWith(".accelerator") || this.colorsFilter.isSelected() && (key.endsWith(".fg") || key.endsWith(".bg")) || this.fontsFilter.isSelected() && (key.endsWith(".font") || key.contains(".font.")) || this.typesFilter.isSelected() && (key.endsWith(".displayName") || key.endsWith(".icon")) && BLexiconEditor.countOccurrences(key, '.') == 1 || this.missingFilter.isSelected() && lexiconVal != null || this.completedFilter.isSelected() && lexiconVal == null) continue;
            if (lexiconVal == null) {
                this.tableModel.addEntry(key, defaultVal, "");
                continue;
            }
            this.tableModel.addEntry(key, defaultVal, lexiconVal);
        }
        this.table.sizeColumnsToFit();
        if (this.tableModel.getRowCount() > 0) {
            this.tableModel.sort();
        }
    }

    static int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public void doNewKey() {
        this.keyField.setEditable(this.addNewKeyCB.getSelected());
        if (this.addNewKeyCB.getSelected()) {
            this.keyField.setText("");
            this.defaultField.setText("");
            this.valueField.setText("");
        } else if (!this.table.getSelection().isEmpty()) {
            int row = this.table.getSelection().getRow();
            this.keyField.setText((String)this.tableModel.getValueAt(row, 0));
            String defaultValue = (String)this.tableModel.getValueAt(row, 1);
            this.defaultField.setText(TextUtil.replace((String)defaultValue, (String)"\\n", (String)"\n"));
            String value = (String)this.tableModel.getValueAt(row, 2);
            this.valueField.setText(TextUtil.replace((String)value, (String)"\\n", (String)"\n"));
        } else {
            this.keyField.setText("");
            this.defaultField.setText("");
            this.valueField.setText("");
        }
    }

    public void doColorEntry() {
        BColor newColor;
        String value = this.valueField.getText();
        value = TextUtil.replace((String)value, (String)"\\n", (String)"\n");
        value = BLexiconEditor.escapeUnicodeEncoding(value);
        BColor currentColor = BColor.DEFAULT;
        if (value != null && !value.equals("")) {
            try {
                currentColor = BColor.make((String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ((newColor = BColorChooser.openInDialog((BWidget)this, (BColor)currentColor)) != null) {
            this.valueField.setText(this.rgbToString(newColor));
        }
    }

    public void doOrdEntry() {
        BOrd ord = BModuleSpace.INSTANCE.getNavOrd();
        try {
            String s = this.valueField.getText();
            if (s.length() > 0 && !s.equals("null")) {
                ord = BOrd.make((BOrd)this.getWbShell().getActiveOrd(), (String)this.valueField.getText());
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        BFileOrdChooser chooser = new BFileOrdChooser();
        BFacets context = BFacets.make((String)"allowLocalAccess", (BIDataValue)BBoolean.FALSE, (String)"allowDefaultAccess", (BIDataValue)BBoolean.FALSE, (String)"allowModuleAccess", (BIDataValue)BBoolean.TRUE);
        chooser.addFilter((IFileFilter)ExtFileFilter.images);
        BObject base = this.getWbShell().getActiveOrdTarget().get();
        ord = chooser.openChooser((BWidget)this.getWbShell(), base, ord, (Context)context);
        if (ord != null) {
            this.valueField.setText(ord.relativizeToSession().toString());
        }
    }

    public void doOptionChanged(BString s) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("doOptionChanged(): " + s);
        }
        this.setCheckboxesFromOptions();
        this.filterLexicon();
    }

    private String rgbToString(BColor c) {
        StringBuilder s = new StringBuilder(9);
        s.append('#');
        int rgb = c.getRGB();
        if (c.getAlpha() != 255) {
            s.append(nibbles[rgb >> 28 & 0xF]);
            s.append(nibbles[rgb >> 24 & 0xF]);
        } else {
            s.append("FF");
        }
        s.append(nibbles[rgb >> 20 & 0xF]);
        s.append(nibbles[rgb >> 16 & 0xF]);
        s.append(nibbles[rgb >> 12 & 0xF]);
        s.append(nibbles[rgb >> 8 & 0xF]);
        s.append(nibbles[rgb >> 4 & 0xF]);
        s.append(nibbles[rgb >> 0 & 0xF]);
        return s.toString();
    }

    public void doFindNext() {
        int searchColumn = this.lexiconSearchSelect.getSelectedIndex();
        String searchString = this.searchField.getText();
        int lexRow = this.table.getSelection().getRow();
        int startRow = 0;
        if (lexRow >= 0 && lexRow < this.tableModel.getRowCount() - 1) {
            startRow = lexRow + 1;
        }
        for (int i = startRow; i < this.tableModel.getRowCount(); ++i) {
            if (!((String)this.tableModel.getValueAt(i, searchColumn)).contains(searchString)) continue;
            this.table.getSelection().deselectAll();
            this.table.getSelection().select(i);
            this.table.ensureRowIsVisible(i);
            this.keyField.setText((String)this.tableModel.getValueAt(i, 0));
            String defaultValue = (String)this.tableModel.getValueAt(i, 1);
            this.defaultField.setText(TextUtil.replace((String)defaultValue, (String)"\\n", (String)"\n"));
            String value = (String)this.tableModel.getValueAt(i, 2);
            this.valueField.setText(TextUtil.replace((String)value, (String)"\\n", (String)"\n"));
            return;
        }
    }

    public synchronized void doChangeEntry() {
        String key = this.keyField.getText();
        if (key == null || key.equals("")) {
            BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconEditor.newKey.error.empty"));
            return;
        }
        String value = this.valueField.getText();
        value = TextUtil.replace((String)value, (String)"\\n", (String)"\n");
        value = BLexiconEditor.escapeUnicodeEncoding(value);
        if (this.addNewKeyCB.getSelected()) {
            if (this.isKeyExisting(key)) {
                BDialog.error((BWidget)this, (Object)Lexicon.make((String)"devkit").getText("lexiconEditor.newKey.error.existing"));
                return;
            }
            if (value != null && !value.equals("")) {
                this.lexiconStrings.put(key, value);
            }
            this.tableModel.addEntry(key, "", value);
        } else {
            int row = this.table.getSelection().getRow();
            if (value != null && !value.equals("")) {
                this.tableModel.set(row, 2, value);
                this.lexiconStrings.setProperty(key, value);
            } else {
                this.tableModel.set(row, 2, "");
                this.lexiconStrings.remove(key);
            }
        }
        this.editorModified = true;
        this.setModified();
        this.table.requestFocus();
    }

    private boolean isKeyExisting(String newKey) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!this.tableModel.getValueAt(i, 0).equals(newKey)) continue;
            return true;
        }
        return false;
    }

    public synchronized void doSaveEntry() {
        BNiagaraWbShell shell = (BNiagaraWbShell)this.getShell();
        shell.save((BWbView)this);
    }

    public synchronized void setValueFilterCheckboxes(int showFilter) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" setValueFilterCheckboxes showFilter = " + showFilter);
        }
        if (this.completedFilter == null || this.missingFilter == null) {
            return;
        }
        if (showFilter == 1 && this.missingFilter.isSelected()) {
            if (this.completedFilter.isSelected()) {
                this.completedFilter.setSelected(false);
            }
        } else if (showFilter == 2 && this.completedFilter.isSelected() && this.missingFilter.isSelected()) {
            this.missingFilter.setSelected(false);
        }
        int newFilterValue = 0;
        if (this.missingFilter.isSelected()) {
            newFilterValue = 1;
        } else if (this.completedFilter.isSelected()) {
            newFilterValue = 2;
        }
        BLexiconEditorOptions.getDefault().setShowValueFilter(BLexiconEditorValueFilterEnum.make(newFilterValue));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" setValueFilterCheckboxes newFilterValue = " + newFilterValue);
        }
    }

    private static String escapeUnicodeEncoding(String text) {
        if (text == null) {
            throw new NullPointerException();
        }
        int b = text.indexOf("\\u", 0);
        if (b == -1) {
            return text;
        }
        return BLexiconEditor.doEscapeUnicodeEncoding(new StringBuilder(text), b).toString();
    }

    private static StringBuilder doEscapeUnicodeEncoding(StringBuilder text, int b) {
        while (b != -1) {
            try {
                String intStr = text.substring(b + 2, b + 6);
                int hexVal = Integer.parseInt(intStr, 16);
                Character charVal = Character.valueOf((char)hexVal);
                text.replace(b, b + 6, charVal.toString());
                b = text.toString().indexOf("\\u", b);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void cellReleased(BMouseEvent event, int row, int column) {
            super.cellReleased(event, row, column);
            BLexiconEditor.this.keyField.setText((String)BLexiconEditor.this.tableModel.getValueAt(row, 0));
            String defaultValue = (String)BLexiconEditor.this.tableModel.getValueAt(row, 1);
            BLexiconEditor.this.defaultField.setText(TextUtil.replace((String)defaultValue, (String)"\\n", (String)"\n"));
            String value = (String)BLexiconEditor.this.tableModel.getValueAt(row, 2);
            BLexiconEditor.this.valueField.setText(TextUtil.replace((String)value, (String)"\\n", (String)"\n"));
            BLexiconEditor.this.valueField.requestFocus();
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            int row = BLexiconEditor.this.table.getSelection().getRow();
            BLexiconEditor.this.keyField.setText((String)BLexiconEditor.this.tableModel.getValueAt(row, 0));
            String defaultValue = (String)BLexiconEditor.this.tableModel.getValueAt(row, 1);
            BLexiconEditor.this.defaultField.setText(TextUtil.replace((String)defaultValue, (String)"\\n", (String)"\n"));
            String value = (String)BLexiconEditor.this.tableModel.getValueAt(row, 2);
            BLexiconEditor.this.valueField.setText(TextUtil.replace((String)value, (String)"\\n", (String)"\n"));
            if (event.getKeyCode() == 10) {
                BLexiconEditor.this.valueField.requestFocus();
            }
        }
    }
}

