/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart.binding;

import javax.baja.chart.BChart;
import javax.baja.chart.ChartModel;
import javax.baja.chart.Series;
import javax.baja.chart.binding.BAxisSpec;
import javax.baja.chart.binding.BoundChartModel;
import javax.baja.gx.BBrush;
import javax.baja.gx.BPen;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="seriesName", type="String", defaultValue=""), @NiagaraProperty(name="xAxis", type="BAxisSpec", defaultValue="new BAxisSpec()"), @NiagaraProperty(name="yAxis", type="BAxisSpec", defaultValue="new BAxisSpec()"), @NiagaraProperty(name="brush", type="BBrush", defaultValue="BBrush.NULL"), @NiagaraProperty(name="pen", type="BPen", defaultValue="BPen.make(1)")})
public abstract class BChartBinding
extends BBinding {
    @Generated
    public static final Property seriesName = BChartBinding.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property xAxis = BChartBinding.newProperty((int)0, (BValue)new BAxisSpec(), null);
    @Generated
    public static final Property yAxis = BChartBinding.newProperty((int)0, (BValue)new BAxisSpec(), null);
    @Generated
    public static final Property brush = BChartBinding.newProperty((int)0, (BValue)BBrush.NULL, null);
    @Generated
    public static final Property pen = BChartBinding.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BChartBinding.class);
    private boolean bound = false;

    @Generated
    public String getSeriesName() {
        return this.getString(seriesName);
    }

    @Generated
    public void setSeriesName(String v) {
        this.setString(seriesName, v, null);
    }

    @Generated
    public BAxisSpec getXAxis() {
        return (BAxisSpec)this.get(xAxis);
    }

    @Generated
    public void setXAxis(BAxisSpec v) {
        this.set(xAxis, (BValue)v, null);
    }

    @Generated
    public BAxisSpec getYAxis() {
        return (BAxisSpec)this.get(yAxis);
    }

    @Generated
    public void setYAxis(BAxisSpec v) {
        this.set(yAxis, (BValue)v, null);
    }

    @Generated
    public BBrush getBrush() {
        return (BBrush)this.get(brush);
    }

    @Generated
    public void setBrush(BBrush v) {
        this.set(brush, (BValue)v, null);
    }

    @Generated
    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    @Generated
    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BChart getChart() {
        BComplex p = this.getParent();
        if (p instanceof BChart) {
            return (BChart)p;
        }
        return null;
    }

    public abstract Series createSeries();

    public void started() {
        super.started();
        this.checkBound();
        if (this.bound) {
            this.valueChanged();
        }
    }

    public void targetChanged() {
        this.checkBound();
        if (this.bound) {
            this.valueChanged();
        }
    }

    private void checkBound() {
        boolean boundState = this.isBound();
        if (this.bound != boundState) {
            this.bound = boundState;
            if (this.bound) {
                this.bound();
            } else {
                this.unbound();
            }
        }
    }

    protected void bound() {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        ChartModel model = chart.getModel();
        if (!(model instanceof BoundChartModel)) {
            return;
        }
        ((BoundChartModel)model).syncBindings();
    }

    protected void unbound() {
        BChart chart = this.getChart();
        if (chart == null) {
            return;
        }
        ChartModel model = chart.getModel();
        if (!(model instanceof BoundChartModel)) {
            return;
        }
        ((BoundChartModel)model).syncBindings();
    }

    protected void valueChanged() {
    }
}

