/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import javax.baja.chart.ChartModel;
import javax.baja.chart.ChartSpec;

public class ChartModelEvent {
    public static final int MODEL_MODIFIED = 0;
    public static final int SPEC_ADDED = 1;
    public static final int SPEC_REMOVED = 2;
    public static final int SPEC_MODIFIED = 3;
    private ChartModel model;
    private int id;
    private ChartSpec spec;

    public ChartModelEvent(ChartModel model, int id) {
        this.model = model;
        this.id = id;
    }

    public ChartModelEvent(ChartModel model, int id, ChartSpec spec) {
        this.model = model;
        this.id = id;
        this.spec = spec;
    }

    public ChartModel getModel() {
        return this.model;
    }

    public int getId() {
        return this.id;
    }

    public ChartSpec getSpec() {
        return this.spec;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(32);
        s.append("ChartModelEvent.");
        switch (this.id) {
            case 0: {
                s.append("modelModified");
                break;
            }
            case 1: {
                s.append("specAdded:");
                s.append(this.spec);
                break;
            }
            case 2: {
                s.append("specRemoved:");
                s.append(this.spec);
                break;
            }
            case 3: {
                s.append("specModified:");
                s.append(this.spec);
                break;
            }
            default: {
                s.append("unrecognizedEventId");
            }
        }
        return s.toString();
    }
}

