/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.ui.UiEnv;
import com.tridium.workbench.file.BExportDialog;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BChartCanvas;
import javax.baja.chart.BChartPane;
import javax.baja.collection.BITable;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class ChartController {
    private boolean traceOn = true;
    private double mx = -1.0;
    private double my = -1.0;
    private static final int ZOOM_NONE = 0;
    private static final int ZOOM_HORIZONTAL = 1;
    private static final int ZOOM_VERTICAL = 2;
    private static final double ZOOM_TOLERANCE = 3.0;
    private static final BModule module = Sys.getModuleForClass(ChartController.class);
    private BChartPane pane;
    private int zoomMode = 0;
    private double zoomX;
    private double zoomY;

    void setPane(BChartPane pane) {
        this.pane = pane;
    }

    public BChartPane getPane() {
        return this.pane;
    }

    public BChartCanvas getCanvas() {
        return this.pane.getCanvas();
    }

    public void mousePressed(BMouseEvent evt) {
        if (evt.getWidget() == this.getCanvas() && this.pane.getZoomEnabled()) {
            if (!UiEnv.get().hasMouse()) {
                this.pane.fireShowPanRequested(null);
            }
            this.zoomX = evt.getX();
            this.zoomY = evt.getY();
        }
    }

    public void mouseReleased(BMouseEvent evt) {
        if (evt.getWidget() == this.getCanvas()) {
            if (evt.isPopupTrigger()) {
                BMenu menu = new BMenu();
                menu.add(null, (Command)new ExportDataCommand(this.pane));
                ExportViewCommand evCommand = new ExportViewCommand(this.pane);
                if (evCommand.isEnabled()) {
                    menu.add(null, (Command)evCommand);
                }
                menu.open((BWidget)this.getCanvas(), evt.getX(), evt.getY());
                return;
            }
            if (this.zoomMode != 0 && this.pane.getZoomEnabled()) {
                double zoomX2 = Math.min(Math.max(evt.getX(), 0.0), this.getCanvas().getWidth());
                double zoomY2 = Math.min(Math.max(evt.getY(), 0.0), this.getCanvas().getHeight());
                if (this.zoomMode == 1) {
                    if (Math.abs(this.zoomX - zoomX2) > 3.0) {
                        if (this.zoomX < zoomX2) {
                            this.getPane().zoomIn(BAxisDimension.x, this.zoomX, zoomX2);
                        } else {
                            this.getPane().zoomIn(BAxisDimension.x, zoomX2, this.zoomX);
                        }
                    }
                } else if (this.zoomMode == 2 && Math.abs(this.zoomY - zoomY2) > 3.0) {
                    if (this.zoomY < zoomY2) {
                        this.getPane().zoomIn(BAxisDimension.y, zoomY2, this.zoomY);
                    } else {
                        this.getPane().zoomIn(BAxisDimension.y, this.zoomY, zoomY2);
                    }
                }
            }
            this.zoomMode = 0;
            this.getCanvas().clearSelection();
            this.getCanvas().repaint();
            this.getPane().repaint();
        }
    }

    public void mouseEntered(BMouseEvent evt) {
        this.mouseMoved(evt);
    }

    public void mouseExited(BMouseEvent evt) {
        this.mx = -1.0;
        this.my = -1.0;
        if (this.traceOn) {
            this.pane.repaint();
        }
    }

    public void mouseMoved(BMouseEvent evt) {
        this.mx = -1.0;
        this.my = -1.0;
        if (this.traceOn) {
            this.pane.repaint();
        }
        this.getCanvas().resetHover();
    }

    public void mouseHover(BMouseEvent evt) {
        this.mx = evt.getX();
        this.my = evt.getY();
        if (this.traceOn) {
            this.pane.repaint();
        }
    }

    public void mouseDragged(BMouseEvent evt) {
        if (evt.getWidget() == this.getCanvas() && evt.isButton1Down() && this.pane.getZoomEnabled()) {
            double zoomX2 = evt.getX();
            double zoomY2 = evt.getY();
            if (this.zoomMode == 0) {
                this.zoomMode = this.getZoomMode(this.zoomX, this.zoomY, zoomX2, zoomY2);
            }
            if (this.zoomMode == 1) {
                this.getCanvas().selectHorizontal(this.zoomX, zoomX2);
            } else if (this.zoomMode == 2) {
                this.getCanvas().selectVertical(this.zoomY, zoomY2);
            }
        }
    }

    public void mouseWheel(BMouseEvent evt) {
    }

    public void mousePulsed(BMouseEvent evt) {
    }

    public void keyPressed(BKeyEvent event) {
        switch (event.getKeyCode()) {
            case 38: {
                this.pane.panUp();
                break;
            }
            case 37: {
                this.pane.panLeft();
                break;
            }
            case 39: {
                this.pane.panRight();
                break;
            }
            case 40: {
                this.pane.panDown();
            }
        }
    }

    public void keyReleased(BKeyEvent event) {
    }

    public void keyTyped(BKeyEvent event) {
    }

    private int getZoomMode(double zoomX1, double zoomY1, double zoomX2, double zoomY2) {
        double deltaY;
        double deltaX = Math.abs(zoomX2 - zoomX1);
        if (deltaX > (deltaY = Math.abs(zoomY2 - zoomY1)) && deltaX > 3.0) {
            return 1;
        }
        if (deltaY > deltaX && deltaY > 3.0) {
            return 2;
        }
        return 0;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setTraceOn(boolean v) {
        this.traceOn = v;
    }

    public double getTraceX() {
        return this.mx;
    }

    public double getTraceY() {
        return this.my;
    }

    class ExportViewCommand
    extends Command {
        ExportViewCommand(BChartPane owner) {
            super((BWidget)owner, module, "commands.export.view");
            this.accelerator = null;
        }

        public synchronized boolean isEnabled() {
            boolean enabled = super.isEnabled();
            if (!enabled) {
                return enabled;
            }
            try {
                BWbView parentView = this.getParentView((BWidget)ChartController.this.pane);
                if (null != parentView) {
                    enabled = BExportDialog.hasExporters((BWbShell)parentView.getWbShell());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return enabled;
        }

        public CommandArtifact doInvoke() throws Exception {
            BITable<?> table = ChartController.this.pane.export();
            if (table == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)Lexicon.make((String)"chart").getText("chart.nothingToExport"));
                return null;
            }
            BWbView parentView = this.getParentView((BWidget)ChartController.this.pane);
            if (null != parentView) {
                return BExportDialog.invoke((BWbShell)parentView.getWbShell(), (boolean)true);
            }
            return null;
        }

        private BWbView getParentView(BWidget widget) {
            if (widget == null) {
                return null;
            }
            if (widget instanceof BWbView) {
                return (BWbView)widget;
            }
            return this.getParentView(widget.getParentWidget());
        }
    }

    class ExportDataCommand
    extends Command {
        ExportDataCommand(BChartPane owner) {
            super((BWidget)owner, module, "commands.export.data");
            this.accelerator = null;
        }

        public CommandArtifact doInvoke() throws Exception {
            BITable<?> table = ChartController.this.pane.export();
            if (table == null) {
                BDialog.error((BWidget)this.getOwner(), (Object)Lexicon.make((String)"chart").getText("chart.nothingToExport"));
                return null;
            }
            return BExportDialog.invoke((BWidget)ChartController.this.pane, ChartController.this.pane.export(), (boolean)true);
        }
    }
}

