/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.chart;

import com.tridium.chart.ChartUtil;
import javax.baja.chart.BAxis;
import javax.baja.chart.BChart;
import javax.baja.chart.BContinuousAxis;
import javax.baja.chart.BDiscreteAxis;
import javax.baja.chart.ChartModel;
import javax.baja.chart.JoinTable;
import javax.baja.chart.Series;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pen", type="BPen", defaultValue="BPen.make(1)"), @NiagaraProperty(name="stroke", type="BBrush", defaultValue="BColor.black.toBrush()")})
public class BBarChart
extends BChart {
    @Generated
    public static final Property pen = BBarChart.newProperty((int)0, (BValue)BPen.make((double)1.0), null);
    @Generated
    public static final Property stroke = BBarChart.newProperty((int)0, (BValue)BColor.black.toBrush(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBarChart.class);
    private JoinTable joinTable;
    private double overlap = 0.2;
    private double clusterWidth;
    private double barWidth;
    private double overlapWidth;

    @Generated
    public BPen getPen() {
        return (BPen)this.get(pen);
    }

    @Generated
    public void setPen(BPen v) {
        this.set(pen, (BValue)v, null);
    }

    @Generated
    public BBrush getStroke() {
        return (BBrush)this.get(stroke);
    }

    @Generated
    public void setStroke(BBrush v) {
        this.set(stroke, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBarChart() {
    }

    public BBarChart(ChartModel model) {
        super(model);
    }

    public void doLayout(BWidget[] kids) {
        double margin;
        double w = this.getWidth();
        double h = this.getHeight();
        if (this.joinTable == null || this.joinTable.getColumnCount() == 0) {
            this.joinTable = JoinTable.make(this.getModel().getAllSeries(), 0);
        }
        int colCount = this.joinTable.getColumnCount();
        int rowCount = this.joinTable.getRowCount();
        ChartModel model = this.getModel();
        if (model.getSpecCount() == 0) {
            return;
        }
        BAxis keyAxis = model.getSpec(0).getXAxis();
        keyAxis.setMinMargin(5.0);
        keyAxis.setMaxMargin(5.0);
        this.clusterWidth = keyAxis.getFullLength() / (double)rowCount;
        if (keyAxis instanceof BDiscreteAxis) {
            Object[] tickValues = keyAxis.getTickValues();
            if (tickValues.length == 1) {
                double spacing = keyAxis.toDisplaySpace(tickValues[0]);
                this.clusterWidth = spacing * 2.0 * 5.0 / 6.0;
            } else {
                double spacing = keyAxis.toDisplaySpace(tickValues[1]) - keyAxis.toDisplaySpace(tickValues[0]);
                this.clusterWidth = spacing * 2.0 / 3.0;
            }
            margin = this.clusterWidth * 2.0 / 3.0;
        } else {
            for (int col = 0; col < colCount; ++col) {
                double minSpacing = Double.MAX_VALUE;
                double prevKeyVal = Double.NEGATIVE_INFINITY;
                for (int row = 0; row < rowCount; ++row) {
                    if (this.joinTable.getValue(row, col) == null) continue;
                    double curKeyVal = keyAxis.toDisplaySpace(this.joinTable.getKey(row));
                    if (curKeyVal - prevKeyVal < minSpacing) {
                        minSpacing = curKeyVal - prevKeyVal;
                    }
                    prevKeyVal = curKeyVal;
                }
                if (!(minSpacing < this.clusterWidth)) continue;
                this.clusterWidth = minSpacing;
            }
            margin = this.clusterWidth / 2.0;
            this.clusterWidth = this.clusterWidth * 2.0 / 3.0;
        }
        this.overlapWidth = this.overlap * (this.clusterWidth / (double)colCount);
        this.barWidth = (this.clusterWidth + this.overlapWidth * (double)(colCount - 1)) / (double)colCount;
        keyAxis.setMinMargin(margin);
        keyAxis.setMaxMargin(margin);
    }

    @Override
    public void doPaint(Graphics g) {
        ChartModel model = this.getModel();
        int specCount = model.getSpecCount();
        if (specCount == 0) {
            return;
        }
        BAxis xaxis = model.getSpec(0).getXAxis();
        int rowCount = this.joinTable.getRowCount();
        int colCount = this.joinTable.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            Object key = this.joinTable.getKey(row);
            double loc = xaxis.toDisplaySpace(key);
            double bar = loc - this.clusterWidth / 2.0;
            for (int col = 0; col < colCount; ++col) {
                Object barValue = this.joinTable.getValue(row, col);
                if (barValue != null) {
                    BAxis yaxis = model.getSpec(col).getYAxis();
                    double zeroLoc = 0.0;
                    if (yaxis instanceof BContinuousAxis) {
                        zeroLoc = yaxis.toDisplaySpace(((BContinuousAxis)yaxis).getZero());
                    } else if (yaxis instanceof BDiscreteAxis) {
                        zeroLoc = yaxis.toDisplaySpace(yaxis.getAxisMin());
                    }
                    double y = yaxis.toDisplaySpace(barValue);
                    Series series = this.joinTable.getSeries(col);
                    BPen pen = series.getPen();
                    g.setPen(pen == null ? BPen.DEFAULT : pen);
                    if (y <= zeroLoc) {
                        g.setBrush(ChartUtil.makeGradient(series.getBrush()));
                        g.fillRect(bar, y, this.barWidth, zeroLoc - y);
                        g.setBrush(this.getStroke());
                        g.strokeRect(bar, y, this.barWidth, zeroLoc - y);
                    } else {
                        g.setBrush(ChartUtil.makeGradient(series.getBrush()));
                        g.fillRect(bar, zeroLoc, this.barWidth, y);
                        g.setBrush(this.getStroke());
                        g.strokeRect(bar, zeroLoc, this.barWidth, y);
                    }
                }
                bar = bar + this.barWidth - this.overlapWidth;
            }
        }
    }
}

