/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import javax.baja.chart.Series;
import javax.baja.chart.binding.BAxisBound;
import javax.baja.chart.binding.BValueChartBinding;
import javax.baja.nre.util.SortUtil;
import javax.baja.status.BIStatusValue;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BoundTimeSeries
extends Series {
    private static final int TIMESTAMP_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final String TIMESTAMP_COLUMN_NAME = Lexicon.make((String)"chart").getText("timestamp");
    private BValueChartBinding binding;
    private BAbsTime minTime;
    private BAbsTime maxTime;
    private Object minValue;
    private Object maxValue;
    private int pageSize = 256;
    private Page[] pages = new Page[0];

    public BoundTimeSeries(BValueChartBinding binding) {
        this.binding = binding;
        this.minTime = BAbsTime.now();
        this.maxTime = this.minTime.add(binding.getTimeWindow());
        this.setBrush(binding.getBrush());
        this.setPen(binding.getPen());
    }

    @Override
    public String getName() {
        String name = this.binding.getSeriesName();
        if (name.length() != 0) {
            return name;
        }
        BObject target = this.binding.get();
        return target.toString();
    }

    @Override
    public Type getColumnType(int col) {
        if (col == 0) {
            return BAbsTime.TYPE;
        }
        if (!this.binding.isBound()) {
            return null;
        }
        BObject value = this.binding.get();
        if (value instanceof BStatusValue) {
            return ((BStatusValue)value).getValueValue().getType();
        }
        return value.getType();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return TIMESTAMP_COLUMN_NAME;
        }
        return this.getName();
    }

    @Override
    public String getColumnDisplayName(int col) {
        return this.getColumnName(col);
    }

    @Override
    public BFacets getColumnFacets(int col) {
        SlotCursor c;
        if (col == 0 || this.binding == null || !this.binding.isBound()) {
            return BFacets.NULL;
        }
        BFacets facets = this.binding.getTarget().getFacets();
        BObject target = this.binding.get();
        if (target instanceof BComplex && (c = ((BComplex)target).getProperties()).next(BFacets.class)) {
            facets = (BFacets)c.get();
        }
        return facets;
    }

    @Override
    public int getRowCount() {
        return this.getSampleCount();
    }

    @Override
    public Object getValue(int row, int col) {
        Sample s = this.getSample(row);
        if (col == 0) {
            return s == null ? null : s.timestamp;
        }
        return s == null ? null : s.value;
    }

    @Override
    public Object getMin(int col) {
        if (col == 0) {
            BAxisBound axisBound = this.binding.getXAxis().getMin();
            if (axisBound.isAuto()) {
                return this.minTime;
            }
            return axisBound.getValue();
        }
        BAxisBound axisBound = this.binding.getYAxis().getMin();
        if (axisBound.isAuto()) {
            return this.minValue;
        }
        return axisBound.getValue();
    }

    @Override
    public Object getMax(int col) {
        if (col == 0) {
            BAxisBound axisBound = this.binding.getXAxis().getMax();
            if (axisBound.isAuto()) {
                return this.maxTime;
            }
            return axisBound.getValue();
        }
        BAxisBound axisBound = this.binding.getYAxis().getMax();
        if (axisBound.isAuto()) {
            return this.maxValue;
        }
        return axisBound.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(BValue value) {
        BAbsTime timestamp = Clock.time();
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            if (this.getSampleCount() == 0) {
                this.addSample(new Sample(timestamp, value));
                this.updateRange((BObject)value);
            } else {
                Sample sample = this.getLastSample();
                if (sample.isChange((BObject)value)) {
                    this.addSample(new Sample(timestamp, value));
                    this.updateRange((BObject)value);
                } else {
                    sample.updateTimestamp(timestamp);
                    this.updateRange((BObject)value);
                }
            }
        }
        BAbsTime first = this.getFirstSample().timestamp;
        BAbsTime last = this.getLastSample().timestamp;
        BRelTime delta = first.delta(last);
        if (delta.compareTo((Object)this.binding.getTimeWindow()) < 0) {
            this.minTime = first;
            this.maxTime = this.minTime.add(this.binding.getTimeWindow());
        } else {
            this.maxTime = BAbsTime.now();
            this.minTime = this.maxTime.subtract(this.binding.getTimeWindow());
        }
        this.trim(this.minTime);
        this.modified();
    }

    private void updateRange(BObject value) {
        value = value instanceof BStatusValue ? ((BStatusValue)value).getValueValue().newCopy(true) : (value instanceof BIStatusValue ? ((BIStatusValue)value).getStatusValue().getValueValue().newCopy(true) : ((BValue)value).newCopy(true));
        int sampleCount = this.getSampleCount();
        if (sampleCount == 1) {
            this.minValue = value;
            this.maxValue = value;
        } else {
            if (SortUtil.compare((Object)value, (Object)this.minValue) < 0) {
                this.minValue = value;
            }
            if (SortUtil.compare((Object)value, (Object)this.maxValue) > 0) {
                this.maxValue = value;
            }
        }
    }

    private int getSampleCount() {
        int pageCount = this.pages.length;
        if (pageCount == 0) {
            return 0;
        }
        if (pageCount == 1) {
            return this.pages[0].count();
        }
        int fullCount = pageCount - 2;
        return this.pages[0].count() + this.pages[pageCount - 1].count() + fullCount * this.pageSize;
    }

    private Sample getSample(int index) {
        int recordIndex = index + this.pages[0].first;
        int pageIndex = recordIndex / this.pageSize;
        return this.pages[pageIndex].samples[recordIndex - this.pageSize * pageIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSample(Sample sample) {
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            this.getWritePage().addSample(sample);
        }
    }

    private Sample getFirstSample() {
        if (this.pages.length == 0) {
            return null;
        }
        return this.pages[0].first();
    }

    private Sample getLastSample() {
        int pageCount = this.pages.length;
        if (pageCount == 0) {
            return null;
        }
        return this.pages[pageCount - 1].last();
    }

    private Page addPage() {
        Page newPage = new Page(this.pageSize);
        Page[] temp = new Page[this.pages.length + 1];
        System.arraycopy(this.pages, 0, temp, 0, this.pages.length);
        temp[temp.length - 1] = newPage;
        this.pages = temp;
        return newPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getWritePage() {
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            int pageCount = this.pages.length;
            if (pageCount == 0 || this.pages[pageCount - 1].isFull()) {
                return this.addPage();
            }
            return this.pages[pageCount - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trim(BAbsTime earliest) {
        BoundTimeSeries boundTimeSeries = this;
        synchronized (boundTimeSeries) {
            Page page;
            int pIndex;
            int sIndex = 0;
            for (pIndex = 0; pIndex < this.pages.length; ++pIndex) {
                page = this.pages[pIndex];
                for (sIndex = page.first; sIndex <= page.last && page.samples[sIndex].timestamp.isBefore(earliest); ++sIndex) {
                }
                if (sIndex <= page.last) break;
            }
            if (pIndex == this.pages.length) {
                this.pages = new Page[0];
            } else {
                if (sIndex != 0) {
                    this.pages[pIndex].first = sIndex - 1;
                } else if (pIndex != 0) {
                    page = this.pages[--pIndex];
                    page.first = page.last = page.samples.length - 1;
                }
                if (pIndex != 0) {
                    Page[] temp = new Page[this.pages.length - pIndex];
                    System.arraycopy(this.pages, pIndex, temp, 0, this.pages.length - pIndex);
                    this.pages = temp;
                }
            }
        }
    }

    private class Page {
        Sample[] samples;
        int first;
        int last;

        public Page(int size) {
            this.samples = new Sample[size];
            this.last = -1;
            this.first = -1;
        }

        public int count() {
            if (this.first == -1) {
                return 0;
            }
            return this.last - this.first + 1;
        }

        public void addSample(Sample sample) {
            if (this.count() == 0) {
                this.samples[0] = sample;
                this.last = 0;
                this.first = 0;
            } else {
                if (this.last == this.samples.length - 1) {
                    throw new IllegalStateException("Page full.");
                }
                ++this.last;
                this.samples[this.last] = sample;
            }
        }

        public boolean isFull() {
            return this.last == this.samples.length - 1;
        }

        public Sample first() {
            return this.samples[this.first];
        }

        public Sample last() {
            return this.samples[this.last];
        }
    }

    private class Sample {
        public BAbsTime timestamp;
        public BObject value;
        public BStatus status;

        public Sample(BAbsTime timestamp, BValue value) {
            value = value.newCopy(true);
            this.timestamp = timestamp;
            if (value instanceof BStatusValue) {
                this.value = ((BStatusValue)value).getValueValue();
                this.status = ((BStatusValue)value).getStatus();
            } else {
                this.value = value;
                this.status = BStatus.ok;
            }
        }

        public boolean isChange(BObject newValue) {
            if (newValue instanceof BStatusValue) {
                return !((BStatusValue)newValue).getValueValue().equals((Object)this.value) || !((BStatusValue)newValue).getStatus().equals((Object)this.status);
            }
            return !newValue.equals((Object)this.value);
        }

        public void updateTimestamp(BAbsTime timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return this.timestamp + ": " + this.value;
        }
    }
}

