/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import javax.baja.chart.binding.BAxisBound;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="updateLayout", flags=4)
public class BNumericAxisBoundFE
extends BWbFieldEditor {
    @Generated
    public static final Action updateLayout = BNumericAxisBoundFE.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNumericAxisBoundFE.class);
    private static final int UNKNOWN = -1;
    private static final int AUTO = 0;
    private static final int FIXED = 1;
    private static final double GAP = 4.0;
    private static final Lexicon lex = Lexicon.make((String)"chart");
    private BAxisBound bound;
    private BTypeSpec valueType = BTypeSpec.NULL;
    private BListDropDown typeSelect = new BListDropDown();
    private BWbFieldEditor valueEditor;

    @Generated
    public void updateLayout() {
        this.invoke(updateLayout, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNumericAxisBoundFE() {
        BList typeList = this.typeSelect.getList();
        typeList.addItem((Object)lex.getText("auto"));
        typeList.addItem((Object)lex.getText("fixed"));
        this.add("typeSelect", (BValue)this.typeSelect);
        this.valueEditor = BWbFieldEditor.makeFor((BObject)BDouble.DEFAULT);
        this.add("valueEditor", (BValue)this.valueEditor);
        this.add("typeLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)setModified));
        this.add("layoutLink", (BValue)new BLink((BComponent)this.typeSelect, (Slot)BListDropDown.valueModified, (Slot)updateLayout));
        this.linkTo("valueEditorModified", (BComponent)this.valueEditor, (Slot)BWbFieldEditor.pluginModified, (Slot)setModified);
    }

    public void doLoadValue(BObject value, Context cx) {
        this.bound = (BAxisBound)value;
        this.showValue(this.bound);
        this.relayout();
    }

    private void showValue(BAxisBound bound) {
        BList typeList = this.typeSelect.getList();
        if (typeList.getSelectedIndex() == -1) {
            if (bound.isAuto()) {
                this.typeSelect.setSelectedIndex(0);
            } else {
                this.typeSelect.setSelectedIndex(1);
            }
        }
        if (typeList.getSelectedIndex() == 1) {
            BFacets facets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)10));
            BSimple val = bound.getValue();
            if (val == null) {
                val = BDouble.DEFAULT;
            }
            this.valueEditor.loadValue((BObject)val, (Context)facets);
        }
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        int type = this.typeSelect.getSelectedIndex();
        if (type == 0) {
            this.bound = BAxisBound.makeAuto();
        } else {
            BSimple fixed = (BSimple)this.valueEditor.saveValue(cx);
            this.bound = BAxisBound.make((BSimple)fixed);
        }
        return this.bound;
    }

    public void doSetReadonly(boolean ro) {
        this.typeSelect.setEnabled(!ro);
        this.valueEditor.setReadonly(ro);
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        this.typeSelect.computePreferredSize();
        this.valueEditor.computePreferredSize();
        pw = this.typeSelect.getPreferredWidth() + 4.0 + this.valueEditor.getPreferredWidth();
        ph = Math.max(this.typeSelect.getPreferredHeight(), this.valueEditor.getPreferredHeight());
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.typeSelect.computePreferredSize();
        this.valueEditor.computePreferredSize();
        this.typeSelect.setBounds(0.0, (h - this.typeSelect.getPreferredHeight()) / 2.0, this.typeSelect.getPreferredWidth(), this.typeSelect.getPreferredHeight());
        int type = this.typeSelect.getSelectedIndex();
        if (type == 1) {
            this.valueEditor.setBounds(this.typeSelect.getPreferredWidth() + 4.0, (h - this.valueEditor.getPreferredHeight()) / 2.0, this.valueEditor.getPreferredWidth(), this.valueEditor.getPreferredHeight());
        } else {
            this.valueEditor.setBounds(0.0, 0.0, 0.0, 0.0);
        }
    }

    public void doUpdateLayout() {
        this.showValue(this.bound);
        this.relayout();
    }
}

