/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.chart;

import java.util.ArrayList;
import javax.baja.chart.BAxis;
import javax.baja.chart.BAxisDimension;
import javax.baja.chart.BAxisLocation;
import javax.baja.chart.BChartPane;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="dimension", type="BAxisDimension", defaultValue="BAxisDimension.x"), @NiagaraProperty(name="location", type="BAxisLocation", defaultValue="BAxisLocation.bottom")})
public class BAxisContainer
extends BWidget {
    @Generated
    public static final Property dimension = BAxisContainer.newProperty((int)0, (BValue)BAxisDimension.x, null);
    @Generated
    public static final Property location = BAxisContainer.newProperty((int)0, (BValue)BAxisLocation.bottom, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAxisContainer.class);
    private ArrayList<BAxis> axes = new ArrayList();
    private double min;
    private double size;

    @Generated
    public BAxisDimension getDimension() {
        return (BAxisDimension)this.get(dimension);
    }

    @Generated
    public void setDimension(BAxisDimension v) {
        this.set(dimension, (BValue)v, null);
    }

    @Generated
    public BAxisLocation getLocation() {
        return (BAxisLocation)this.get(location);
    }

    @Generated
    public void setLocation(BAxisLocation v) {
        this.set(location, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAxisContainer() {
    }

    public BAxisContainer(BAxisDimension dim, BAxisLocation loc) {
        this.setDimension(dim);
        this.setLocation(loc);
    }

    public void reset() {
        int count = this.axes.size();
        for (int i = 0; i < count; ++i) {
            this.axes.get(i).reset();
        }
    }

    public void addAxis(BAxis axis) {
        if (!this.axes.contains((Object)axis)) {
            this.axes.add(axis);
        }
        axis.setDimension(this.getDimension());
        axis.setLocation(this.getLocation());
    }

    public void removeAxis(BAxis axis) {
        this.axes.remove((Object)axis);
    }

    public void removeAllAxes() {
        this.axes.clear();
    }

    public boolean contains(BAxis axis) {
        return this.axes.contains((Object)axis);
    }

    public int getAxisCount() {
        return this.axes.size();
    }

    public BAxis getAxis(int index) {
        return this.axes.get(index);
    }

    public void copyInto(BAxis[] dest, int startIndex) {
        int count = this.axes.size();
        for (int i = 0; i < count; ++i) {
            dest[startIndex++] = this.axes.get(i);
        }
    }

    public BChartPane getChart() {
        BComplex p = this.getParent();
        if (p instanceof BChartPane) {
            return (BChartPane)p;
        }
        return null;
    }

    public void setRange(double min, double size) {
        this.min = min;
        this.size = size;
    }

    public void computePreferredSize() {
        double pw = 0.0;
        double ph = 0.0;
        int count = this.axes.size();
        BAxisDimension dim = this.getDimension();
        if (dim == BAxisDimension.x) {
            for (int i = 0; i < count; ++i) {
                BAxis axis = this.axes.get(i);
                axis.computePreferredSize();
                pw = Math.max(pw, axis.getPreferredWidth());
                ph += axis.getPreferredHeight();
            }
        } else if (dim == BAxisDimension.y) {
            for (int i = 0; i < count; ++i) {
                BAxis axis = this.axes.get(i);
                axis.computePreferredSize();
                pw += axis.getPreferredWidth();
                ph = Math.max(ph, axis.getPreferredHeight());
            }
        }
        this.setPreferredSize(pw, ph);
    }

    public void doLayout(BWidget[] kids) {
        BAxis axis;
        int i;
        int count;
        double w = this.getWidth();
        double h = this.getHeight();
        BAxisDimension dim = this.getDimension();
        if (dim == BAxisDimension.x) {
            count = this.axes.size();
            double y = 0.0;
            for (i = 0; i < count; ++i) {
                axis = this.axes.get(i);
                axis.computePreferredSize();
                axis.setBounds(this.min, y, this.size, axis.getPreferredHeight());
                y += axis.getPreferredHeight();
            }
        } else if (dim == BAxisDimension.y) {
            count = this.axes.size();
            double x = 0.0;
            for (i = 0; i < count; ++i) {
                axis = this.axes.get(i);
                axis.computePreferredSize();
                axis.setBounds(x, this.min, axis.getPreferredWidth(), this.size);
                x += axis.getPreferredWidth();
            }
        }
        count = this.axes.size();
        for (int i2 = 0; i2 < count; ++i2) {
            this.axes.get(i2).doLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int count = this.axes.size();
        for (int i = 0; i < count; ++i) {
            BAxis axis = this.axes.get(i);
            if (i != 0) {
                g.setBrush(BColor.black);
                BAxisDimension dim = this.getDimension();
                if (dim == BAxisDimension.x) {
                    g.strokeLine(axis.getX(), axis.getY(), axis.getX() + axis.getWidth(), axis.getY());
                } else {
                    g.strokeLine(axis.getX(), axis.getY(), axis.getX(), axis.getY() + axis.getHeight());
                }
            }
            g.push();
            g.translate(axis.getX(), axis.getY());
            try {
                axis.getRenderer().paint(g, axis);
                continue;
            }
            finally {
                g.pop();
            }
        }
    }

    public boolean receiveInputEvents() {
        return false;
    }
}

